/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
	v1 "sigs.k8s.io/gateway-api/apis/v1"
)

// RouteNamespacesApplyConfiguration represents an declarative configuration of the RouteNamespaces type for use
// with apply.
type RouteNamespacesApplyConfiguration struct {
	From     *v1.FromNamespaces                      `json:"from,omitempty"`
	Selector *metav1.LabelSelectorApplyConfiguration `json:"selector,omitempty"`
}

// RouteNamespacesApplyConfiguration constructs an declarative configuration of the RouteNamespaces type for use with
// apply.
func RouteNamespaces() *RouteNamespacesApplyConfiguration {
	return &RouteNamespacesApplyConfiguration{}
}

// WithFrom sets the From field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the From field is set to the value of the last call.
func (b *RouteNamespacesApplyConfiguration) WithFrom(value v1.FromNamespaces) *RouteNamespacesApplyConfiguration {
	b.From = &value
	return b
}

// WithSelector sets the Selector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Selector field is set to the value of the last call.
func (b *RouteNamespacesApplyConfiguration) WithSelector(value *metav1.LabelSelectorApplyConfiguration) *RouteNamespacesApplyConfiguration {
	b.Selector = value
	return b
}
