/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ky" locale.
 */
public class LocalizedNamesImpl_ky extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "VI",
        "UM",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "QO",
        "AS",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AF",
        "BS",
        "BD",
        "BB",
        "EH",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "AE",
        "BG",
        "BO",
        "CF",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "HU",
        "VE",
        "VN",
        "GA",
        "HT",
        "GM",
        "GH",
        "GP",
        "GT",
        "DE",
        "GG",
        "GI",
        "GN",
        "GW",
        "NL",
        "HN",
        "HK",
        "GR",
        "GD",
        "GL",
        "GE",
        "GU",
        "GY",
        "DK",
        "DG",
        "DM",
        "DO",
        "EU",
        "JM",
        "JP",
        "NZ",
        "NC",
        "JE",
        "DJ",
        "ZM",
        "ZW",
        "IL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "JO",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "QA",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "US",
        "CX",
        "CU",
        "KW",
        "CK",
        "KG",
        "CN",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "EG",
        "MM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "IM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NF",
        "OM",
        "RU",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "WS",
        "SM",
        "ST",
        "SA",
        "SJ",
        "SC",
        "SN",
        "RS",
        "EA",
        "SL",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SZ",
        "SD",
        "SR",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "KP",
        "MP",
        "TR",
        "TM",
        "TC",
        "ZA",
        "GS",
        "KR",
        "SS",
        "UG",
        "UA",
        "GB",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "HM",
        "HR",
        "TD",
        "CZ",
        "CL",
        "CH",
        "SE",
        "LK",
        "BL",
        "VC",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "GQ",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "UZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Дүйнө");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Түндүк Америка");
    namesMap.put("005", "Түштүк Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Батыш Африка");
    namesMap.put("013", "Борбордук Америка");
    namesMap.put("014", "Чыгыш Африка");
    namesMap.put("015", "Түндүк Африка");
    namesMap.put("017", "Орто Африка");
    namesMap.put("018", "Түштүк Африка");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Американын Түндүгү");
    namesMap.put("029", "Кариб аралдары");
    namesMap.put("030", "Чыгыш Азия");
    namesMap.put("034", "Түштүк Азия");
    namesMap.put("035", "Түштүк-Чыгыш Азия");
    namesMap.put("039", "Түштүк Европа");
    namesMap.put("053", "Австралазия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия Региону");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Борбор Азия");
    namesMap.put("145", "Батыш Азия");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Чыгыш Европа");
    namesMap.put("154", "Түндүк Европа");
    namesMap.put("155", "Батыш Европа");
    namesMap.put("419", "Латын Америкасы");
    namesMap.put("AC", "Асенсион аралы");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Бириккен Араб Эмираттары");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа жана Барбуда");
    namesMap.put("AI", "Ангуила");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктика");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Америка Самоасы");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аланд аралдары");
    namesMap.put("AZ", "Азербайжан");
    namesMap.put("BA", "Босния жана Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белгия");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Ыйык Бартелеми");
    namesMap.put("BM", "Бермуда");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Боливия");
    namesMap.put("BQ", "Кариб Нидерланддары");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багамас");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буве аралдары");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокос (Килиӊ) аралдары");
    namesMap.put("CD", "Конго - Киншаса");
    namesMap.put("CF", "Борбордук Африка Республикасы");
    namesMap.put("CG", "Конго - Браззавил");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот-д-Ивуар");
    namesMap.put("CK", "Кук аралдары");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кытай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "Клиппертон аралы");
    namesMap.put("CR", "Коста Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Капе Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "Крисмас аралы");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехия");
    namesMap.put("DE", "Германия");
    namesMap.put("DG", "Диего Гарсия");
    namesMap.put("DJ", "Жибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминика Республикасы");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута жана Мелилла");
    namesMap.put("EC", "Экуадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Мисир");
    namesMap.put("EH", "Батыш Сахара");
    namesMap.put("ER", "Эритреа");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("EU", "Европа Бирлиги");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фижи");
    namesMap.put("FK", "Фолклэнд аралдары");
    namesMap.put("FM", "Микронезия");
    namesMap.put("FO", "Фарер аралдары");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Улуу Британия");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Француз Гуианасы");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гине");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Экваториялык Гине");
    namesMap.put("GR", "Грекия");
    namesMap.put("GS", "Түштүк Жоржия жана Түштүк Сэндвич аралдары");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гине-Бисау");
    namesMap.put("GY", "Гуиана");
    namesMap.put("HK", "Гоӊ Коӊ Кытай ААА");
    namesMap.put("HM", "Херд жана Макдоналд аралдары");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("IC", "Канар аралдары");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израил");
    namesMap.put("IM", "Мэн аралы");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британиянын Инд Океанындагы аймагы");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Жерси");
    namesMap.put("JM", "Жамайка");
    namesMap.put("JO", "Йордания");
    namesMap.put("JP", "Жапан");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Кыргызстан");
    namesMap.put("KH", "Камбожа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморос");
    namesMap.put("KN", "Ыйык Китс жана Невис");
    namesMap.put("KP", "Түндүк Корея");
    namesMap.put("KR", "Түштүк Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайман Аралдары");
    namesMap.put("KZ", "Казакстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Ыйык Лючия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Ливия");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Монтенегро");
    namesMap.put("MF", "Ыйык Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалл аралдары");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мйанмар (Бурма)");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макау Кытай ААА");
    namesMap.put("MP", "Түндүк Мариана аралдары");
    namesMap.put("MQ", "Мартиник");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Малдивз");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Жаӊы Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк аралы");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Голландия");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуэ");
    namesMap.put("NZ", "Жаӊы Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француз Полинезиясы");
    namesMap.put("PG", "Папуа Жаӊы Гине");
    namesMap.put("PH", "Филиппинз");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Ыйык Пьер жана Микуелон");
    namesMap.put("PN", "Питкэрн аралдары");
    namesMap.put("PR", "Пуэрто Рико");
    namesMap.put("PS", "Палестина аймактары");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Алыскы Океания");
    namesMap.put("RE", "Реюнион");
    namesMap.put("RO", "Румыния");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Орусия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Сауд Арабиясы");
    namesMap.put("SB", "Соломон аралдары");
    namesMap.put("SC", "Сейшелдер");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Ыйык Елена");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Свалбард жана Жан Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сиерра Леоне");
    namesMap.put("SM", "Сан Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринаме");
    namesMap.put("SS", "Түштүк Судан");
    namesMap.put("ST", "Сао Томе жана Принсипе");
    namesMap.put("SV", "Эл Салвадор");
    namesMap.put("SX", "Синт Маартен");
    namesMap.put("SY", "Сирия");
    namesMap.put("SZ", "Суазиленд");
    namesMap.put("TA", "Тристан да Кунья");
    namesMap.put("TC", "Түркс жана Кайкос аралдары");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Франциянын Түштүктөгү аймактары");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Тажикстан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "ТиморЛесте");
    namesMap.put("TM", "Түркмөнстан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Түркия");
    namesMap.put("TT", "Тринидад жана Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайуан");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АКШнын Алыскы аралдары");
    namesMap.put("US", "Кошмо Штаттар");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Өзбекстан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Ыйык Винсент жана Гренадинз");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Британ Виргин аралдары");
    namesMap.put("VI", "АКШ Виржин аралдары");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис жана Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майотт");
    namesMap.put("ZA", "Түштүк Африка Республикасы");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Белгисиз регион");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Дүйнө",
        "002": "Африка",
        "003": "Түндүк Америка",
        "005": "Түштүк Америка",
        "009": "Океания",
        "011": "Батыш Африка",
        "013": "Борбордук Америка",
        "014": "Чыгыш Африка",
        "015": "Түндүк Африка",
        "017": "Орто Африка",
        "018": "Түштүк Африка",
        "019": "Америка",
        "021": "Американын Түндүгү",
        "029": "Кариб аралдары",
        "030": "Чыгыш Азия",
        "034": "Түштүк Азия",
        "035": "Түштүк-Чыгыш Азия",
        "039": "Түштүк Европа",
        "053": "Австралазия",
        "054": "Меланезия",
        "057": "Микронезия Региону",
        "061": "Полинезия",
        "142": "Азия",
        "143": "Борбор Азия",
        "145": "Батыш Азия",
        "150": "Европа",
        "151": "Чыгыш Европа",
        "154": "Түндүк Европа",
        "155": "Батыш Европа",
        "419": "Латын Америкасы",
        "AC": "Асенсион аралы",
        "AD": "Андорра",
        "AE": "Бириккен Араб Эмираттары",
        "AF": "Афганистан",
        "AG": "Антигуа жана Барбуда",
        "AI": "Ангуила",
        "AL": "Албания",
        "AM": "Армения",
        "AO": "Ангола",
        "AQ": "Антарктика",
        "AR": "Аргентина",
        "AS": "Америка Самоасы",
        "AT": "Австрия",
        "AU": "Австралия",
        "AW": "Аруба",
        "AX": "Аланд аралдары",
        "AZ": "Азербайжан",
        "BA": "Босния жана Герцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белгия",
        "BF": "Буркина Фасо",
        "BG": "Болгария",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Ыйык Бартелеми",
        "BM": "Бермуда",
        "BN": "Бруней",
        "BO": "Боливия",
        "BQ": "Кариб Нидерланддары",
        "BR": "Бразилия",
        "BS": "Багамас",
        "BT": "Бутан",
        "BV": "Буве аралдары",
        "BW": "Ботсвана",
        "BY": "Беларусь",
        "BZ": "Белиз",
        "CA": "Канада",
        "CC": "Кокос (Килиӊ) аралдары",
        "CD": "Конго - Киншаса",
        "CF": "Борбордук Африка Республикасы",
        "CG": "Конго - Браззавил",
        "CH": "Швейцария",
        "CI": "Кот-д-Ивуар",
        "CK": "Кук аралдары",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Кытай",
        "CO": "Колумбия",
        "CP": "Клиппертон аралы",
        "CR": "Коста Рика",
        "CU": "Куба",
        "CV": "Капе Верде",
        "CW": "Кюрасао",
        "CX": "Крисмас аралы",
        "CY": "Кипр",
        "CZ": "Чехия",
        "DE": "Германия",
        "DG": "Диего Гарсия",
        "DJ": "Жибути",
        "DK": "Дания",
        "DM": "Доминика",
        "DO": "Доминика Республикасы",
        "DZ": "Алжир",
        "EA": "Сеута жана Мелилла",
        "EC": "Экуадор",
        "EE": "Эстония",
        "EG": "Мисир",
        "EH": "Батыш Сахара",
        "ER": "Эритреа",
        "ES": "Испания",
        "ET": "Эфиопия",
        "EU": "Европа Бирлиги",
        "FI": "Финляндия",
        "FJ": "Фижи",
        "FK": "Фолклэнд аралдары",
        "FM": "Микронезия",
        "FO": "Фарер аралдары",
        "FR": "Франция",
        "GA": "Габон",
        "GB": "Улуу Британия",
        "GD": "Гренада",
        "GE": "Грузия",
        "GF": "Француз Гуианасы",
        "GG": "Гернси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренландия",
        "GM": "Гамбия",
        "GN": "Гине",
        "GP": "Гваделупа",
        "GQ": "Экваториялык Гине",
        "GR": "Грекия",
        "GS": "Түштүк Жоржия жана Түштүк Сэндвич аралдары",
        "GT": "Гватемала",
        "GU": "Гуам",
        "GW": "Гине-Бисау",
        "GY": "Гуиана",
        "HK": "Гоӊ Коӊ Кытай ААА",
        "HM": "Херд жана Макдоналд аралдары",
        "HN": "Гондурас",
        "HR": "Хорватия",
        "HT": "Гаити",
        "HU": "Венгрия",
        "IC": "Канар аралдары",
        "ID": "Индонезия",
        "IE": "Ирландия",
        "IL": "Израил",
        "IM": "Мэн аралы",
        "IN": "Индия",
        "IO": "Британиянын Инд Океанындагы аймагы",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исландия",
        "IT": "Италия",
        "JE": "Жерси",
        "JM": "Жамайка",
        "JO": "Йордания",
        "JP": "Жапан",
        "KE": "Кения",
        "KG": "Кыргызстан",
        "KH": "Камбожа",
        "KI": "Кирибати",
        "KM": "Коморос",
        "KN": "Ыйык Китс жана Невис",
        "KP": "Түндүк Корея",
        "KR": "Түштүк Корея",
        "KW": "Кувейт",
        "KY": "Кайман Аралдары",
        "KZ": "Казакстан",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Ыйык Лючия",
        "LI": "Лихтенштейн",
        "LK": "Шри Ланка",
        "LR": "Либерия",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латвия",
        "LY": "Ливия",
        "MA": "Марокко",
        "MC": "Монако",
        "MD": "Молдова",
        "ME": "Монтенегро",
        "MF": "Ыйык Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршалл аралдары",
        "MK": "Македония",
        "ML": "Мали",
        "MM": "Мйанмар (Бурма)",
        "MN": "Монголия",
        "MO": "Макау Кытай ААА",
        "MP": "Түндүк Мариана аралдары",
        "MQ": "Мартиник",
        "MR": "Мавритания",
        "MS": "Монсеррат",
        "MT": "Мальта",
        "MU": "Маврикий",
        "MV": "Малдивз",
        "MW": "Малави",
        "MX": "Мексика",
        "MY": "Малайзия",
        "MZ": "Мозамбик",
        "NA": "Намибия",
        "NC": "Жаӊы Каледония",
        "NE": "Нигер",
        "NF": "Норфолк аралы",
        "NG": "Нигерия",
        "NI": "Никарагуа",
        "NL": "Голландия",
        "NO": "Норвегия",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ниуэ",
        "NZ": "Жаӊы Зеландия",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Француз Полинезиясы",
        "PG": "Папуа Жаӊы Гине",
        "PH": "Филиппинз",
        "PK": "Пакистан",
        "PL": "Польша",
        "PM": "Ыйык Пьер жана Микуелон",
        "PN": "Питкэрн аралдары",
        "PR": "Пуэрто Рико",
        "PS": "Палестина аймактары",
        "PT": "Португалия",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Алыскы Океания",
        "RE": "Реюнион",
        "RO": "Румыния",
        "RS": "Сербия",
        "RU": "Орусия",
        "RW": "Руанда",
        "SA": "Сауд Арабиясы",
        "SB": "Соломон аралдары",
        "SC": "Сейшелдер",
        "SD": "Судан",
        "SE": "Швеция",
        "SG": "Сингапур",
        "SH": "Ыйык Елена",
        "SI": "Словения",
        "SJ": "Свалбард жана Жан Майен",
        "SK": "Словакия",
        "SL": "Сиерра Леоне",
        "SM": "Сан Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринаме",
        "SS": "Түштүк Судан",
        "ST": "Сао Томе жана Принсипе",
        "SV": "Эл Салвадор",
        "SX": "Синт Маартен",
        "SY": "Сирия",
        "SZ": "Суазиленд",
        "TA": "Тристан да Кунья",
        "TC": "Түркс жана Кайкос аралдары",
        "TD": "Чад",
        "TF": "Франциянын Түштүктөгү аймактары",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Тажикстан",
        "TK": "Токелау",
        "TL": "ТиморЛесте",
        "TM": "Түркмөнстан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Түркия",
        "TT": "Тринидад жана Тобаго",
        "TV": "Тувалу",
        "TW": "Тайуан",
        "TZ": "Танзания",
        "UA": "Украина",
        "UG": "Уганда",
        "UM": "АКШнын Алыскы аралдары",
        "US": "Кошмо Штаттар",
        "UY": "Уругвай",
        "UZ": "Өзбекстан",
        "VA": "Ватикан",
        "VC": "Ыйык Винсент жана Гренадинз",
        "VE": "Венесуэла",
        "VG": "Британ Виргин аралдары",
        "VI": "АКШ Виржин аралдары",
        "VN": "Вьетнам",
        "VU": "Вануату",
        "WF": "Уоллис жана Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Йемен",
        "YT": "Майотт",
        "ZA": "Түштүк Африка Республикасы",
        "ZM": "Замбия",
        "ZW": "Зимбабве",
        "ZZ": "Белгисиз регион"
    };
  }-*/;
}
