// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package ozone

// schema: tools.ozone.verification.defs

import (
	"encoding/json"
	"fmt"

	"github.com/bluesky-social/indigo/lex/util"
)

// VerificationDefs_VerificationView is a "verificationView" in the tools.ozone.verification.defs schema.
//
// Verification data for the associated subject.
type VerificationDefs_VerificationView struct {
	// createdAt: Timestamp when the verification was created.
	CreatedAt string `json:"createdAt" cborgen:"createdAt"`
	// displayName: Display name of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current displayName matches the one at the time of verifying.
	DisplayName string `json:"displayName" cborgen:"displayName"`
	// handle: Handle of the subject the verification applies to at the moment of verifying, which might not be the same at the time of viewing. The verification is only valid if the current handle matches the one at the time of verifying.
	Handle string `json:"handle" cborgen:"handle"`
	// issuer: The user who issued this verification.
	Issuer        string                                        `json:"issuer" cborgen:"issuer"`
	IssuerProfile *util.LexiconTypeDecoder                      `json:"issuerProfile,omitempty" cborgen:"issuerProfile,omitempty"`
	IssuerRepo    *VerificationDefs_VerificationView_IssuerRepo `json:"issuerRepo,omitempty" cborgen:"issuerRepo,omitempty"`
	// revokeReason: Describes the reason for revocation, also indicating that the verification is no longer valid.
	RevokeReason *string `json:"revokeReason,omitempty" cborgen:"revokeReason,omitempty"`
	// revokedAt: Timestamp when the verification was revoked.
	RevokedAt *string `json:"revokedAt,omitempty" cborgen:"revokedAt,omitempty"`
	// revokedBy: The user who revoked this verification.
	RevokedBy *string `json:"revokedBy,omitempty" cborgen:"revokedBy,omitempty"`
	// subject: The subject of the verification.
	Subject        string                                         `json:"subject" cborgen:"subject"`
	SubjectProfile *util.LexiconTypeDecoder                       `json:"subjectProfile,omitempty" cborgen:"subjectProfile,omitempty"`
	SubjectRepo    *VerificationDefs_VerificationView_SubjectRepo `json:"subjectRepo,omitempty" cborgen:"subjectRepo,omitempty"`
	// uri: The AT-URI of the verification record.
	Uri string `json:"uri" cborgen:"uri"`
}

type VerificationDefs_VerificationView_IssuerRepo struct {
	ModerationDefs_RepoViewDetail   *ModerationDefs_RepoViewDetail
	ModerationDefs_RepoViewNotFound *ModerationDefs_RepoViewNotFound
}

func (t *VerificationDefs_VerificationView_IssuerRepo) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_RepoViewDetail != nil {
		t.ModerationDefs_RepoViewDetail.LexiconTypeID = "tools.ozone.moderation.defs#repoViewDetail"
		return json.Marshal(t.ModerationDefs_RepoViewDetail)
	}
	if t.ModerationDefs_RepoViewNotFound != nil {
		t.ModerationDefs_RepoViewNotFound.LexiconTypeID = "tools.ozone.moderation.defs#repoViewNotFound"
		return json.Marshal(t.ModerationDefs_RepoViewNotFound)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *VerificationDefs_VerificationView_IssuerRepo) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#repoViewDetail":
		t.ModerationDefs_RepoViewDetail = new(ModerationDefs_RepoViewDetail)
		return json.Unmarshal(b, t.ModerationDefs_RepoViewDetail)
	case "tools.ozone.moderation.defs#repoViewNotFound":
		t.ModerationDefs_RepoViewNotFound = new(ModerationDefs_RepoViewNotFound)
		return json.Unmarshal(b, t.ModerationDefs_RepoViewNotFound)

	default:
		return nil
	}
}

type VerificationDefs_VerificationView_SubjectRepo struct {
	ModerationDefs_RepoViewDetail   *ModerationDefs_RepoViewDetail
	ModerationDefs_RepoViewNotFound *ModerationDefs_RepoViewNotFound
}

func (t *VerificationDefs_VerificationView_SubjectRepo) MarshalJSON() ([]byte, error) {
	if t.ModerationDefs_RepoViewDetail != nil {
		t.ModerationDefs_RepoViewDetail.LexiconTypeID = "tools.ozone.moderation.defs#repoViewDetail"
		return json.Marshal(t.ModerationDefs_RepoViewDetail)
	}
	if t.ModerationDefs_RepoViewNotFound != nil {
		t.ModerationDefs_RepoViewNotFound.LexiconTypeID = "tools.ozone.moderation.defs#repoViewNotFound"
		return json.Marshal(t.ModerationDefs_RepoViewNotFound)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *VerificationDefs_VerificationView_SubjectRepo) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "tools.ozone.moderation.defs#repoViewDetail":
		t.ModerationDefs_RepoViewDetail = new(ModerationDefs_RepoViewDetail)
		return json.Unmarshal(b, t.ModerationDefs_RepoViewDetail)
	case "tools.ozone.moderation.defs#repoViewNotFound":
		t.ModerationDefs_RepoViewNotFound = new(ModerationDefs_RepoViewNotFound)
		return json.Unmarshal(b, t.ModerationDefs_RepoViewNotFound)

	default:
		return nil
	}
}
