// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package mst

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *NodeData) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Entries ([]mst.EntryData) (slice)
	if len("e") > 1000000 {
		return xerrors.Errorf("Value in field \"e\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("e"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("e")); err != nil {
		return err
	}

	if len(t.Entries) > 8192 {
		return xerrors.Errorf("Slice value in field t.Entries was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Entries))); err != nil {
		return err
	}
	for _, v := range t.Entries {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.Left (cid.Cid) (struct)
	if len("l") > 1000000 {
		return xerrors.Errorf("Value in field \"l\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("l"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("l")); err != nil {
		return err
	}

	if t.Left == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCid(cw, *t.Left); err != nil {
			return xerrors.Errorf("failed to write cid field t.Left: %w", err)
		}
	}

	return nil
}

func (t *NodeData) UnmarshalCBOR(r io.Reader) (err error) {
	*t = NodeData{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("NodeData: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 1)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.Entries ([]mst.EntryData) (slice)
		case "e":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Entries: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Entries = make([]EntryData, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.Entries[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.Entries[i]: %w", err)
						}

					}

				}
			}
			// t.Left (cid.Cid) (struct)
		case "l":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					c, err := cbg.ReadCid(cr)
					if err != nil {
						return xerrors.Errorf("failed to read cid field t.Left: %w", err)
					}

					t.Left = &c
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
func (t *EntryData) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.KeySuffix ([]uint8) (slice)
	if len("k") > 1000000 {
		return xerrors.Errorf("Value in field \"k\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("k"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("k")); err != nil {
		return err
	}

	if len(t.KeySuffix) > 2097152 {
		return xerrors.Errorf("Byte array in field t.KeySuffix was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.KeySuffix))); err != nil {
		return err
	}

	if _, err := cw.Write(t.KeySuffix); err != nil {
		return err
	}

	// t.PrefixLen (int64) (int64)
	if len("p") > 1000000 {
		return xerrors.Errorf("Value in field \"p\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("p"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("p")); err != nil {
		return err
	}

	if t.PrefixLen >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.PrefixLen)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.PrefixLen-1)); err != nil {
			return err
		}
	}

	// t.Right (cid.Cid) (struct)
	if len("t") > 1000000 {
		return xerrors.Errorf("Value in field \"t\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("t"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("t")); err != nil {
		return err
	}

	if t.Right == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCid(cw, *t.Right); err != nil {
			return xerrors.Errorf("failed to write cid field t.Right: %w", err)
		}
	}

	// t.Value (cid.Cid) (struct)
	if len("v") > 1000000 {
		return xerrors.Errorf("Value in field \"v\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("v"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("v")); err != nil {
		return err
	}

	if err := cbg.WriteCid(cw, t.Value); err != nil {
		return xerrors.Errorf("failed to write cid field t.Value: %w", err)
	}

	return nil
}

func (t *EntryData) UnmarshalCBOR(r io.Reader) (err error) {
	*t = EntryData{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("EntryData: map struct too large (%d)", extra)
	}

	n := extra

	nameBuf := make([]byte, 1)
	for i := uint64(0); i < n; i++ {
		nameLen, ok, err := cbg.ReadFullStringIntoBuf(cr, nameBuf, 1000000)
		if err != nil {
			return err
		}

		if !ok {
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(cr, func(cid.Cid) {}); err != nil {
				return err
			}
			continue
		}

		switch string(nameBuf[:nameLen]) {
		// t.KeySuffix ([]uint8) (slice)
		case "k":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.KeySuffix: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.KeySuffix = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.KeySuffix); err != nil {
				return err
			}

			// t.PrefixLen (int64) (int64)
		case "p":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.PrefixLen = int64(extraI)
			}
			// t.Right (cid.Cid) (struct)
		case "t":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					c, err := cbg.ReadCid(cr)
					if err != nil {
						return xerrors.Errorf("failed to read cid field t.Right: %w", err)
					}

					t.Right = &c
				}

			}
			// t.Value (cid.Cid) (struct)
		case "v":

			{

				c, err := cbg.ReadCid(cr)
				if err != nil {
					return xerrors.Errorf("failed to read cid field t.Value: %w", err)
				}

				t.Value = c

			}

		default:
			// Field doesn't exist on this type, so ignore it
			if err := cbg.ScanForLinks(r, func(cid.Cid) {}); err != nil {
				return err
			}
		}
	}

	return nil
}
