// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/cloudfront"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create a function
// Use the following command to create a function.
func ExampleCloudFront_CreateFunction_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.CreateFunctionInput{
		FunctionCode: []byte("function-code.js"),
		FunctionConfig: &cloudfront.FunctionConfig{
			Comment: aws.String("my-function-comment"),
			KeyValueStoreAssociations: &cloudfront.KeyValueStoreAssociations{
				Items: []*cloudfront.KeyValueStoreAssociation{
					{
						KeyValueStoreARN: aws.String("arn:aws:cloudfront::123456789012:key-value-store/54947df8-0e9e-4471-a2f9-9af509fb5889"),
					},
				},
				Quantity: aws.Int64(1),
			},
			Runtime: aws.String("cloudfront-js-2.0"),
		},
		Name: aws.String("my-function-name"),
	}

	result, err := svc.CreateFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeTooManyFunctions:
				fmt.Println(cloudfront.ErrCodeTooManyFunctions, aerr.Error())
			case cloudfront.ErrCodeFunctionAlreadyExists:
				fmt.Println(cloudfront.ErrCodeFunctionAlreadyExists, aerr.Error())
			case cloudfront.ErrCodeFunctionSizeLimitExceeded:
				fmt.Println(cloudfront.ErrCodeFunctionSizeLimitExceeded, aerr.Error())
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			case cloudfront.ErrCodeUnsupportedOperation:
				fmt.Println(cloudfront.ErrCodeUnsupportedOperation, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a KeyValueStore
// Use the following command to create a KeyValueStore.
func ExampleCloudFront_CreateKeyValueStore_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.CreateKeyValueStoreInput{
		Comment: aws.String("my-key-valuestore-comment"),
		ImportSource: &cloudfront.ImportSource{
			SourceARN:  aws.String("arn:aws:s3:::my-bucket/validJSON.json"),
			SourceType: aws.String("S3"),
		},
		Name: aws.String("my-keyvaluestore-name"),
	}

	result, err := svc.CreateKeyValueStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeAccessDenied:
				fmt.Println(cloudfront.ErrCodeAccessDenied, aerr.Error())
			case cloudfront.ErrCodeEntityLimitExceeded:
				fmt.Println(cloudfront.ErrCodeEntityLimitExceeded, aerr.Error())
			case cloudfront.ErrCodeEntityAlreadyExists:
				fmt.Println(cloudfront.ErrCodeEntityAlreadyExists, aerr.Error())
			case cloudfront.ErrCodeEntitySizeLimitExceeded:
				fmt.Println(cloudfront.ErrCodeEntitySizeLimitExceeded, aerr.Error())
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a KeyValueStore
// Use the following command to delete a KeyValueStore.
func ExampleCloudFront_DeleteKeyValueStore_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.DeleteKeyValueStoreInput{
		IfMatch: aws.String("ETVPDKIKX0DER"),
		Name:    aws.String("my-keyvaluestore-name"),
	}

	result, err := svc.DeleteKeyValueStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeAccessDenied:
				fmt.Println(cloudfront.ErrCodeAccessDenied, aerr.Error())
			case cloudfront.ErrCodeInvalidIfMatchVersion:
				fmt.Println(cloudfront.ErrCodeInvalidIfMatchVersion, aerr.Error())
			case cloudfront.ErrCodeEntityNotFound:
				fmt.Println(cloudfront.ErrCodeEntityNotFound, aerr.Error())
			case cloudfront.ErrCodeCannotDeleteEntityWhileInUse:
				fmt.Println(cloudfront.ErrCodeCannotDeleteEntityWhileInUse, aerr.Error())
			case cloudfront.ErrCodePreconditionFailed:
				fmt.Println(cloudfront.ErrCodePreconditionFailed, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a KeyValueStore
// Use the following command to describe a KeyValueStore.
func ExampleCloudFront_DescribeKeyValueStore_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.DescribeKeyValueStoreInput{
		Name: aws.String("my-keyvaluestore-name"),
	}

	result, err := svc.DescribeKeyValueStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeAccessDenied:
				fmt.Println(cloudfront.ErrCodeAccessDenied, aerr.Error())
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			case cloudfront.ErrCodeEntityNotFound:
				fmt.Println(cloudfront.ErrCodeEntityNotFound, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of KeyValueStores
// The following command retrieves a list of KeyValueStores with READY status.
func ExampleCloudFront_ListKeyValueStores_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.ListKeyValueStoresInput{
		Marker:   aws.String(""),
		MaxItems: aws.Int64(100),
		Status:   aws.String("READY"),
	}

	result, err := svc.ListKeyValueStores(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeAccessDenied:
				fmt.Println(cloudfront.ErrCodeAccessDenied, aerr.Error())
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a function
// Use the following command to update a function.
func ExampleCloudFront_UpdateFunction_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.UpdateFunctionInput{
		FunctionCode: []byte("function-code-changed.js"),
		FunctionConfig: &cloudfront.FunctionConfig{
			Comment: aws.String("my-changed-comment"),
			KeyValueStoreAssociations: &cloudfront.KeyValueStoreAssociations{
				Items: []*cloudfront.KeyValueStoreAssociation{
					{
						KeyValueStoreARN: aws.String("arn:aws:cloudfront::123456789012:key-value-store/54947df8-0e9e-4471-a2f9-9af509fb5889"),
					},
				},
				Quantity: aws.Int64(1),
			},
			Runtime: aws.String("cloudfront-js-2.0"),
		},
		IfMatch: aws.String("ETVPDKIKX0DER"),
		Name:    aws.String("my-function-name"),
	}

	result, err := svc.UpdateFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			case cloudfront.ErrCodeInvalidIfMatchVersion:
				fmt.Println(cloudfront.ErrCodeInvalidIfMatchVersion, aerr.Error())
			case cloudfront.ErrCodeNoSuchFunctionExists:
				fmt.Println(cloudfront.ErrCodeNoSuchFunctionExists, aerr.Error())
			case cloudfront.ErrCodePreconditionFailed:
				fmt.Println(cloudfront.ErrCodePreconditionFailed, aerr.Error())
			case cloudfront.ErrCodeFunctionSizeLimitExceeded:
				fmt.Println(cloudfront.ErrCodeFunctionSizeLimitExceeded, aerr.Error())
			case cloudfront.ErrCodeUnsupportedOperation:
				fmt.Println(cloudfront.ErrCodeUnsupportedOperation, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a KeyValueStore
// Use the following command to update a KeyValueStore.
func ExampleCloudFront_UpdateKeyValueStore_shared00() {
	svc := cloudfront.New(session.New())
	input := &cloudfront.UpdateKeyValueStoreInput{
		Comment: aws.String("my-changed-comment"),
		IfMatch: aws.String("ETVPDKIKX0DER"),
		Name:    aws.String("my-keyvaluestore-name"),
	}

	result, err := svc.UpdateKeyValueStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case cloudfront.ErrCodeAccessDenied:
				fmt.Println(cloudfront.ErrCodeAccessDenied, aerr.Error())
			case cloudfront.ErrCodeInvalidArgument:
				fmt.Println(cloudfront.ErrCodeInvalidArgument, aerr.Error())
			case cloudfront.ErrCodeEntityNotFound:
				fmt.Println(cloudfront.ErrCodeEntityNotFound, aerr.Error())
			case cloudfront.ErrCodeInvalidIfMatchVersion:
				fmt.Println(cloudfront.ErrCodeInvalidIfMatchVersion, aerr.Error())
			case cloudfront.ErrCodePreconditionFailed:
				fmt.Println(cloudfront.ErrCodePreconditionFailed, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
