// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/video/transcoder/v1/services.proto

package transcoderpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TranscoderService_CreateJob_FullMethodName         = "/google.cloud.video.transcoder.v1.TranscoderService/CreateJob"
	TranscoderService_ListJobs_FullMethodName          = "/google.cloud.video.transcoder.v1.TranscoderService/ListJobs"
	TranscoderService_GetJob_FullMethodName            = "/google.cloud.video.transcoder.v1.TranscoderService/GetJob"
	TranscoderService_DeleteJob_FullMethodName         = "/google.cloud.video.transcoder.v1.TranscoderService/DeleteJob"
	TranscoderService_CreateJobTemplate_FullMethodName = "/google.cloud.video.transcoder.v1.TranscoderService/CreateJobTemplate"
	TranscoderService_ListJobTemplates_FullMethodName  = "/google.cloud.video.transcoder.v1.TranscoderService/ListJobTemplates"
	TranscoderService_GetJobTemplate_FullMethodName    = "/google.cloud.video.transcoder.v1.TranscoderService/GetJobTemplate"
	TranscoderService_DeleteJobTemplate_FullMethodName = "/google.cloud.video.transcoder.v1.TranscoderService/DeleteJobTemplate"
)

// TranscoderServiceClient is the client API for TranscoderService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TranscoderServiceClient interface {
	// Creates a job in the specified region.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists jobs in the specified region.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Returns the job data.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes a job.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a job template in the specified region.
	CreateJobTemplate(ctx context.Context, in *CreateJobTemplateRequest, opts ...grpc.CallOption) (*JobTemplate, error)
	// Lists job templates in the specified region.
	ListJobTemplates(ctx context.Context, in *ListJobTemplatesRequest, opts ...grpc.CallOption) (*ListJobTemplatesResponse, error)
	// Returns the job template data.
	GetJobTemplate(ctx context.Context, in *GetJobTemplateRequest, opts ...grpc.CallOption) (*JobTemplate, error)
	// Deletes a job template.
	DeleteJobTemplate(ctx context.Context, in *DeleteJobTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type transcoderServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTranscoderServiceClient(cc grpc.ClientConnInterface) TranscoderServiceClient {
	return &transcoderServiceClient{cc}
}

func (c *transcoderServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, TranscoderService_CreateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, TranscoderService_ListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, TranscoderService_GetJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TranscoderService_DeleteJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) CreateJobTemplate(ctx context.Context, in *CreateJobTemplateRequest, opts ...grpc.CallOption) (*JobTemplate, error) {
	out := new(JobTemplate)
	err := c.cc.Invoke(ctx, TranscoderService_CreateJobTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) ListJobTemplates(ctx context.Context, in *ListJobTemplatesRequest, opts ...grpc.CallOption) (*ListJobTemplatesResponse, error) {
	out := new(ListJobTemplatesResponse)
	err := c.cc.Invoke(ctx, TranscoderService_ListJobTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) GetJobTemplate(ctx context.Context, in *GetJobTemplateRequest, opts ...grpc.CallOption) (*JobTemplate, error) {
	out := new(JobTemplate)
	err := c.cc.Invoke(ctx, TranscoderService_GetJobTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transcoderServiceClient) DeleteJobTemplate(ctx context.Context, in *DeleteJobTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TranscoderService_DeleteJobTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TranscoderServiceServer is the server API for TranscoderService service.
// All implementations should embed UnimplementedTranscoderServiceServer
// for forward compatibility
type TranscoderServiceServer interface {
	// Creates a job in the specified region.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Lists jobs in the specified region.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Returns the job data.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Deletes a job.
	DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error)
	// Creates a job template in the specified region.
	CreateJobTemplate(context.Context, *CreateJobTemplateRequest) (*JobTemplate, error)
	// Lists job templates in the specified region.
	ListJobTemplates(context.Context, *ListJobTemplatesRequest) (*ListJobTemplatesResponse, error)
	// Returns the job template data.
	GetJobTemplate(context.Context, *GetJobTemplateRequest) (*JobTemplate, error)
	// Deletes a job template.
	DeleteJobTemplate(context.Context, *DeleteJobTemplateRequest) (*emptypb.Empty, error)
}

// UnimplementedTranscoderServiceServer should be embedded to have forward compatible implementations.
type UnimplementedTranscoderServiceServer struct {
}

func (UnimplementedTranscoderServiceServer) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (UnimplementedTranscoderServiceServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedTranscoderServiceServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedTranscoderServiceServer) DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJob not implemented")
}
func (UnimplementedTranscoderServiceServer) CreateJobTemplate(context.Context, *CreateJobTemplateRequest) (*JobTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJobTemplate not implemented")
}
func (UnimplementedTranscoderServiceServer) ListJobTemplates(context.Context, *ListJobTemplatesRequest) (*ListJobTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobTemplates not implemented")
}
func (UnimplementedTranscoderServiceServer) GetJobTemplate(context.Context, *GetJobTemplateRequest) (*JobTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobTemplate not implemented")
}
func (UnimplementedTranscoderServiceServer) DeleteJobTemplate(context.Context, *DeleteJobTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJobTemplate not implemented")
}

// UnsafeTranscoderServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TranscoderServiceServer will
// result in compilation errors.
type UnsafeTranscoderServiceServer interface {
	mustEmbedUnimplementedTranscoderServiceServer()
}

func RegisterTranscoderServiceServer(s grpc.ServiceRegistrar, srv TranscoderServiceServer) {
	s.RegisterService(&TranscoderService_ServiceDesc, srv)
}

func _TranscoderService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_CreateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_ListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_GetJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_DeleteJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_CreateJobTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).CreateJobTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_CreateJobTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).CreateJobTemplate(ctx, req.(*CreateJobTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_ListJobTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).ListJobTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_ListJobTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).ListJobTemplates(ctx, req.(*ListJobTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_GetJobTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).GetJobTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_GetJobTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).GetJobTemplate(ctx, req.(*GetJobTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TranscoderService_DeleteJobTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TranscoderServiceServer).DeleteJobTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TranscoderService_DeleteJobTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TranscoderServiceServer).DeleteJobTemplate(ctx, req.(*DeleteJobTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TranscoderService_ServiceDesc is the grpc.ServiceDesc for TranscoderService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TranscoderService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.video.transcoder.v1.TranscoderService",
	HandlerType: (*TranscoderServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _TranscoderService_CreateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _TranscoderService_ListJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _TranscoderService_GetJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _TranscoderService_DeleteJob_Handler,
		},
		{
			MethodName: "CreateJobTemplate",
			Handler:    _TranscoderService_CreateJobTemplate_Handler,
		},
		{
			MethodName: "ListJobTemplates",
			Handler:    _TranscoderService_ListJobTemplates_Handler,
		},
		{
			MethodName: "GetJobTemplate",
			Handler:    _TranscoderService_GetJobTemplate_Handler,
		},
		{
			MethodName: "DeleteJobTemplate",
			Handler:    _TranscoderService_DeleteJobTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/video/transcoder/v1/services.proto",
}
