// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/clouddms/v1/clouddms.proto

package clouddmspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataMigrationService_ListMigrationJobs_FullMethodName                    = "/google.cloud.clouddms.v1.DataMigrationService/ListMigrationJobs"
	DataMigrationService_GetMigrationJob_FullMethodName                      = "/google.cloud.clouddms.v1.DataMigrationService/GetMigrationJob"
	DataMigrationService_CreateMigrationJob_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/CreateMigrationJob"
	DataMigrationService_UpdateMigrationJob_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/UpdateMigrationJob"
	DataMigrationService_DeleteMigrationJob_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/DeleteMigrationJob"
	DataMigrationService_StartMigrationJob_FullMethodName                    = "/google.cloud.clouddms.v1.DataMigrationService/StartMigrationJob"
	DataMigrationService_StopMigrationJob_FullMethodName                     = "/google.cloud.clouddms.v1.DataMigrationService/StopMigrationJob"
	DataMigrationService_ResumeMigrationJob_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/ResumeMigrationJob"
	DataMigrationService_PromoteMigrationJob_FullMethodName                  = "/google.cloud.clouddms.v1.DataMigrationService/PromoteMigrationJob"
	DataMigrationService_VerifyMigrationJob_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/VerifyMigrationJob"
	DataMigrationService_RestartMigrationJob_FullMethodName                  = "/google.cloud.clouddms.v1.DataMigrationService/RestartMigrationJob"
	DataMigrationService_GenerateSshScript_FullMethodName                    = "/google.cloud.clouddms.v1.DataMigrationService/GenerateSshScript"
	DataMigrationService_GenerateTcpProxyScript_FullMethodName               = "/google.cloud.clouddms.v1.DataMigrationService/GenerateTcpProxyScript"
	DataMigrationService_ListConnectionProfiles_FullMethodName               = "/google.cloud.clouddms.v1.DataMigrationService/ListConnectionProfiles"
	DataMigrationService_GetConnectionProfile_FullMethodName                 = "/google.cloud.clouddms.v1.DataMigrationService/GetConnectionProfile"
	DataMigrationService_CreateConnectionProfile_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/CreateConnectionProfile"
	DataMigrationService_UpdateConnectionProfile_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/UpdateConnectionProfile"
	DataMigrationService_DeleteConnectionProfile_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/DeleteConnectionProfile"
	DataMigrationService_CreatePrivateConnection_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/CreatePrivateConnection"
	DataMigrationService_GetPrivateConnection_FullMethodName                 = "/google.cloud.clouddms.v1.DataMigrationService/GetPrivateConnection"
	DataMigrationService_ListPrivateConnections_FullMethodName               = "/google.cloud.clouddms.v1.DataMigrationService/ListPrivateConnections"
	DataMigrationService_DeletePrivateConnection_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/DeletePrivateConnection"
	DataMigrationService_GetConversionWorkspace_FullMethodName               = "/google.cloud.clouddms.v1.DataMigrationService/GetConversionWorkspace"
	DataMigrationService_ListConversionWorkspaces_FullMethodName             = "/google.cloud.clouddms.v1.DataMigrationService/ListConversionWorkspaces"
	DataMigrationService_CreateConversionWorkspace_FullMethodName            = "/google.cloud.clouddms.v1.DataMigrationService/CreateConversionWorkspace"
	DataMigrationService_UpdateConversionWorkspace_FullMethodName            = "/google.cloud.clouddms.v1.DataMigrationService/UpdateConversionWorkspace"
	DataMigrationService_DeleteConversionWorkspace_FullMethodName            = "/google.cloud.clouddms.v1.DataMigrationService/DeleteConversionWorkspace"
	DataMigrationService_CreateMappingRule_FullMethodName                    = "/google.cloud.clouddms.v1.DataMigrationService/CreateMappingRule"
	DataMigrationService_DeleteMappingRule_FullMethodName                    = "/google.cloud.clouddms.v1.DataMigrationService/DeleteMappingRule"
	DataMigrationService_ListMappingRules_FullMethodName                     = "/google.cloud.clouddms.v1.DataMigrationService/ListMappingRules"
	DataMigrationService_GetMappingRule_FullMethodName                       = "/google.cloud.clouddms.v1.DataMigrationService/GetMappingRule"
	DataMigrationService_SeedConversionWorkspace_FullMethodName              = "/google.cloud.clouddms.v1.DataMigrationService/SeedConversionWorkspace"
	DataMigrationService_ImportMappingRules_FullMethodName                   = "/google.cloud.clouddms.v1.DataMigrationService/ImportMappingRules"
	DataMigrationService_ConvertConversionWorkspace_FullMethodName           = "/google.cloud.clouddms.v1.DataMigrationService/ConvertConversionWorkspace"
	DataMigrationService_CommitConversionWorkspace_FullMethodName            = "/google.cloud.clouddms.v1.DataMigrationService/CommitConversionWorkspace"
	DataMigrationService_RollbackConversionWorkspace_FullMethodName          = "/google.cloud.clouddms.v1.DataMigrationService/RollbackConversionWorkspace"
	DataMigrationService_ApplyConversionWorkspace_FullMethodName             = "/google.cloud.clouddms.v1.DataMigrationService/ApplyConversionWorkspace"
	DataMigrationService_DescribeDatabaseEntities_FullMethodName             = "/google.cloud.clouddms.v1.DataMigrationService/DescribeDatabaseEntities"
	DataMigrationService_SearchBackgroundJobs_FullMethodName                 = "/google.cloud.clouddms.v1.DataMigrationService/SearchBackgroundJobs"
	DataMigrationService_DescribeConversionWorkspaceRevisions_FullMethodName = "/google.cloud.clouddms.v1.DataMigrationService/DescribeConversionWorkspaceRevisions"
	DataMigrationService_FetchStaticIps_FullMethodName                       = "/google.cloud.clouddms.v1.DataMigrationService/FetchStaticIps"
)

// DataMigrationServiceClient is the client API for DataMigrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataMigrationServiceClient interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error)
	// Generate a TCP Proxy configuration script to configure a cloud-hosted VM
	// running a TCP Proxy.
	GenerateTcpProxyScript(ctx context.Context, in *GenerateTcpProxyScriptRequest, opts ...grpc.CallOption) (*TcpProxyScript, error)
	// Retrieves a list of all connection profiles in a given project and
	// location.
	ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new private connection in a given project and location.
	CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single private connection.
	GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error)
	// Retrieves a list of private connections in a given project and location.
	ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error)
	// Deletes a single Database Migration Service private connection.
	DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single conversion workspace.
	GetConversionWorkspace(ctx context.Context, in *GetConversionWorkspaceRequest, opts ...grpc.CallOption) (*ConversionWorkspace, error)
	// Lists conversion workspaces in a given project and location.
	ListConversionWorkspaces(ctx context.Context, in *ListConversionWorkspacesRequest, opts ...grpc.CallOption) (*ListConversionWorkspacesResponse, error)
	// Creates a new conversion workspace in a given project and location.
	CreateConversionWorkspace(ctx context.Context, in *CreateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single conversion workspace.
	UpdateConversionWorkspace(ctx context.Context, in *UpdateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single conversion workspace.
	DeleteConversionWorkspace(ctx context.Context, in *DeleteConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new mapping rule for a given conversion workspace.
	CreateMappingRule(ctx context.Context, in *CreateMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error)
	// Deletes a single mapping rule.
	DeleteMappingRule(ctx context.Context, in *DeleteMappingRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the mapping rules for a specific conversion workspace.
	ListMappingRules(ctx context.Context, in *ListMappingRulesRequest, opts ...grpc.CallOption) (*ListMappingRulesResponse, error)
	// Gets the details of a mapping rule.
	GetMappingRule(ctx context.Context, in *GetMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error)
	// Imports a snapshot of the source database into the
	// conversion workspace.
	SeedConversionWorkspace(ctx context.Context, in *SeedConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the mapping rules for a given conversion workspace.
	// Supports various formats of external rules files.
	ImportMappingRules(ctx context.Context, in *ImportMappingRulesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a draft tree schema for the destination database.
	ConvertConversionWorkspace(ctx context.Context, in *ConvertConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Marks all the data in the conversion workspace as committed.
	CommitConversionWorkspace(ctx context.Context, in *CommitConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rolls back a conversion workspace to the last committed snapshot.
	RollbackConversionWorkspace(ctx context.Context, in *RollbackConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Applies draft tree onto a specific destination database.
	ApplyConversionWorkspace(ctx context.Context, in *ApplyConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes the database entities tree for a specific conversion workspace
	// and a specific tree type.
	//
	// Database entities are not resources like conversion workspaces or mapping
	// rules, and they can't be created, updated or deleted. Instead, they are
	// simple data objects describing the structure of the client database.
	DescribeDatabaseEntities(ctx context.Context, in *DescribeDatabaseEntitiesRequest, opts ...grpc.CallOption) (*DescribeDatabaseEntitiesResponse, error)
	// Searches/lists the background jobs for a specific
	// conversion workspace.
	//
	// The background jobs are not resources like conversion workspaces or
	// mapping rules, and they can't be created, updated or deleted.
	// Instead, they are a way to expose the data plane jobs log.
	SearchBackgroundJobs(ctx context.Context, in *SearchBackgroundJobsRequest, opts ...grpc.CallOption) (*SearchBackgroundJobsResponse, error)
	// Retrieves a list of committed revisions of a specific conversion
	// workspace.
	DescribeConversionWorkspaceRevisions(ctx context.Context, in *DescribeConversionWorkspaceRevisionsRequest, opts ...grpc.CallOption) (*DescribeConversionWorkspaceRevisionsResponse, error)
	// Fetches a set of static IP addresses that need to be allowlisted by the
	// customer when using the static-IP connectivity method.
	FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error)
}

type dataMigrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataMigrationServiceClient(cc grpc.ClientConnInterface) DataMigrationServiceClient {
	return &dataMigrationServiceClient{cc}
}

func (c *dataMigrationServiceClient) ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error) {
	out := new(ListMigrationJobsResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_ListMigrationJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error) {
	out := new(MigrationJob)
	err := c.cc.Invoke(ctx, DataMigrationService_GetMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_CreateMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_UpdateMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_DeleteMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_StartMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_StopMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_ResumeMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_PromoteMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_VerifyMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_RestartMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error) {
	out := new(SshScript)
	err := c.cc.Invoke(ctx, DataMigrationService_GenerateSshScript_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GenerateTcpProxyScript(ctx context.Context, in *GenerateTcpProxyScriptRequest, opts ...grpc.CallOption) (*TcpProxyScript, error) {
	out := new(TcpProxyScript)
	err := c.cc.Invoke(ctx, DataMigrationService_GenerateTcpProxyScript_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error) {
	out := new(ListConnectionProfilesResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_ListConnectionProfiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error) {
	out := new(ConnectionProfile)
	err := c.cc.Invoke(ctx, DataMigrationService_GetConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_CreateConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_UpdateConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_DeleteConnectionProfile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_CreatePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error) {
	out := new(PrivateConnection)
	err := c.cc.Invoke(ctx, DataMigrationService_GetPrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error) {
	out := new(ListPrivateConnectionsResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_ListPrivateConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_DeletePrivateConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetConversionWorkspace(ctx context.Context, in *GetConversionWorkspaceRequest, opts ...grpc.CallOption) (*ConversionWorkspace, error) {
	out := new(ConversionWorkspace)
	err := c.cc.Invoke(ctx, DataMigrationService_GetConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListConversionWorkspaces(ctx context.Context, in *ListConversionWorkspacesRequest, opts ...grpc.CallOption) (*ListConversionWorkspacesResponse, error) {
	out := new(ListConversionWorkspacesResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_ListConversionWorkspaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateConversionWorkspace(ctx context.Context, in *CreateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_CreateConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateConversionWorkspace(ctx context.Context, in *UpdateConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_UpdateConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteConversionWorkspace(ctx context.Context, in *DeleteConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_DeleteConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateMappingRule(ctx context.Context, in *CreateMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error) {
	out := new(MappingRule)
	err := c.cc.Invoke(ctx, DataMigrationService_CreateMappingRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteMappingRule(ctx context.Context, in *DeleteMappingRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataMigrationService_DeleteMappingRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListMappingRules(ctx context.Context, in *ListMappingRulesRequest, opts ...grpc.CallOption) (*ListMappingRulesResponse, error) {
	out := new(ListMappingRulesResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_ListMappingRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetMappingRule(ctx context.Context, in *GetMappingRuleRequest, opts ...grpc.CallOption) (*MappingRule, error) {
	out := new(MappingRule)
	err := c.cc.Invoke(ctx, DataMigrationService_GetMappingRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) SeedConversionWorkspace(ctx context.Context, in *SeedConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_SeedConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ImportMappingRules(ctx context.Context, in *ImportMappingRulesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_ImportMappingRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ConvertConversionWorkspace(ctx context.Context, in *ConvertConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_ConvertConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CommitConversionWorkspace(ctx context.Context, in *CommitConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_CommitConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) RollbackConversionWorkspace(ctx context.Context, in *RollbackConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_RollbackConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ApplyConversionWorkspace(ctx context.Context, in *ApplyConversionWorkspaceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataMigrationService_ApplyConversionWorkspace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DescribeDatabaseEntities(ctx context.Context, in *DescribeDatabaseEntitiesRequest, opts ...grpc.CallOption) (*DescribeDatabaseEntitiesResponse, error) {
	out := new(DescribeDatabaseEntitiesResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_DescribeDatabaseEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) SearchBackgroundJobs(ctx context.Context, in *SearchBackgroundJobsRequest, opts ...grpc.CallOption) (*SearchBackgroundJobsResponse, error) {
	out := new(SearchBackgroundJobsResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_SearchBackgroundJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DescribeConversionWorkspaceRevisions(ctx context.Context, in *DescribeConversionWorkspaceRevisionsRequest, opts ...grpc.CallOption) (*DescribeConversionWorkspaceRevisionsResponse, error) {
	out := new(DescribeConversionWorkspaceRevisionsResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_DescribeConversionWorkspaceRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) FetchStaticIps(ctx context.Context, in *FetchStaticIpsRequest, opts ...grpc.CallOption) (*FetchStaticIpsResponse, error) {
	out := new(FetchStaticIpsResponse)
	err := c.cc.Invoke(ctx, DataMigrationService_FetchStaticIps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataMigrationServiceServer is the server API for DataMigrationService service.
// All implementations should embed UnimplementedDataMigrationServiceServer
// for forward compatibility
type DataMigrationServiceServer interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunningpb.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunningpb.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunningpb.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunningpb.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunningpb.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunningpb.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunningpb.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunningpb.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error)
	// Generate a TCP Proxy configuration script to configure a cloud-hosted VM
	// running a TCP Proxy.
	GenerateTcpProxyScript(context.Context, *GenerateTcpProxyScriptRequest) (*TcpProxyScript, error)
	// Retrieves a list of all connection profiles in a given project and
	// location.
	ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error)
	// Creates a new private connection in a given project and location.
	CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single private connection.
	GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error)
	// Retrieves a list of private connections in a given project and location.
	ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error)
	// Deletes a single Database Migration Service private connection.
	DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single conversion workspace.
	GetConversionWorkspace(context.Context, *GetConversionWorkspaceRequest) (*ConversionWorkspace, error)
	// Lists conversion workspaces in a given project and location.
	ListConversionWorkspaces(context.Context, *ListConversionWorkspacesRequest) (*ListConversionWorkspacesResponse, error)
	// Creates a new conversion workspace in a given project and location.
	CreateConversionWorkspace(context.Context, *CreateConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single conversion workspace.
	UpdateConversionWorkspace(context.Context, *UpdateConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Deletes a single conversion workspace.
	DeleteConversionWorkspace(context.Context, *DeleteConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Creates a new mapping rule for a given conversion workspace.
	CreateMappingRule(context.Context, *CreateMappingRuleRequest) (*MappingRule, error)
	// Deletes a single mapping rule.
	DeleteMappingRule(context.Context, *DeleteMappingRuleRequest) (*emptypb.Empty, error)
	// Lists the mapping rules for a specific conversion workspace.
	ListMappingRules(context.Context, *ListMappingRulesRequest) (*ListMappingRulesResponse, error)
	// Gets the details of a mapping rule.
	GetMappingRule(context.Context, *GetMappingRuleRequest) (*MappingRule, error)
	// Imports a snapshot of the source database into the
	// conversion workspace.
	SeedConversionWorkspace(context.Context, *SeedConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Imports the mapping rules for a given conversion workspace.
	// Supports various formats of external rules files.
	ImportMappingRules(context.Context, *ImportMappingRulesRequest) (*longrunningpb.Operation, error)
	// Creates a draft tree schema for the destination database.
	ConvertConversionWorkspace(context.Context, *ConvertConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Marks all the data in the conversion workspace as committed.
	CommitConversionWorkspace(context.Context, *CommitConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Rolls back a conversion workspace to the last committed snapshot.
	RollbackConversionWorkspace(context.Context, *RollbackConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Applies draft tree onto a specific destination database.
	ApplyConversionWorkspace(context.Context, *ApplyConversionWorkspaceRequest) (*longrunningpb.Operation, error)
	// Describes the database entities tree for a specific conversion workspace
	// and a specific tree type.
	//
	// Database entities are not resources like conversion workspaces or mapping
	// rules, and they can't be created, updated or deleted. Instead, they are
	// simple data objects describing the structure of the client database.
	DescribeDatabaseEntities(context.Context, *DescribeDatabaseEntitiesRequest) (*DescribeDatabaseEntitiesResponse, error)
	// Searches/lists the background jobs for a specific
	// conversion workspace.
	//
	// The background jobs are not resources like conversion workspaces or
	// mapping rules, and they can't be created, updated or deleted.
	// Instead, they are a way to expose the data plane jobs log.
	SearchBackgroundJobs(context.Context, *SearchBackgroundJobsRequest) (*SearchBackgroundJobsResponse, error)
	// Retrieves a list of committed revisions of a specific conversion
	// workspace.
	DescribeConversionWorkspaceRevisions(context.Context, *DescribeConversionWorkspaceRevisionsRequest) (*DescribeConversionWorkspaceRevisionsResponse, error)
	// Fetches a set of static IP addresses that need to be allowlisted by the
	// customer when using the static-IP connectivity method.
	FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error)
}

// UnimplementedDataMigrationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataMigrationServiceServer struct {
}

func (UnimplementedDataMigrationServiceServer) ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigrationJobs not implemented")
}
func (UnimplementedDataMigrationServiceServer) GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartMigrationJob not implemented")
}
func (UnimplementedDataMigrationServiceServer) GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSshScript not implemented")
}
func (UnimplementedDataMigrationServiceServer) GenerateTcpProxyScript(context.Context, *GenerateTcpProxyScriptRequest) (*TcpProxyScript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateTcpProxyScript not implemented")
}
func (UnimplementedDataMigrationServiceServer) ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectionProfiles not implemented")
}
func (UnimplementedDataMigrationServiceServer) GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectionProfile not implemented")
}
func (UnimplementedDataMigrationServiceServer) CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectionProfile not implemented")
}
func (UnimplementedDataMigrationServiceServer) UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectionProfile not implemented")
}
func (UnimplementedDataMigrationServiceServer) DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectionProfile not implemented")
}
func (UnimplementedDataMigrationServiceServer) CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateConnection not implemented")
}
func (UnimplementedDataMigrationServiceServer) GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConnection not implemented")
}
func (UnimplementedDataMigrationServiceServer) ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnections not implemented")
}
func (UnimplementedDataMigrationServiceServer) DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateConnection not implemented")
}
func (UnimplementedDataMigrationServiceServer) GetConversionWorkspace(context.Context, *GetConversionWorkspaceRequest) (*ConversionWorkspace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) ListConversionWorkspaces(context.Context, *ListConversionWorkspacesRequest) (*ListConversionWorkspacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionWorkspaces not implemented")
}
func (UnimplementedDataMigrationServiceServer) CreateConversionWorkspace(context.Context, *CreateConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) UpdateConversionWorkspace(context.Context, *UpdateConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) DeleteConversionWorkspace(context.Context, *DeleteConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) CreateMappingRule(context.Context, *CreateMappingRuleRequest) (*MappingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMappingRule not implemented")
}
func (UnimplementedDataMigrationServiceServer) DeleteMappingRule(context.Context, *DeleteMappingRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMappingRule not implemented")
}
func (UnimplementedDataMigrationServiceServer) ListMappingRules(context.Context, *ListMappingRulesRequest) (*ListMappingRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMappingRules not implemented")
}
func (UnimplementedDataMigrationServiceServer) GetMappingRule(context.Context, *GetMappingRuleRequest) (*MappingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMappingRule not implemented")
}
func (UnimplementedDataMigrationServiceServer) SeedConversionWorkspace(context.Context, *SeedConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SeedConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) ImportMappingRules(context.Context, *ImportMappingRulesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportMappingRules not implemented")
}
func (UnimplementedDataMigrationServiceServer) ConvertConversionWorkspace(context.Context, *ConvertConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConvertConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) CommitConversionWorkspace(context.Context, *CommitConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) RollbackConversionWorkspace(context.Context, *RollbackConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) ApplyConversionWorkspace(context.Context, *ApplyConversionWorkspaceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyConversionWorkspace not implemented")
}
func (UnimplementedDataMigrationServiceServer) DescribeDatabaseEntities(context.Context, *DescribeDatabaseEntitiesRequest) (*DescribeDatabaseEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeDatabaseEntities not implemented")
}
func (UnimplementedDataMigrationServiceServer) SearchBackgroundJobs(context.Context, *SearchBackgroundJobsRequest) (*SearchBackgroundJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchBackgroundJobs not implemented")
}
func (UnimplementedDataMigrationServiceServer) DescribeConversionWorkspaceRevisions(context.Context, *DescribeConversionWorkspaceRevisionsRequest) (*DescribeConversionWorkspaceRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeConversionWorkspaceRevisions not implemented")
}
func (UnimplementedDataMigrationServiceServer) FetchStaticIps(context.Context, *FetchStaticIpsRequest) (*FetchStaticIpsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchStaticIps not implemented")
}

// UnsafeDataMigrationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataMigrationServiceServer will
// result in compilation errors.
type UnsafeDataMigrationServiceServer interface {
	mustEmbedUnimplementedDataMigrationServiceServer()
}

func RegisterDataMigrationServiceServer(s grpc.ServiceRegistrar, srv DataMigrationServiceServer) {
	s.RegisterService(&DataMigrationService_ServiceDesc, srv)
}

func _DataMigrationService_ListMigrationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigrationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ListMigrationJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, req.(*ListMigrationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GetMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, req.(*GetMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CreateMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, req.(*CreateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_UpdateMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, req.(*UpdateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DeleteMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, req.(*DeleteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_StartMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, req.(*StartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StopMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_StopMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, req.(*StopMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ResumeMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ResumeMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, req.(*ResumeMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_PromoteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PromoteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_PromoteMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, req.(*PromoteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_VerifyMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_VerifyMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, req.(*VerifyMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_RestartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_RestartMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, req.(*RestartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GenerateSshScript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSshScriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GenerateSshScript_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, req.(*GenerateSshScriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GenerateTcpProxyScript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateTcpProxyScriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GenerateTcpProxyScript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GenerateTcpProxyScript_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GenerateTcpProxyScript(ctx, req.(*GenerateTcpProxyScriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListConnectionProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ListConnectionProfiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, req.(*ListConnectionProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GetConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, req.(*GetConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CreateConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, req.(*CreateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_UpdateConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, req.(*UpdateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DeleteConnectionProfile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, req.(*DeleteConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CreatePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreatePrivateConnection(ctx, req.(*CreatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetPrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetPrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GetPrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetPrivateConnection(ctx, req.(*GetPrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListPrivateConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListPrivateConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ListPrivateConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListPrivateConnections(ctx, req.(*ListPrivateConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeletePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeletePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DeletePrivateConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeletePrivateConnection(ctx, req.(*DeletePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GetConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetConversionWorkspace(ctx, req.(*GetConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListConversionWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListConversionWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ListConversionWorkspaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListConversionWorkspaces(ctx, req.(*ListConversionWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CreateConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateConversionWorkspace(ctx, req.(*CreateConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_UpdateConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateConversionWorkspace(ctx, req.(*UpdateConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DeleteConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteConversionWorkspace(ctx, req.(*DeleteConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CreateMappingRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateMappingRule(ctx, req.(*CreateMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DeleteMappingRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteMappingRule(ctx, req.(*DeleteMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListMappingRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMappingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListMappingRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ListMappingRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListMappingRules(ctx, req.(*ListMappingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetMappingRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMappingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetMappingRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_GetMappingRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetMappingRule(ctx, req.(*GetMappingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_SeedConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SeedConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).SeedConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_SeedConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).SeedConversionWorkspace(ctx, req.(*SeedConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ImportMappingRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportMappingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ImportMappingRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ImportMappingRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ImportMappingRules(ctx, req.(*ImportMappingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ConvertConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConvertConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ConvertConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ConvertConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ConvertConversionWorkspace(ctx, req.(*ConvertConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CommitConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CommitConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_CommitConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CommitConversionWorkspace(ctx, req.(*CommitConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_RollbackConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).RollbackConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_RollbackConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).RollbackConversionWorkspace(ctx, req.(*RollbackConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ApplyConversionWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyConversionWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ApplyConversionWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_ApplyConversionWorkspace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ApplyConversionWorkspace(ctx, req.(*ApplyConversionWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DescribeDatabaseEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeDatabaseEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DescribeDatabaseEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DescribeDatabaseEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DescribeDatabaseEntities(ctx, req.(*DescribeDatabaseEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_SearchBackgroundJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchBackgroundJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).SearchBackgroundJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_SearchBackgroundJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).SearchBackgroundJobs(ctx, req.(*SearchBackgroundJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DescribeConversionWorkspaceRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribeConversionWorkspaceRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DescribeConversionWorkspaceRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_DescribeConversionWorkspaceRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DescribeConversionWorkspaceRevisions(ctx, req.(*DescribeConversionWorkspaceRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_FetchStaticIps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchStaticIpsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).FetchStaticIps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataMigrationService_FetchStaticIps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).FetchStaticIps(ctx, req.(*FetchStaticIpsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataMigrationService_ServiceDesc is the grpc.ServiceDesc for DataMigrationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataMigrationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.clouddms.v1.DataMigrationService",
	HandlerType: (*DataMigrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMigrationJobs",
			Handler:    _DataMigrationService_ListMigrationJobs_Handler,
		},
		{
			MethodName: "GetMigrationJob",
			Handler:    _DataMigrationService_GetMigrationJob_Handler,
		},
		{
			MethodName: "CreateMigrationJob",
			Handler:    _DataMigrationService_CreateMigrationJob_Handler,
		},
		{
			MethodName: "UpdateMigrationJob",
			Handler:    _DataMigrationService_UpdateMigrationJob_Handler,
		},
		{
			MethodName: "DeleteMigrationJob",
			Handler:    _DataMigrationService_DeleteMigrationJob_Handler,
		},
		{
			MethodName: "StartMigrationJob",
			Handler:    _DataMigrationService_StartMigrationJob_Handler,
		},
		{
			MethodName: "StopMigrationJob",
			Handler:    _DataMigrationService_StopMigrationJob_Handler,
		},
		{
			MethodName: "ResumeMigrationJob",
			Handler:    _DataMigrationService_ResumeMigrationJob_Handler,
		},
		{
			MethodName: "PromoteMigrationJob",
			Handler:    _DataMigrationService_PromoteMigrationJob_Handler,
		},
		{
			MethodName: "VerifyMigrationJob",
			Handler:    _DataMigrationService_VerifyMigrationJob_Handler,
		},
		{
			MethodName: "RestartMigrationJob",
			Handler:    _DataMigrationService_RestartMigrationJob_Handler,
		},
		{
			MethodName: "GenerateSshScript",
			Handler:    _DataMigrationService_GenerateSshScript_Handler,
		},
		{
			MethodName: "GenerateTcpProxyScript",
			Handler:    _DataMigrationService_GenerateTcpProxyScript_Handler,
		},
		{
			MethodName: "ListConnectionProfiles",
			Handler:    _DataMigrationService_ListConnectionProfiles_Handler,
		},
		{
			MethodName: "GetConnectionProfile",
			Handler:    _DataMigrationService_GetConnectionProfile_Handler,
		},
		{
			MethodName: "CreateConnectionProfile",
			Handler:    _DataMigrationService_CreateConnectionProfile_Handler,
		},
		{
			MethodName: "UpdateConnectionProfile",
			Handler:    _DataMigrationService_UpdateConnectionProfile_Handler,
		},
		{
			MethodName: "DeleteConnectionProfile",
			Handler:    _DataMigrationService_DeleteConnectionProfile_Handler,
		},
		{
			MethodName: "CreatePrivateConnection",
			Handler:    _DataMigrationService_CreatePrivateConnection_Handler,
		},
		{
			MethodName: "GetPrivateConnection",
			Handler:    _DataMigrationService_GetPrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnections",
			Handler:    _DataMigrationService_ListPrivateConnections_Handler,
		},
		{
			MethodName: "DeletePrivateConnection",
			Handler:    _DataMigrationService_DeletePrivateConnection_Handler,
		},
		{
			MethodName: "GetConversionWorkspace",
			Handler:    _DataMigrationService_GetConversionWorkspace_Handler,
		},
		{
			MethodName: "ListConversionWorkspaces",
			Handler:    _DataMigrationService_ListConversionWorkspaces_Handler,
		},
		{
			MethodName: "CreateConversionWorkspace",
			Handler:    _DataMigrationService_CreateConversionWorkspace_Handler,
		},
		{
			MethodName: "UpdateConversionWorkspace",
			Handler:    _DataMigrationService_UpdateConversionWorkspace_Handler,
		},
		{
			MethodName: "DeleteConversionWorkspace",
			Handler:    _DataMigrationService_DeleteConversionWorkspace_Handler,
		},
		{
			MethodName: "CreateMappingRule",
			Handler:    _DataMigrationService_CreateMappingRule_Handler,
		},
		{
			MethodName: "DeleteMappingRule",
			Handler:    _DataMigrationService_DeleteMappingRule_Handler,
		},
		{
			MethodName: "ListMappingRules",
			Handler:    _DataMigrationService_ListMappingRules_Handler,
		},
		{
			MethodName: "GetMappingRule",
			Handler:    _DataMigrationService_GetMappingRule_Handler,
		},
		{
			MethodName: "SeedConversionWorkspace",
			Handler:    _DataMigrationService_SeedConversionWorkspace_Handler,
		},
		{
			MethodName: "ImportMappingRules",
			Handler:    _DataMigrationService_ImportMappingRules_Handler,
		},
		{
			MethodName: "ConvertConversionWorkspace",
			Handler:    _DataMigrationService_ConvertConversionWorkspace_Handler,
		},
		{
			MethodName: "CommitConversionWorkspace",
			Handler:    _DataMigrationService_CommitConversionWorkspace_Handler,
		},
		{
			MethodName: "RollbackConversionWorkspace",
			Handler:    _DataMigrationService_RollbackConversionWorkspace_Handler,
		},
		{
			MethodName: "ApplyConversionWorkspace",
			Handler:    _DataMigrationService_ApplyConversionWorkspace_Handler,
		},
		{
			MethodName: "DescribeDatabaseEntities",
			Handler:    _DataMigrationService_DescribeDatabaseEntities_Handler,
		},
		{
			MethodName: "SearchBackgroundJobs",
			Handler:    _DataMigrationService_SearchBackgroundJobs_Handler,
		},
		{
			MethodName: "DescribeConversionWorkspaceRevisions",
			Handler:    _DataMigrationService_DescribeConversionWorkspaceRevisions_Handler,
		},
		{
			MethodName: "FetchStaticIps",
			Handler:    _DataMigrationService_FetchStaticIps_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/clouddms/v1/clouddms.proto",
}
