// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/osconfig/v1beta/osconfig_service.proto

package osconfigpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	OsConfigService_ExecutePatchJob_FullMethodName             = "/google.cloud.osconfig.v1beta.OsConfigService/ExecutePatchJob"
	OsConfigService_GetPatchJob_FullMethodName                 = "/google.cloud.osconfig.v1beta.OsConfigService/GetPatchJob"
	OsConfigService_CancelPatchJob_FullMethodName              = "/google.cloud.osconfig.v1beta.OsConfigService/CancelPatchJob"
	OsConfigService_ListPatchJobs_FullMethodName               = "/google.cloud.osconfig.v1beta.OsConfigService/ListPatchJobs"
	OsConfigService_ListPatchJobInstanceDetails_FullMethodName = "/google.cloud.osconfig.v1beta.OsConfigService/ListPatchJobInstanceDetails"
	OsConfigService_CreatePatchDeployment_FullMethodName       = "/google.cloud.osconfig.v1beta.OsConfigService/CreatePatchDeployment"
	OsConfigService_GetPatchDeployment_FullMethodName          = "/google.cloud.osconfig.v1beta.OsConfigService/GetPatchDeployment"
	OsConfigService_ListPatchDeployments_FullMethodName        = "/google.cloud.osconfig.v1beta.OsConfigService/ListPatchDeployments"
	OsConfigService_DeletePatchDeployment_FullMethodName       = "/google.cloud.osconfig.v1beta.OsConfigService/DeletePatchDeployment"
	OsConfigService_UpdatePatchDeployment_FullMethodName       = "/google.cloud.osconfig.v1beta.OsConfigService/UpdatePatchDeployment"
	OsConfigService_PausePatchDeployment_FullMethodName        = "/google.cloud.osconfig.v1beta.OsConfigService/PausePatchDeployment"
	OsConfigService_ResumePatchDeployment_FullMethodName       = "/google.cloud.osconfig.v1beta.OsConfigService/ResumePatchDeployment"
	OsConfigService_CreateGuestPolicy_FullMethodName           = "/google.cloud.osconfig.v1beta.OsConfigService/CreateGuestPolicy"
	OsConfigService_GetGuestPolicy_FullMethodName              = "/google.cloud.osconfig.v1beta.OsConfigService/GetGuestPolicy"
	OsConfigService_ListGuestPolicies_FullMethodName           = "/google.cloud.osconfig.v1beta.OsConfigService/ListGuestPolicies"
	OsConfigService_UpdateGuestPolicy_FullMethodName           = "/google.cloud.osconfig.v1beta.OsConfigService/UpdateGuestPolicy"
	OsConfigService_DeleteGuestPolicy_FullMethodName           = "/google.cloud.osconfig.v1beta.OsConfigService/DeleteGuestPolicy"
	OsConfigService_LookupEffectiveGuestPolicy_FullMethodName  = "/google.cloud.osconfig.v1beta.OsConfigService/LookupEffectiveGuestPolicy"
)

// OsConfigServiceClient is the client API for OsConfigService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OsConfigServiceClient interface {
	// Patch VM instances by creating and running a patch job.
	ExecutePatchJob(ctx context.Context, in *ExecutePatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error)
	// Get the patch job. This can be used to track the progress of an
	// ongoing patch job or review the details of completed jobs.
	GetPatchJob(ctx context.Context, in *GetPatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error)
	// Cancel a patch job. The patch job must be active. Canceled patch jobs
	// cannot be restarted.
	CancelPatchJob(ctx context.Context, in *CancelPatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error)
	// Get a list of patch jobs.
	ListPatchJobs(ctx context.Context, in *ListPatchJobsRequest, opts ...grpc.CallOption) (*ListPatchJobsResponse, error)
	// Get a list of instance details for a given patch job.
	ListPatchJobInstanceDetails(ctx context.Context, in *ListPatchJobInstanceDetailsRequest, opts ...grpc.CallOption) (*ListPatchJobInstanceDetailsResponse, error)
	// Create an OS Config patch deployment.
	CreatePatchDeployment(ctx context.Context, in *CreatePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error)
	// Get an OS Config patch deployment.
	GetPatchDeployment(ctx context.Context, in *GetPatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error)
	// Get a page of OS Config patch deployments.
	ListPatchDeployments(ctx context.Context, in *ListPatchDeploymentsRequest, opts ...grpc.CallOption) (*ListPatchDeploymentsResponse, error)
	// Delete an OS Config patch deployment.
	DeletePatchDeployment(ctx context.Context, in *DeletePatchDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Update an OS Config patch deployment.
	UpdatePatchDeployment(ctx context.Context, in *UpdatePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error)
	// Change state of patch deployment to "PAUSED".
	// Patch deployment in paused state doesn't generate patch jobs.
	PausePatchDeployment(ctx context.Context, in *PausePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error)
	// Change state of patch deployment back to "ACTIVE".
	// Patch deployment in active state continues to generate patch jobs.
	ResumePatchDeployment(ctx context.Context, in *ResumePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error)
	// Create an OS Config guest policy.
	CreateGuestPolicy(ctx context.Context, in *CreateGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error)
	// Get an OS Config guest policy.
	GetGuestPolicy(ctx context.Context, in *GetGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error)
	// Get a page of OS Config guest policies.
	ListGuestPolicies(ctx context.Context, in *ListGuestPoliciesRequest, opts ...grpc.CallOption) (*ListGuestPoliciesResponse, error)
	// Update an OS Config guest policy.
	UpdateGuestPolicy(ctx context.Context, in *UpdateGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error)
	// Delete an OS Config guest policy.
	DeleteGuestPolicy(ctx context.Context, in *DeleteGuestPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup the effective guest policy that applies to a VM instance. This
	// lookup merges all policies that are assigned to the instance ancestry.
	LookupEffectiveGuestPolicy(ctx context.Context, in *LookupEffectiveGuestPolicyRequest, opts ...grpc.CallOption) (*EffectiveGuestPolicy, error)
}

type osConfigServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOsConfigServiceClient(cc grpc.ClientConnInterface) OsConfigServiceClient {
	return &osConfigServiceClient{cc}
}

func (c *osConfigServiceClient) ExecutePatchJob(ctx context.Context, in *ExecutePatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error) {
	out := new(PatchJob)
	err := c.cc.Invoke(ctx, OsConfigService_ExecutePatchJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) GetPatchJob(ctx context.Context, in *GetPatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error) {
	out := new(PatchJob)
	err := c.cc.Invoke(ctx, OsConfigService_GetPatchJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) CancelPatchJob(ctx context.Context, in *CancelPatchJobRequest, opts ...grpc.CallOption) (*PatchJob, error) {
	out := new(PatchJob)
	err := c.cc.Invoke(ctx, OsConfigService_CancelPatchJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) ListPatchJobs(ctx context.Context, in *ListPatchJobsRequest, opts ...grpc.CallOption) (*ListPatchJobsResponse, error) {
	out := new(ListPatchJobsResponse)
	err := c.cc.Invoke(ctx, OsConfigService_ListPatchJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) ListPatchJobInstanceDetails(ctx context.Context, in *ListPatchJobInstanceDetailsRequest, opts ...grpc.CallOption) (*ListPatchJobInstanceDetailsResponse, error) {
	out := new(ListPatchJobInstanceDetailsResponse)
	err := c.cc.Invoke(ctx, OsConfigService_ListPatchJobInstanceDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) CreatePatchDeployment(ctx context.Context, in *CreatePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error) {
	out := new(PatchDeployment)
	err := c.cc.Invoke(ctx, OsConfigService_CreatePatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) GetPatchDeployment(ctx context.Context, in *GetPatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error) {
	out := new(PatchDeployment)
	err := c.cc.Invoke(ctx, OsConfigService_GetPatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) ListPatchDeployments(ctx context.Context, in *ListPatchDeploymentsRequest, opts ...grpc.CallOption) (*ListPatchDeploymentsResponse, error) {
	out := new(ListPatchDeploymentsResponse)
	err := c.cc.Invoke(ctx, OsConfigService_ListPatchDeployments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) DeletePatchDeployment(ctx context.Context, in *DeletePatchDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, OsConfigService_DeletePatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) UpdatePatchDeployment(ctx context.Context, in *UpdatePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error) {
	out := new(PatchDeployment)
	err := c.cc.Invoke(ctx, OsConfigService_UpdatePatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) PausePatchDeployment(ctx context.Context, in *PausePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error) {
	out := new(PatchDeployment)
	err := c.cc.Invoke(ctx, OsConfigService_PausePatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) ResumePatchDeployment(ctx context.Context, in *ResumePatchDeploymentRequest, opts ...grpc.CallOption) (*PatchDeployment, error) {
	out := new(PatchDeployment)
	err := c.cc.Invoke(ctx, OsConfigService_ResumePatchDeployment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) CreateGuestPolicy(ctx context.Context, in *CreateGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error) {
	out := new(GuestPolicy)
	err := c.cc.Invoke(ctx, OsConfigService_CreateGuestPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) GetGuestPolicy(ctx context.Context, in *GetGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error) {
	out := new(GuestPolicy)
	err := c.cc.Invoke(ctx, OsConfigService_GetGuestPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) ListGuestPolicies(ctx context.Context, in *ListGuestPoliciesRequest, opts ...grpc.CallOption) (*ListGuestPoliciesResponse, error) {
	out := new(ListGuestPoliciesResponse)
	err := c.cc.Invoke(ctx, OsConfigService_ListGuestPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) UpdateGuestPolicy(ctx context.Context, in *UpdateGuestPolicyRequest, opts ...grpc.CallOption) (*GuestPolicy, error) {
	out := new(GuestPolicy)
	err := c.cc.Invoke(ctx, OsConfigService_UpdateGuestPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) DeleteGuestPolicy(ctx context.Context, in *DeleteGuestPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, OsConfigService_DeleteGuestPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigServiceClient) LookupEffectiveGuestPolicy(ctx context.Context, in *LookupEffectiveGuestPolicyRequest, opts ...grpc.CallOption) (*EffectiveGuestPolicy, error) {
	out := new(EffectiveGuestPolicy)
	err := c.cc.Invoke(ctx, OsConfigService_LookupEffectiveGuestPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OsConfigServiceServer is the server API for OsConfigService service.
// All implementations should embed UnimplementedOsConfigServiceServer
// for forward compatibility
type OsConfigServiceServer interface {
	// Patch VM instances by creating and running a patch job.
	ExecutePatchJob(context.Context, *ExecutePatchJobRequest) (*PatchJob, error)
	// Get the patch job. This can be used to track the progress of an
	// ongoing patch job or review the details of completed jobs.
	GetPatchJob(context.Context, *GetPatchJobRequest) (*PatchJob, error)
	// Cancel a patch job. The patch job must be active. Canceled patch jobs
	// cannot be restarted.
	CancelPatchJob(context.Context, *CancelPatchJobRequest) (*PatchJob, error)
	// Get a list of patch jobs.
	ListPatchJobs(context.Context, *ListPatchJobsRequest) (*ListPatchJobsResponse, error)
	// Get a list of instance details for a given patch job.
	ListPatchJobInstanceDetails(context.Context, *ListPatchJobInstanceDetailsRequest) (*ListPatchJobInstanceDetailsResponse, error)
	// Create an OS Config patch deployment.
	CreatePatchDeployment(context.Context, *CreatePatchDeploymentRequest) (*PatchDeployment, error)
	// Get an OS Config patch deployment.
	GetPatchDeployment(context.Context, *GetPatchDeploymentRequest) (*PatchDeployment, error)
	// Get a page of OS Config patch deployments.
	ListPatchDeployments(context.Context, *ListPatchDeploymentsRequest) (*ListPatchDeploymentsResponse, error)
	// Delete an OS Config patch deployment.
	DeletePatchDeployment(context.Context, *DeletePatchDeploymentRequest) (*emptypb.Empty, error)
	// Update an OS Config patch deployment.
	UpdatePatchDeployment(context.Context, *UpdatePatchDeploymentRequest) (*PatchDeployment, error)
	// Change state of patch deployment to "PAUSED".
	// Patch deployment in paused state doesn't generate patch jobs.
	PausePatchDeployment(context.Context, *PausePatchDeploymentRequest) (*PatchDeployment, error)
	// Change state of patch deployment back to "ACTIVE".
	// Patch deployment in active state continues to generate patch jobs.
	ResumePatchDeployment(context.Context, *ResumePatchDeploymentRequest) (*PatchDeployment, error)
	// Create an OS Config guest policy.
	CreateGuestPolicy(context.Context, *CreateGuestPolicyRequest) (*GuestPolicy, error)
	// Get an OS Config guest policy.
	GetGuestPolicy(context.Context, *GetGuestPolicyRequest) (*GuestPolicy, error)
	// Get a page of OS Config guest policies.
	ListGuestPolicies(context.Context, *ListGuestPoliciesRequest) (*ListGuestPoliciesResponse, error)
	// Update an OS Config guest policy.
	UpdateGuestPolicy(context.Context, *UpdateGuestPolicyRequest) (*GuestPolicy, error)
	// Delete an OS Config guest policy.
	DeleteGuestPolicy(context.Context, *DeleteGuestPolicyRequest) (*emptypb.Empty, error)
	// Lookup the effective guest policy that applies to a VM instance. This
	// lookup merges all policies that are assigned to the instance ancestry.
	LookupEffectiveGuestPolicy(context.Context, *LookupEffectiveGuestPolicyRequest) (*EffectiveGuestPolicy, error)
}

// UnimplementedOsConfigServiceServer should be embedded to have forward compatible implementations.
type UnimplementedOsConfigServiceServer struct {
}

func (UnimplementedOsConfigServiceServer) ExecutePatchJob(context.Context, *ExecutePatchJobRequest) (*PatchJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecutePatchJob not implemented")
}
func (UnimplementedOsConfigServiceServer) GetPatchJob(context.Context, *GetPatchJobRequest) (*PatchJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPatchJob not implemented")
}
func (UnimplementedOsConfigServiceServer) CancelPatchJob(context.Context, *CancelPatchJobRequest) (*PatchJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelPatchJob not implemented")
}
func (UnimplementedOsConfigServiceServer) ListPatchJobs(context.Context, *ListPatchJobsRequest) (*ListPatchJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPatchJobs not implemented")
}
func (UnimplementedOsConfigServiceServer) ListPatchJobInstanceDetails(context.Context, *ListPatchJobInstanceDetailsRequest) (*ListPatchJobInstanceDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPatchJobInstanceDetails not implemented")
}
func (UnimplementedOsConfigServiceServer) CreatePatchDeployment(context.Context, *CreatePatchDeploymentRequest) (*PatchDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) GetPatchDeployment(context.Context, *GetPatchDeploymentRequest) (*PatchDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) ListPatchDeployments(context.Context, *ListPatchDeploymentsRequest) (*ListPatchDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPatchDeployments not implemented")
}
func (UnimplementedOsConfigServiceServer) DeletePatchDeployment(context.Context, *DeletePatchDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) UpdatePatchDeployment(context.Context, *UpdatePatchDeploymentRequest) (*PatchDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) PausePatchDeployment(context.Context, *PausePatchDeploymentRequest) (*PatchDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PausePatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) ResumePatchDeployment(context.Context, *ResumePatchDeploymentRequest) (*PatchDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumePatchDeployment not implemented")
}
func (UnimplementedOsConfigServiceServer) CreateGuestPolicy(context.Context, *CreateGuestPolicyRequest) (*GuestPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGuestPolicy not implemented")
}
func (UnimplementedOsConfigServiceServer) GetGuestPolicy(context.Context, *GetGuestPolicyRequest) (*GuestPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGuestPolicy not implemented")
}
func (UnimplementedOsConfigServiceServer) ListGuestPolicies(context.Context, *ListGuestPoliciesRequest) (*ListGuestPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGuestPolicies not implemented")
}
func (UnimplementedOsConfigServiceServer) UpdateGuestPolicy(context.Context, *UpdateGuestPolicyRequest) (*GuestPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGuestPolicy not implemented")
}
func (UnimplementedOsConfigServiceServer) DeleteGuestPolicy(context.Context, *DeleteGuestPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGuestPolicy not implemented")
}
func (UnimplementedOsConfigServiceServer) LookupEffectiveGuestPolicy(context.Context, *LookupEffectiveGuestPolicyRequest) (*EffectiveGuestPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEffectiveGuestPolicy not implemented")
}

// UnsafeOsConfigServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OsConfigServiceServer will
// result in compilation errors.
type UnsafeOsConfigServiceServer interface {
	mustEmbedUnimplementedOsConfigServiceServer()
}

func RegisterOsConfigServiceServer(s grpc.ServiceRegistrar, srv OsConfigServiceServer) {
	s.RegisterService(&OsConfigService_ServiceDesc, srv)
}

func _OsConfigService_ExecutePatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecutePatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ExecutePatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ExecutePatchJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ExecutePatchJob(ctx, req.(*ExecutePatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_GetPatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).GetPatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_GetPatchJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).GetPatchJob(ctx, req.(*GetPatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_CancelPatchJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelPatchJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).CancelPatchJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_CancelPatchJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).CancelPatchJob(ctx, req.(*CancelPatchJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_ListPatchJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPatchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ListPatchJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ListPatchJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ListPatchJobs(ctx, req.(*ListPatchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_ListPatchJobInstanceDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPatchJobInstanceDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ListPatchJobInstanceDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ListPatchJobInstanceDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ListPatchJobInstanceDetails(ctx, req.(*ListPatchJobInstanceDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_CreatePatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).CreatePatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_CreatePatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).CreatePatchDeployment(ctx, req.(*CreatePatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_GetPatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).GetPatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_GetPatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).GetPatchDeployment(ctx, req.(*GetPatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_ListPatchDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPatchDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ListPatchDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ListPatchDeployments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ListPatchDeployments(ctx, req.(*ListPatchDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_DeletePatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).DeletePatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_DeletePatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).DeletePatchDeployment(ctx, req.(*DeletePatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_UpdatePatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).UpdatePatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_UpdatePatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).UpdatePatchDeployment(ctx, req.(*UpdatePatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_PausePatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PausePatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).PausePatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_PausePatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).PausePatchDeployment(ctx, req.(*PausePatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_ResumePatchDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumePatchDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ResumePatchDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ResumePatchDeployment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ResumePatchDeployment(ctx, req.(*ResumePatchDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_CreateGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).CreateGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_CreateGuestPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).CreateGuestPolicy(ctx, req.(*CreateGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_GetGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).GetGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_GetGuestPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).GetGuestPolicy(ctx, req.(*GetGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_ListGuestPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGuestPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).ListGuestPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_ListGuestPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).ListGuestPolicies(ctx, req.(*ListGuestPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_UpdateGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).UpdateGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_UpdateGuestPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).UpdateGuestPolicy(ctx, req.(*UpdateGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_DeleteGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).DeleteGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_DeleteGuestPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).DeleteGuestPolicy(ctx, req.(*DeleteGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigService_LookupEffectiveGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEffectiveGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigServiceServer).LookupEffectiveGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigService_LookupEffectiveGuestPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigServiceServer).LookupEffectiveGuestPolicy(ctx, req.(*LookupEffectiveGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OsConfigService_ServiceDesc is the grpc.ServiceDesc for OsConfigService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OsConfigService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.v1beta.OsConfigService",
	HandlerType: (*OsConfigServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExecutePatchJob",
			Handler:    _OsConfigService_ExecutePatchJob_Handler,
		},
		{
			MethodName: "GetPatchJob",
			Handler:    _OsConfigService_GetPatchJob_Handler,
		},
		{
			MethodName: "CancelPatchJob",
			Handler:    _OsConfigService_CancelPatchJob_Handler,
		},
		{
			MethodName: "ListPatchJobs",
			Handler:    _OsConfigService_ListPatchJobs_Handler,
		},
		{
			MethodName: "ListPatchJobInstanceDetails",
			Handler:    _OsConfigService_ListPatchJobInstanceDetails_Handler,
		},
		{
			MethodName: "CreatePatchDeployment",
			Handler:    _OsConfigService_CreatePatchDeployment_Handler,
		},
		{
			MethodName: "GetPatchDeployment",
			Handler:    _OsConfigService_GetPatchDeployment_Handler,
		},
		{
			MethodName: "ListPatchDeployments",
			Handler:    _OsConfigService_ListPatchDeployments_Handler,
		},
		{
			MethodName: "DeletePatchDeployment",
			Handler:    _OsConfigService_DeletePatchDeployment_Handler,
		},
		{
			MethodName: "UpdatePatchDeployment",
			Handler:    _OsConfigService_UpdatePatchDeployment_Handler,
		},
		{
			MethodName: "PausePatchDeployment",
			Handler:    _OsConfigService_PausePatchDeployment_Handler,
		},
		{
			MethodName: "ResumePatchDeployment",
			Handler:    _OsConfigService_ResumePatchDeployment_Handler,
		},
		{
			MethodName: "CreateGuestPolicy",
			Handler:    _OsConfigService_CreateGuestPolicy_Handler,
		},
		{
			MethodName: "GetGuestPolicy",
			Handler:    _OsConfigService_GetGuestPolicy_Handler,
		},
		{
			MethodName: "ListGuestPolicies",
			Handler:    _OsConfigService_ListGuestPolicies_Handler,
		},
		{
			MethodName: "UpdateGuestPolicy",
			Handler:    _OsConfigService_UpdateGuestPolicy_Handler,
		},
		{
			MethodName: "DeleteGuestPolicy",
			Handler:    _OsConfigService_DeleteGuestPolicy_Handler,
		},
		{
			MethodName: "LookupEffectiveGuestPolicy",
			Handler:    _OsConfigService_LookupEffectiveGuestPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/osconfig/v1beta/osconfig_service.proto",
}
