// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2beta/product_service.proto

package retailpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ProductService_CreateProduct_FullMethodName           = "/google.cloud.retail.v2beta.ProductService/CreateProduct"
	ProductService_GetProduct_FullMethodName              = "/google.cloud.retail.v2beta.ProductService/GetProduct"
	ProductService_ListProducts_FullMethodName            = "/google.cloud.retail.v2beta.ProductService/ListProducts"
	ProductService_UpdateProduct_FullMethodName           = "/google.cloud.retail.v2beta.ProductService/UpdateProduct"
	ProductService_DeleteProduct_FullMethodName           = "/google.cloud.retail.v2beta.ProductService/DeleteProduct"
	ProductService_PurgeProducts_FullMethodName           = "/google.cloud.retail.v2beta.ProductService/PurgeProducts"
	ProductService_ImportProducts_FullMethodName          = "/google.cloud.retail.v2beta.ProductService/ImportProducts"
	ProductService_ExportProducts_FullMethodName          = "/google.cloud.retail.v2beta.ProductService/ExportProducts"
	ProductService_SetInventory_FullMethodName            = "/google.cloud.retail.v2beta.ProductService/SetInventory"
	ProductService_AddFulfillmentPlaces_FullMethodName    = "/google.cloud.retail.v2beta.ProductService/AddFulfillmentPlaces"
	ProductService_RemoveFulfillmentPlaces_FullMethodName = "/google.cloud.retail.v2beta.ProductService/RemoveFulfillmentPlaces"
	ProductService_AddLocalInventories_FullMethodName     = "/google.cloud.retail.v2beta.ProductService/AddLocalInventories"
	ProductService_RemoveLocalInventories_FullMethodName  = "/google.cloud.retail.v2beta.ProductService/RemoveLocalInventories"
)

// ProductServiceClient is the client API for ProductService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ProductServiceClient interface {
	// Creates a [Product][google.cloud.retail.v2beta.Product].
	CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Gets a [Product][google.cloud.retail.v2beta.Product].
	GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Gets a list of [Product][google.cloud.retail.v2beta.Product]s.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Updates a [Product][google.cloud.retail.v2beta.Product].
	UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error)
	// Deletes a [Product][google.cloud.retail.v2beta.Product].
	DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Permanently deletes all selected
	// [Product][google.cloud.retail.v2beta.Product]s under a branch.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed offline. Depending on the number of
	// [Product][google.cloud.retail.v2beta.Product]s, this operation could take
	// hours to complete. Before the operation completes, some
	// [Product][google.cloud.retail.v2beta.Product]s may still be returned by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Depending on the number of [Product][google.cloud.retail.v2beta.Product]s,
	// this operation could take hours to complete. To get a sample of
	// [Product][google.cloud.retail.v2beta.Product]s that would be deleted, set
	// [PurgeProductsRequest.force][google.cloud.retail.v2beta.PurgeProductsRequest.force]
	// to false.
	PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Bulk import of multiple [Product][google.cloud.retail.v2beta.Product]s.
	//
	// Request processing may be synchronous.
	// Non-existing items are created.
	//
	// Note that it is possible for a subset of the
	// [Product][google.cloud.retail.v2beta.Product]s to be successfully updated.
	ImportProducts(ctx context.Context, in *ImportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports multiple [Product][google.cloud.retail.v2beta.Product]s.
	ExportProducts(ctx context.Context, in *ExportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] while respecting the last
	// update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update is enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// When inventory is updated with
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct],
	// the specified inventory field value(s) overwrite any existing value(s)
	// while ignoring the last update time for this field. Furthermore, the last
	// update times for the specified inventory fields are overwritten by the
	// times of the
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// or
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// request.
	//
	// If no inventory fields are set in
	// [CreateProductRequest.product][google.cloud.retail.v2beta.CreateProductRequest.product],
	// then any pre-existing inventory information for this product is used.
	//
	// If no inventory fields are set in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask],
	// then any existing inventory information is preserved.
	//
	// Pre-existing inventory information can only be updated with
	// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory],
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces],
	// and
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	//
	// The returned [Operation][google.longrunning.Operation]s is obsolete after
	// one day, and the [GetOperation][google.longrunning.Operations.GetOperation]
	// API returns `NOT_FOUND` afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates are not marked as [done][google.longrunning.Operation.done] until
	// they are obsolete.
	SetInventory(ctx context.Context, in *SetInventoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// We recommend that you use the
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// method instead of the
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
	// method.
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally adds place IDs to
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the added place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddFulfillmentPlaces(ctx context.Context, in *AddFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// We recommend that you use the
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// method instead of the
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
	// method.
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally removes place IDs from a
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the removed place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveFulfillmentPlaces(ctx context.Context, in *RemoveFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places, while
	// respecting the last update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// inventory information. If the request is valid, the update will be enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be modified using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddLocalInventories(ctx context.Context, in *AddLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Remove local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places at a
	// removal timestamp.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, removals are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be removed using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveLocalInventories(ctx context.Context, in *RemoveLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type productServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProductServiceClient(cc grpc.ClientConnInterface) ProductServiceClient {
	return &productServiceClient{cc}
}

func (c *productServiceClient) CreateProduct(ctx context.Context, in *CreateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductService_CreateProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) GetProduct(ctx context.Context, in *GetProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductService_GetProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, ProductService_ListProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) UpdateProduct(ctx context.Context, in *UpdateProductRequest, opts ...grpc.CallOption) (*Product, error) {
	out := new(Product)
	err := c.cc.Invoke(ctx, ProductService_UpdateProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) DeleteProduct(ctx context.Context, in *DeleteProductRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ProductService_DeleteProduct_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) PurgeProducts(ctx context.Context, in *PurgeProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_PurgeProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) ImportProducts(ctx context.Context, in *ImportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_ImportProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) ExportProducts(ctx context.Context, in *ExportProductsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_ExportProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) SetInventory(ctx context.Context, in *SetInventoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_SetInventory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) AddFulfillmentPlaces(ctx context.Context, in *AddFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_AddFulfillmentPlaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) RemoveFulfillmentPlaces(ctx context.Context, in *RemoveFulfillmentPlacesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_RemoveFulfillmentPlaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) AddLocalInventories(ctx context.Context, in *AddLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_AddLocalInventories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productServiceClient) RemoveLocalInventories(ctx context.Context, in *RemoveLocalInventoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProductService_RemoveLocalInventories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductServiceServer is the server API for ProductService service.
// All implementations should embed UnimplementedProductServiceServer
// for forward compatibility
type ProductServiceServer interface {
	// Creates a [Product][google.cloud.retail.v2beta.Product].
	CreateProduct(context.Context, *CreateProductRequest) (*Product, error)
	// Gets a [Product][google.cloud.retail.v2beta.Product].
	GetProduct(context.Context, *GetProductRequest) (*Product, error)
	// Gets a list of [Product][google.cloud.retail.v2beta.Product]s.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Updates a [Product][google.cloud.retail.v2beta.Product].
	UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error)
	// Deletes a [Product][google.cloud.retail.v2beta.Product].
	DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error)
	// Permanently deletes all selected
	// [Product][google.cloud.retail.v2beta.Product]s under a branch.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed offline. Depending on the number of
	// [Product][google.cloud.retail.v2beta.Product]s, this operation could take
	// hours to complete. Before the operation completes, some
	// [Product][google.cloud.retail.v2beta.Product]s may still be returned by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Depending on the number of [Product][google.cloud.retail.v2beta.Product]s,
	// this operation could take hours to complete. To get a sample of
	// [Product][google.cloud.retail.v2beta.Product]s that would be deleted, set
	// [PurgeProductsRequest.force][google.cloud.retail.v2beta.PurgeProductsRequest.force]
	// to false.
	PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunningpb.Operation, error)
	// Bulk import of multiple [Product][google.cloud.retail.v2beta.Product]s.
	//
	// Request processing may be synchronous.
	// Non-existing items are created.
	//
	// Note that it is possible for a subset of the
	// [Product][google.cloud.retail.v2beta.Product]s to be successfully updated.
	ImportProducts(context.Context, *ImportProductsRequest) (*longrunningpb.Operation, error)
	// Exports multiple [Product][google.cloud.retail.v2beta.Product]s.
	ExportProducts(context.Context, *ExportProductsRequest) (*longrunningpb.Operation, error)
	// Updates inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] while respecting the last
	// update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update is enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// When inventory is updated with
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct],
	// the specified inventory field value(s) overwrite any existing value(s)
	// while ignoring the last update time for this field. Furthermore, the last
	// update times for the specified inventory fields are overwritten by the
	// times of the
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// or
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// request.
	//
	// If no inventory fields are set in
	// [CreateProductRequest.product][google.cloud.retail.v2beta.CreateProductRequest.product],
	// then any pre-existing inventory information for this product is used.
	//
	// If no inventory fields are set in
	// [SetInventoryRequest.set_mask][google.cloud.retail.v2beta.SetInventoryRequest.set_mask],
	// then any existing inventory information is preserved.
	//
	// Pre-existing inventory information can only be updated with
	// [ProductService.SetInventory][google.cloud.retail.v2beta.ProductService.SetInventory],
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces],
	// and
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces].
	//
	// The returned [Operation][google.longrunning.Operation]s is obsolete after
	// one day, and the [GetOperation][google.longrunning.Operations.GetOperation]
	// API returns `NOT_FOUND` afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates are not marked as [done][google.longrunning.Operation.done] until
	// they are obsolete.
	SetInventory(context.Context, *SetInventoryRequest) (*longrunningpb.Operation, error)
	// We recommend that you use the
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// method instead of the
	// [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.AddFulfillmentPlaces]
	// method.
	// [ProductService.AddLocalInventories][google.cloud.retail.v2beta.ProductService.AddLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally adds place IDs to
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the added place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddFulfillmentPlaces(context.Context, *AddFulfillmentPlacesRequest) (*longrunningpb.Operation, error)
	// We recommend that you use the
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// method instead of the
	// [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2beta.ProductService.RemoveFulfillmentPlaces]
	// method.
	// [ProductService.RemoveLocalInventories][google.cloud.retail.v2beta.ProductService.RemoveLocalInventories]
	// achieves the same results but provides more fine-grained control over
	// ingesting local inventory data.
	//
	// Incrementally removes place IDs from a
	// [Product.fulfillment_info.place_ids][google.cloud.retail.v2beta.FulfillmentInfo.place_ids].
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// fulfillment information. If the request is valid, the update will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, the removed place IDs are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveFulfillmentPlaces(context.Context, *RemoveFulfillmentPlacesRequest) (*longrunningpb.Operation, error)
	// Updates local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places, while
	// respecting the last update timestamps of each inventory field.
	//
	// This process is asynchronous and does not require the
	// [Product][google.cloud.retail.v2beta.Product] to exist before updating
	// inventory information. If the request is valid, the update will be enqueued
	// and processed downstream. As a consequence, when a response is returned,
	// updates are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be modified using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	AddLocalInventories(context.Context, *AddLocalInventoriesRequest) (*longrunningpb.Operation, error)
	// Remove local inventory information for a
	// [Product][google.cloud.retail.v2beta.Product] at a list of places at a
	// removal timestamp.
	//
	// This process is asynchronous. If the request is valid, the removal will be
	// enqueued and processed downstream. As a consequence, when a response is
	// returned, removals are not immediately manifested in the
	// [Product][google.cloud.retail.v2beta.Product] queried by
	// [ProductService.GetProduct][google.cloud.retail.v2beta.ProductService.GetProduct]
	// or
	// [ProductService.ListProducts][google.cloud.retail.v2beta.ProductService.ListProducts].
	//
	// Local inventory information can only be removed using this method.
	// [ProductService.CreateProduct][google.cloud.retail.v2beta.ProductService.CreateProduct]
	// and
	// [ProductService.UpdateProduct][google.cloud.retail.v2beta.ProductService.UpdateProduct]
	// has no effect on local inventories.
	//
	// The returned [Operation][google.longrunning.Operation]s will be obsolete
	// after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
	// API will return NOT_FOUND afterwards.
	//
	// If conflicting updates are issued, the
	// [Operation][google.longrunning.Operation]s associated with the stale
	// updates will not be marked as [done][google.longrunning.Operation.done]
	// until being obsolete.
	RemoveLocalInventories(context.Context, *RemoveLocalInventoriesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedProductServiceServer should be embedded to have forward compatible implementations.
type UnimplementedProductServiceServer struct {
}

func (UnimplementedProductServiceServer) CreateProduct(context.Context, *CreateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProduct not implemented")
}
func (UnimplementedProductServiceServer) GetProduct(context.Context, *GetProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProduct not implemented")
}
func (UnimplementedProductServiceServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (UnimplementedProductServiceServer) UpdateProduct(context.Context, *UpdateProductRequest) (*Product, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProduct not implemented")
}
func (UnimplementedProductServiceServer) DeleteProduct(context.Context, *DeleteProductRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProduct not implemented")
}
func (UnimplementedProductServiceServer) PurgeProducts(context.Context, *PurgeProductsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeProducts not implemented")
}
func (UnimplementedProductServiceServer) ImportProducts(context.Context, *ImportProductsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportProducts not implemented")
}
func (UnimplementedProductServiceServer) ExportProducts(context.Context, *ExportProductsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportProducts not implemented")
}
func (UnimplementedProductServiceServer) SetInventory(context.Context, *SetInventoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInventory not implemented")
}
func (UnimplementedProductServiceServer) AddFulfillmentPlaces(context.Context, *AddFulfillmentPlacesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddFulfillmentPlaces not implemented")
}
func (UnimplementedProductServiceServer) RemoveFulfillmentPlaces(context.Context, *RemoveFulfillmentPlacesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveFulfillmentPlaces not implemented")
}
func (UnimplementedProductServiceServer) AddLocalInventories(context.Context, *AddLocalInventoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddLocalInventories not implemented")
}
func (UnimplementedProductServiceServer) RemoveLocalInventories(context.Context, *RemoveLocalInventoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveLocalInventories not implemented")
}

// UnsafeProductServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ProductServiceServer will
// result in compilation errors.
type UnsafeProductServiceServer interface {
	mustEmbedUnimplementedProductServiceServer()
}

func RegisterProductServiceServer(s grpc.ServiceRegistrar, srv ProductServiceServer) {
	s.RegisterService(&ProductService_ServiceDesc, srv)
}

func _ProductService_CreateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).CreateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_CreateProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).CreateProduct(ctx, req.(*CreateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_GetProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).GetProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_GetProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).GetProduct(ctx, req.(*GetProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_ListProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_UpdateProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).UpdateProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_UpdateProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).UpdateProduct(ctx, req.(*UpdateProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_DeleteProduct_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).DeleteProduct(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_DeleteProduct_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).DeleteProduct(ctx, req.(*DeleteProductRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_PurgeProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).PurgeProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_PurgeProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).PurgeProducts(ctx, req.(*PurgeProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_ImportProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).ImportProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_ImportProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).ImportProducts(ctx, req.(*ImportProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_ExportProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).ExportProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_ExportProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).ExportProducts(ctx, req.(*ExportProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_SetInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).SetInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_SetInventory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).SetInventory(ctx, req.(*SetInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_AddFulfillmentPlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddFulfillmentPlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).AddFulfillmentPlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_AddFulfillmentPlaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).AddFulfillmentPlaces(ctx, req.(*AddFulfillmentPlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_RemoveFulfillmentPlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFulfillmentPlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).RemoveFulfillmentPlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_RemoveFulfillmentPlaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).RemoveFulfillmentPlaces(ctx, req.(*RemoveFulfillmentPlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_AddLocalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddLocalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).AddLocalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_AddLocalInventories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).AddLocalInventories(ctx, req.(*AddLocalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductService_RemoveLocalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveLocalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductServiceServer).RemoveLocalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProductService_RemoveLocalInventories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductServiceServer).RemoveLocalInventories(ctx, req.(*RemoveLocalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ProductService_ServiceDesc is the grpc.ServiceDesc for ProductService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ProductService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.ProductService",
	HandlerType: (*ProductServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateProduct",
			Handler:    _ProductService_CreateProduct_Handler,
		},
		{
			MethodName: "GetProduct",
			Handler:    _ProductService_GetProduct_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _ProductService_ListProducts_Handler,
		},
		{
			MethodName: "UpdateProduct",
			Handler:    _ProductService_UpdateProduct_Handler,
		},
		{
			MethodName: "DeleteProduct",
			Handler:    _ProductService_DeleteProduct_Handler,
		},
		{
			MethodName: "PurgeProducts",
			Handler:    _ProductService_PurgeProducts_Handler,
		},
		{
			MethodName: "ImportProducts",
			Handler:    _ProductService_ImportProducts_Handler,
		},
		{
			MethodName: "ExportProducts",
			Handler:    _ProductService_ExportProducts_Handler,
		},
		{
			MethodName: "SetInventory",
			Handler:    _ProductService_SetInventory_Handler,
		},
		{
			MethodName: "AddFulfillmentPlaces",
			Handler:    _ProductService_AddFulfillmentPlaces_Handler,
		},
		{
			MethodName: "RemoveFulfillmentPlaces",
			Handler:    _ProductService_RemoveFulfillmentPlaces_Handler,
		},
		{
			MethodName: "AddLocalInventories",
			Handler:    _ProductService_AddLocalInventories_Handler,
		},
		{
			MethodName: "RemoveLocalInventories",
			Handler:    _ProductService_RemoveLocalInventories_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/product_service.proto",
}
