// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// OpenSearch Service API
//
// The OpenSearch service API provides access to OCI Search Service with OpenSearch.
//

package opensearch

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// OutboundClusterConfig This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
type OutboundClusterConfig struct {

	// Flag to indicate whether outbound cluster configuration is enabled
	IsEnabled *bool `mandatory:"true" json:"isEnabled"`

	// List of outbound clusters to be connected to the inbound cluster
	OutboundClusters []OutboundClusterSummary `mandatory:"true" json:"outboundClusters"`
}

func (m OutboundClusterConfig) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m OutboundClusterConfig) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
