/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.function.Supplier;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.VariableOperators;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LookupOperation
implements FieldsExposingAggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final String from;
    @Nullable
    private final Field localField;
    @Nullable
    private final Field foreignField;
    @Nullable
    private final VariableOperators.Let let;
    @Nullable
    private final AggregationPipeline pipeline;
    private final ExposedFields.ExposedField as;

    public LookupOperation(Field from, Field localField, Field foreignField, Field as) {
        this(((Supplier<String>)() -> {
            Assert.notNull((Object)from, (String)"From must not be null");
            return from.getTarget();
        }).get(), localField, foreignField, null, null, as);
    }

    public LookupOperation(String from, @Nullable VariableOperators.Let let, AggregationPipeline pipeline, Field as) {
        this(from, null, null, let, pipeline, as);
    }

    public LookupOperation(String from, @Nullable Field localField, @Nullable Field foreignField, @Nullable VariableOperators.Let let, @Nullable AggregationPipeline pipeline, Field as) {
        Assert.notNull((Object)from, (String)"From must not be null");
        if (pipeline == null) {
            Assert.notNull((Object)localField, (String)"LocalField must not be null");
            Assert.notNull((Object)foreignField, (String)"ForeignField must not be null");
        } else if (localField == null && foreignField == null) {
            Assert.notNull((Object)pipeline, (String)"Pipeline must not be null");
        }
        Assert.notNull((Object)as, (String)"As must not be null");
        this.from = from;
        this.localField = localField;
        this.foreignField = foreignField;
        this.as = new ExposedFields.ExposedField(as, true);
        this.let = let;
        this.pipeline = pipeline;
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(this.as);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document lookupObject = new Document();
        lookupObject.append("from", (Object)this.from);
        if (this.localField != null) {
            lookupObject.append("localField", (Object)this.localField.getTarget());
        }
        if (this.foreignField != null) {
            lookupObject.append("foreignField", (Object)this.foreignField.getTarget());
        }
        if (this.let != null) {
            lookupObject.append("let", ((Document)this.let.toDocument(context).get((Object)"$let", Document.class)).get((Object)"vars"));
        }
        if (this.pipeline != null) {
            lookupObject.append("pipeline", this.pipeline.toDocuments(context));
        }
        lookupObject.append("as", (Object)this.as.getTarget());
        return new Document(this.getOperator(), (Object)lookupObject);
    }

    @Override
    public String getOperator() {
        return "$lookup";
    }

    public static FromBuilder newLookup() {
        return new LookupOperationBuilder();
    }

    public static final class LookupOperationBuilder
    implements FromBuilder,
    LocalFieldBuilder,
    ForeignFieldBuilder,
    AsBuilder {
        @Nullable
        private String from;
        @Nullable
        private Field localField;
        @Nullable
        private Field foreignField;
        @Nullable
        private ExposedFields.ExposedField as;
        @Nullable
        private VariableOperators.Let let;
        @Nullable
        private AggregationPipeline pipeline;

        public static FromBuilder newBuilder() {
            return new LookupOperationBuilder();
        }

        @Override
        public LocalFieldBuilder from(String name) {
            Assert.hasText((String)name, (String)"'From' must not be null or empty");
            this.from = name;
            return this;
        }

        @Override
        public AsBuilder foreignField(String name) {
            Assert.hasText((String)name, (String)"'ForeignField' must not be null or empty");
            this.foreignField = Fields.field(name);
            return this;
        }

        @Override
        public ForeignFieldBuilder localField(String name) {
            Assert.hasText((String)name, (String)"'LocalField' must not be null or empty");
            this.localField = Fields.field(name);
            return this;
        }

        @Override
        public PipelineBuilder let(VariableOperators.Let let) {
            Assert.notNull((Object)let, (String)"Let must not be null");
            this.let = let;
            return this;
        }

        @Override
        public AsBuilder pipeline(AggregationPipeline pipeline) {
            Assert.notNull((Object)pipeline, (String)"Pipeline must not be null");
            this.pipeline = pipeline;
            return this;
        }

        @Override
        public LookupOperation as(String name) {
            Assert.hasText((String)name, (String)"'As' must not be null or empty");
            this.as = new ExposedFields.ExposedField(Fields.field(name), true);
            return new LookupOperation(this.from, this.localField, this.foreignField, this.let, this.pipeline, this.as);
        }
    }

    public static interface AsBuilder
    extends PipelineBuilder {
        @Override
        public LookupOperation as(String var1);
    }

    public static interface PipelineBuilder
    extends LetBuilder {
        public AsBuilder pipeline(AggregationPipeline var1);

        default public AsBuilder pipeline(AggregationOperation ... stages) {
            return this.pipeline(AggregationPipeline.of(stages));
        }

        public LookupOperation as(String var1);
    }

    public static interface LetBuilder {
        public PipelineBuilder let(VariableOperators.Let var1);

        default public PipelineBuilder let(VariableOperators.Let.ExpressionVariable ... variables) {
            return this.let(VariableOperators.Let.just(variables));
        }
    }

    public static interface ForeignFieldBuilder {
        public AsBuilder foreignField(String var1);
    }

    public static interface LocalFieldBuilder
    extends PipelineBuilder {
        public ForeignFieldBuilder localField(String var1);
    }

    public static interface FromBuilder {
        public LocalFieldBuilder from(String var1);
    }
}

