/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.engine;

import io.jenetics.Gene;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.EvolutionStart;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EvolutionSpliterator<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Spliterator<EvolutionResult<G, C>> {
    private final Supplier<EvolutionStart<G, C>> _start;
    private final Function<? super EvolutionStart<G, C>, EvolutionResult<G, C>> _evolution;
    private long _estimate;
    private EvolutionStart<G, C> _next = null;

    private EvolutionSpliterator(Supplier<EvolutionStart<G, C>> start, Function<? super EvolutionStart<G, C>, EvolutionResult<G, C>> evolution, long estimate) {
        this._evolution = Objects.requireNonNull(evolution);
        this._start = Objects.requireNonNull(start);
        this._estimate = estimate;
    }

    public EvolutionSpliterator(Supplier<EvolutionStart<G, C>> start, Function<? super EvolutionStart<G, C>, EvolutionResult<G, C>> evolution) {
        this(start, evolution, Long.MAX_VALUE);
    }

    @Override
    public boolean tryAdvance(Consumer<? super EvolutionResult<G, C>> action) {
        if (this._next == null) {
            this._next = this._start.get();
        }
        EvolutionResult<G, C> result = this._evolution.apply(this._next);
        action.accept(result);
        this._next = result.next();
        return true;
    }

    @Override
    public Spliterator<EvolutionResult<G, C>> trySplit() {
        return this._estimate > 0L ? new EvolutionSpliterator<G, C>(this._start, this._evolution, this._estimate >>>= 1) : null;
    }

    @Override
    public long estimateSize() {
        return this._estimate;
    }

    @Override
    public int characteristics() {
        return 1296;
    }
}

