// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package ondemandscanning provides access to the On-Demand Scanning API.
//
// For product documentation, see: https://cloud.google.com/container-analysis/docs/on-demand-scanning/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/ondemandscanning/v1beta1"
//	...
//	ctx := context.Background()
//	ondemandscanningService, err := ondemandscanning.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	ondemandscanningService, err := ondemandscanning.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	ondemandscanningService, err := ondemandscanning.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package ondemandscanning // import "google.golang.org/api/ondemandscanning/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "ondemandscanning:v1beta1"
const apiName = "ondemandscanning"
const apiVersion = "v1beta1"
const basePath = "https://ondemandscanning.googleapis.com/"
const basePathTemplate = "https://ondemandscanning.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://ondemandscanning.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Scans = NewProjectsLocationsScansService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Operations *ProjectsLocationsOperationsService

	Scans *ProjectsLocationsScansService
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsScansService(s *Service) *ProjectsLocationsScansService {
	rs := &ProjectsLocationsScansService{s: s}
	rs.Vulnerabilities = NewProjectsLocationsScansVulnerabilitiesService(s)
	return rs
}

type ProjectsLocationsScansService struct {
	s *Service

	Vulnerabilities *ProjectsLocationsScansVulnerabilitiesService
}

func NewProjectsLocationsScansVulnerabilitiesService(s *Service) *ProjectsLocationsScansVulnerabilitiesService {
	rs := &ProjectsLocationsScansVulnerabilitiesService{s: s}
	return rs
}

type ProjectsLocationsScansVulnerabilitiesService struct {
	s *Service
}

// AliasContext: An alias to a repo revision.
type AliasContext struct {
	// Kind: The alias kind.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Unknown.
	//   "FIXED" - Git tag.
	//   "MOVABLE" - Git branch.
	//   "OTHER" - Used to specify non-standard aliases. For example, if a Git repo
	// has a ref named "refs/foo/bar".
	Kind string `json:"kind,omitempty"`
	// Name: The alias name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AliasContext) MarshalJSON() ([]byte, error) {
	type NoMethod AliasContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalysisCompleted: Indicates which analysis completed successfully. Multiple
// types of analysis can be performed on a single resource.
type AnalysisCompleted struct {
	AnalysisType []string `json:"analysisType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalysisCompleted) MarshalJSON() ([]byte, error) {
	type NoMethod AnalysisCompleted
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzePackagesMetadata: AnalyzePackagesMetadata contains metadata for an
// active scan of a container image.
type AnalyzePackagesMetadata struct {
	// CreateTime: When the scan was created.
	CreateTime string `json:"createTime,omitempty"`
	// ResourceUri: The resource URI of the container image being scanned.
	ResourceUri string `json:"resourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzePackagesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePackagesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzePackagesMetadataV1: AnalyzePackagesMetadata contains metadata for an
// active scan of a container image.
type AnalyzePackagesMetadataV1 struct {
	// CreateTime: When the scan was created.
	CreateTime string `json:"createTime,omitempty"`
	// ResourceUri: The resource URI of the container image being scanned.
	ResourceUri string `json:"resourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzePackagesMetadataV1) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePackagesMetadataV1
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzePackagesRequest: AnalyzePackagesRequest is the request to analyze a
// list of packages and create Vulnerability Occurrences for it.
type AnalyzePackagesRequest struct {
	// Packages: The packages to analyze.
	Packages []*PackageData `json:"packages,omitempty"`
	// ResourceUri: Required. The resource URI of the container image being
	// scanned.
	ResourceUri string `json:"resourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Packages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Packages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzePackagesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePackagesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzePackagesResponse: AnalyzePackagesResponse contains the information
// necessary to find results for the given scan.
type AnalyzePackagesResponse struct {
	// Scan: The name of the scan resource created by this successful scan.
	Scan string `json:"scan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scan") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzePackagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePackagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzePackagesResponseV1: AnalyzePackagesResponse contains the information
// necessary to find results for the given scan.
type AnalyzePackagesResponseV1 struct {
	// Scan: The name of the scan resource created by this successful scan.
	Scan string `json:"scan,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scan") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scan") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzePackagesResponseV1) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzePackagesResponseV1
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Artifact: Artifact describes a build product.
type Artifact struct {
	// Checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest
	// of a container.
	Checksum string `json:"checksum,omitempty"`
	// Id: Artifact ID, if any; for container images, this will be a URL by digest
	// like `gcr.io/projectID/imagename@sha256:123456`.
	Id string `json:"id,omitempty"`
	// Names: Related artifact names. This may be the path to a binary or jar file,
	// or in the case of a container build, the name used to push the container
	// image to Google Container Registry, as presented to `docker push`. Note that
	// a single Artifact ID can have multiple names, for example if two tags are
	// applied to one image.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Checksum") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Checksum") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Artifact) MarshalJSON() ([]byte, error) {
	type NoMethod Artifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttestationOccurrence: Occurrence that represents a single "attestation".
// The authenticity of an attestation can be verified using the attached
// signature. If the verifier trusts the public key of the signer, then
// verifying the signature is sufficient to establish trust. In this
// circumstance, the authority to which this attestation is attached is
// primarily useful for lookup (how to find this attestation if you already
// know the authority and artifact to be verified) and intent (for which
// authority this attestation was intended to sign.
type AttestationOccurrence struct {
	// Jwts: One or more JWTs encoding a self-contained attestation. Each JWT
	// encodes the payload that it verifies within the JWT itself. Verifier
	// implementation SHOULD ignore the `serialized_payload` field when verifying
	// these JWTs. If only JWTs are present on this AttestationOccurrence, then the
	// `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim
	// specific to the `resource_uri` of this Occurrence, but this is not validated
	// by Grafeas metadata API implementations. The JWT itself is opaque to
	// Grafeas.
	Jwts []*Jwt `json:"jwts,omitempty"`
	// SerializedPayload: Required. The serialized payload that is verified by one
	// or more `signatures`.
	SerializedPayload string `json:"serializedPayload,omitempty"`
	// Signatures: One or more signatures over `serialized_payload`. Verifier
	// implementations should consider this attestation message verified if at
	// least one `signature` verifies `serialized_payload`. See `Signature` in
	// common.proto for more details on signature structure and verification.
	Signatures []*Signature `json:"signatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Jwts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jwts") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttestationOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod AttestationOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BaseImage: BaseImage describes a base image of a container image.
type BaseImage struct {
	// LayerCount: The number of layers that the base image is composed of.
	LayerCount int64 `json:"layerCount,omitempty"`
	// Name: The name of the base image.
	Name string `json:"name,omitempty"`
	// Repository: The repository name in which the base image is from.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayerCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayerCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BaseImage) MarshalJSON() ([]byte, error) {
	type NoMethod BaseImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BinarySourceInfo struct {
	// BinaryVersion: The binary package. This is significant when the source is
	// different than the binary itself. Historically if they've differed, we've
	// stored the name of the source and its version in the package/version fields,
	// but we should also store the binary package info, as that's what's actually
	// installed. See b/175908657#comment15.
	BinaryVersion *PackageVersion `json:"binaryVersion,omitempty"`
	// SourceVersion: The source package. Similar to the above, this is significant
	// when the source is different than the binary itself. Since the top-level
	// package/version fields are based on an if/else, we need a separate field for
	// both binary and source if we want to know definitively where the data is
	// coming from.
	SourceVersion *PackageVersion `json:"sourceVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinaryVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinaryVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinarySourceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BinarySourceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BuildDefinition struct {
	BuildType            string                `json:"buildType,omitempty"`
	ExternalParameters   googleapi.RawMessage  `json:"externalParameters,omitempty"`
	InternalParameters   googleapi.RawMessage  `json:"internalParameters,omitempty"`
	ResolvedDependencies []*ResourceDescriptor `json:"resolvedDependencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod BuildDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BuildMetadata struct {
	FinishedOn   string `json:"finishedOn,omitempty"`
	InvocationId string `json:"invocationId,omitempty"`
	StartedOn    string `json:"startedOn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FinishedOn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FinishedOn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod BuildMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildOccurrence: Details of a build occurrence.
type BuildOccurrence struct {
	// InTotoSlsaProvenanceV1: In-Toto Slsa Provenance V1 represents a slsa
	// provenance meeting the slsa spec, wrapped in an in-toto statement. This
	// allows for direct jsonification of a to-spec in-toto slsa statement with a
	// to-spec slsa provenance.
	InTotoSlsaProvenanceV1 *InTotoSlsaProvenanceV1 `json:"inTotoSlsaProvenanceV1,omitempty"`
	// IntotoProvenance: Deprecated. See InTotoStatement for the replacement.
	// In-toto Provenance representation as defined in spec.
	IntotoProvenance *InTotoProvenance `json:"intotoProvenance,omitempty"`
	// IntotoStatement: In-toto Statement representation as defined in spec. The
	// intoto_statement can contain any type of provenance. The serialized payload
	// of the statement can be stored and signed in the Occurrence's envelope.
	IntotoStatement *InTotoStatement `json:"intotoStatement,omitempty"`
	// Provenance: The actual provenance for the build.
	Provenance *BuildProvenance `json:"provenance,omitempty"`
	// ProvenanceBytes: Serialized JSON representation of the provenance, used in
	// generating the build signature in the corresponding build note. After
	// verifying the signature, `provenance_bytes` can be unmarshalled and compared
	// to the provenance to confirm that it is unchanged. A base64-encoded string
	// representation of the provenance bytes is used for the signature in order to
	// interoperate with openssl which expects this format for signature
	// verification. The serialized form is captured both to avoid ambiguity in how
	// the provenance is marshalled to json as well to prevent incompatibilities
	// with future changes.
	ProvenanceBytes string `json:"provenanceBytes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InTotoSlsaProvenanceV1") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InTotoSlsaProvenanceV1") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod BuildOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildProvenance: Provenance of a build. Contains all information needed to
// verify the full details about the build from source to completion.
type BuildProvenance struct {
	// BuildOptions: Special options applied to this build. This is a catch-all
	// field where build providers can enter any desired additional details.
	BuildOptions map[string]string `json:"buildOptions,omitempty"`
	// BuilderVersion: Version string of the builder at the time this build was
	// executed.
	BuilderVersion string `json:"builderVersion,omitempty"`
	// BuiltArtifacts: Output of the build.
	BuiltArtifacts []*Artifact `json:"builtArtifacts,omitempty"`
	// Commands: Commands requested by the build.
	Commands []*Command `json:"commands,omitempty"`
	// CreateTime: Time at which the build was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: E-mail address of the user who initiated this build. Note that this
	// was the user's e-mail address at the time the build was initiated; this
	// address may not represent the same end-user for all time.
	Creator string `json:"creator,omitempty"`
	// EndTime: Time at which execution of the build was finished.
	EndTime string `json:"endTime,omitempty"`
	// Id: Required. Unique identifier of the build.
	Id string `json:"id,omitempty"`
	// LogsUri: URI where any logs for this provenance were written.
	LogsUri string `json:"logsUri,omitempty"`
	// ProjectId: ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// SourceProvenance: Details of the Source input to the build.
	SourceProvenance *Source `json:"sourceProvenance,omitempty"`
	// StartTime: Time at which execution of the build was started.
	StartTime string `json:"startTime,omitempty"`
	// TriggerId: Trigger identifier if the build was triggered automatically;
	// empty if not.
	TriggerId string `json:"triggerId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildOptions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod BuildProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BuilderConfig struct {
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuilderConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BuilderConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CVSS: Common Vulnerability Scoring System. For details, see
// https://www.first.org/cvss/specification-document This is a message we will
// try to use for storing various versions of CVSS rather than making a
// separate proto for storing a specific version.
type CVSS struct {
	// Possible values:
	//   "ATTACK_COMPLEXITY_UNSPECIFIED"
	//   "ATTACK_COMPLEXITY_LOW"
	//   "ATTACK_COMPLEXITY_HIGH"
	//   "ATTACK_COMPLEXITY_MEDIUM"
	AttackComplexity string `json:"attackComplexity,omitempty"`
	// AttackVector: Base Metrics Represents the intrinsic characteristics of a
	// vulnerability that are constant over time and across user environments.
	//
	// Possible values:
	//   "ATTACK_VECTOR_UNSPECIFIED"
	//   "ATTACK_VECTOR_NETWORK"
	//   "ATTACK_VECTOR_ADJACENT"
	//   "ATTACK_VECTOR_LOCAL"
	//   "ATTACK_VECTOR_PHYSICAL"
	AttackVector string `json:"attackVector,omitempty"`
	// Possible values:
	//   "AUTHENTICATION_UNSPECIFIED"
	//   "AUTHENTICATION_MULTIPLE"
	//   "AUTHENTICATION_SINGLE"
	//   "AUTHENTICATION_NONE"
	Authentication string `json:"authentication,omitempty"`
	// Possible values:
	//   "IMPACT_UNSPECIFIED"
	//   "IMPACT_HIGH"
	//   "IMPACT_LOW"
	//   "IMPACT_NONE"
	//   "IMPACT_PARTIAL"
	//   "IMPACT_COMPLETE"
	AvailabilityImpact string `json:"availabilityImpact,omitempty"`
	// BaseScore: The base score is a function of the base metric scores.
	BaseScore float64 `json:"baseScore,omitempty"`
	// Possible values:
	//   "IMPACT_UNSPECIFIED"
	//   "IMPACT_HIGH"
	//   "IMPACT_LOW"
	//   "IMPACT_NONE"
	//   "IMPACT_PARTIAL"
	//   "IMPACT_COMPLETE"
	ConfidentialityImpact string  `json:"confidentialityImpact,omitempty"`
	ExploitabilityScore   float64 `json:"exploitabilityScore,omitempty"`
	ImpactScore           float64 `json:"impactScore,omitempty"`
	// Possible values:
	//   "IMPACT_UNSPECIFIED"
	//   "IMPACT_HIGH"
	//   "IMPACT_LOW"
	//   "IMPACT_NONE"
	//   "IMPACT_PARTIAL"
	//   "IMPACT_COMPLETE"
	IntegrityImpact string `json:"integrityImpact,omitempty"`
	// Possible values:
	//   "PRIVILEGES_REQUIRED_UNSPECIFIED"
	//   "PRIVILEGES_REQUIRED_NONE"
	//   "PRIVILEGES_REQUIRED_LOW"
	//   "PRIVILEGES_REQUIRED_HIGH"
	PrivilegesRequired string `json:"privilegesRequired,omitempty"`
	// Possible values:
	//   "SCOPE_UNSPECIFIED"
	//   "SCOPE_UNCHANGED"
	//   "SCOPE_CHANGED"
	Scope string `json:"scope,omitempty"`
	// Possible values:
	//   "USER_INTERACTION_UNSPECIFIED"
	//   "USER_INTERACTION_NONE"
	//   "USER_INTERACTION_REQUIRED"
	UserInteraction string `json:"userInteraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttackComplexity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttackComplexity") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CVSS) MarshalJSON() ([]byte, error) {
	type NoMethod CVSS
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CVSS) UnmarshalJSON(data []byte) error {
	type NoMethod CVSS
	var s1 struct {
		BaseScore           gensupport.JSONFloat64 `json:"baseScore"`
		ExploitabilityScore gensupport.JSONFloat64 `json:"exploitabilityScore"`
		ImpactScore         gensupport.JSONFloat64 `json:"impactScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BaseScore = float64(s1.BaseScore)
	s.ExploitabilityScore = float64(s1.ExploitabilityScore)
	s.ImpactScore = float64(s1.ImpactScore)
	return nil
}

// Category: The category to which the update belongs.
type Category struct {
	// CategoryId: The identifier of the category.
	CategoryId string `json:"categoryId,omitempty"`
	// Name: The localized name of the category.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoryId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoryId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Category) MarshalJSON() ([]byte, error) {
	type NoMethod Category
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudRepoSourceContext: A CloudRepoSourceContext denotes a particular
// revision in a Google Cloud Source Repo.
type CloudRepoSourceContext struct {
	// AliasContext: An alias, which may be a branch or tag.
	AliasContext *AliasContext `json:"aliasContext,omitempty"`
	// RepoId: The ID of the repo.
	RepoId *RepoId `json:"repoId,omitempty"`
	// RevisionId: A revision ID.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AliasContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AliasContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudRepoSourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod CloudRepoSourceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Command: Command describes a step performed as part of the build pipeline.
type Command struct {
	// Args: Command-line arguments used when executing this command.
	Args []string `json:"args,omitempty"`
	// Dir: Working directory (relative to project source root) used when running
	// this command.
	Dir string `json:"dir,omitempty"`
	// Env: Environment variables set before running this command.
	Env []string `json:"env,omitempty"`
	// Id: Optional unique identifier for this command, used in wait_for to
	// reference this command as a dependency.
	Id string `json:"id,omitempty"`
	// Name: Required. Name of the command, as presented on the command line, or if
	// the command is packaged as a Docker container, as presented to `docker
	// pull`.
	Name string `json:"name,omitempty"`
	// WaitFor: The ID(s) of the command(s) that this command depends on.
	WaitFor []string `json:"waitFor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Command) MarshalJSON() ([]byte, error) {
	type NoMethod Command
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Completeness: Indicates that the builder claims certain fields in this
// message to be complete.
type Completeness struct {
	// Arguments: If true, the builder claims that recipe.arguments is complete,
	// meaning that all external inputs are properly captured in the recipe.
	Arguments bool `json:"arguments,omitempty"`
	// Environment: If true, the builder claims that recipe.environment is claimed
	// to be complete.
	Environment bool `json:"environment,omitempty"`
	// Materials: If true, the builder claims that materials are complete, usually
	// through some controls to prevent network access. Sometimes called
	// "hermetic".
	Materials bool `json:"materials,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Completeness) MarshalJSON() ([]byte, error) {
	type NoMethod Completeness
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComplianceOccurrence: An indication that the compliance checks in the
// associated ComplianceNote were not satisfied for particular resources or a
// specified reason.
type ComplianceOccurrence struct {
	NonComplianceReason string              `json:"nonComplianceReason,omitempty"`
	NonCompliantFiles   []*NonCompliantFile `json:"nonCompliantFiles,omitempty"`
	// Version: The OS and config version the benchmark was run on.
	Version *ComplianceVersion `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NonComplianceReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NonComplianceReason") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComplianceVersion: Describes the CIS benchmark version that is applicable to
// a given OS and os version.
type ComplianceVersion struct {
	// BenchmarkDocument: The name of the document that defines this benchmark,
	// e.g. "CIS Container-Optimized OS".
	BenchmarkDocument string `json:"benchmarkDocument,omitempty"`
	// CpeUri: The CPE URI (https://cpe.mitre.org/specification/) this benchmark is
	// applicable to.
	CpeUri string `json:"cpeUri,omitempty"`
	// Version: The version of the benchmark. This is set to the version of the
	// OS-specific CIS document the benchmark is defined in.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BenchmarkDocument") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BenchmarkDocument") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComplianceVersion) MarshalJSON() ([]byte, error) {
	type NoMethod ComplianceVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DSSEAttestationOccurrence: Deprecated. Prefer to use a regular Occurrence,
// and populate the Envelope at the top level of the Occurrence.
type DSSEAttestationOccurrence struct {
	// Envelope: If doing something security critical, make sure to verify the
	// signatures in this metadata.
	Envelope  *Envelope        `json:"envelope,omitempty"`
	Statement *InTotoStatement `json:"statement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Envelope") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Envelope") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DSSEAttestationOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod DSSEAttestationOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeploymentOccurrence: The period during which some deployable was active in
// a runtime.
type DeploymentOccurrence struct {
	// Address: Address of the runtime element hosting this deployment.
	Address string `json:"address,omitempty"`
	// Config: Configuration used to create this deployment.
	Config string `json:"config,omitempty"`
	// DeployTime: Required. Beginning of the lifetime of this deployment.
	DeployTime string `json:"deployTime,omitempty"`
	// Platform: Platform hosting this deployment.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Unknown.
	//   "GKE" - Google Container Engine.
	//   "FLEX" - Google App Engine: Flexible Environment.
	//   "CUSTOM" - Custom user-defined platform.
	Platform string `json:"platform,omitempty"`
	// ResourceUri: Output only. Resource URI for the artifact being deployed taken
	// from the deployable field with the same name.
	ResourceUri []string `json:"resourceUri,omitempty"`
	// UndeployTime: End of the lifetime of this deployment.
	UndeployTime string `json:"undeployTime,omitempty"`
	// UserEmail: Identity of the user that triggered this deployment.
	UserEmail string `json:"userEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeploymentOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod DeploymentOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiscoveryOccurrence: Provides information about the analysis status of a
// discovered resource.
type DiscoveryOccurrence struct {
	AnalysisCompleted *AnalysisCompleted `json:"analysisCompleted,omitempty"`
	// AnalysisError: Indicates any errors encountered during analysis of a
	// resource. There could be 0 or more of these errors.
	AnalysisError []*Status `json:"analysisError,omitempty"`
	// AnalysisStatus: The status of discovery for the resource.
	//
	// Possible values:
	//   "ANALYSIS_STATUS_UNSPECIFIED" - Unknown.
	//   "PENDING" - Resource is known but no action has been taken yet.
	//   "SCANNING" - Resource is being analyzed.
	//   "FINISHED_SUCCESS" - Analysis has finished successfully.
	//   "COMPLETE" - Analysis has completed.
	//   "FINISHED_FAILED" - Analysis has finished unsuccessfully, the analysis
	// itself is in a bad state.
	//   "FINISHED_UNSUPPORTED" - The resource is known not to be supported.
	AnalysisStatus string `json:"analysisStatus,omitempty"`
	// AnalysisStatusError: When an error is encountered this will contain a
	// LocalizedMessage under details to show to the user. The LocalizedMessage is
	// output only and populated by the API.
	AnalysisStatusError *Status `json:"analysisStatusError,omitempty"`
	// ArchiveTime: Output only. The time occurrences related to this discovery
	// occurrence were archived.
	ArchiveTime string `json:"archiveTime,omitempty"`
	// ContinuousAnalysis: Whether the resource is continuously analyzed.
	//
	// Possible values:
	//   "CONTINUOUS_ANALYSIS_UNSPECIFIED" - Unknown.
	//   "ACTIVE" - The resource is continuously analyzed.
	//   "INACTIVE" - The resource is ignored for continuous analysis.
	ContinuousAnalysis string `json:"continuousAnalysis,omitempty"`
	// Cpe: The CPE of the resource being scanned.
	Cpe string `json:"cpe,omitempty"`
	// LastScanTime: The last time this resource was scanned.
	LastScanTime string `json:"lastScanTime,omitempty"`
	// SbomStatus: The status of an SBOM generation.
	SbomStatus *SBOMStatus `json:"sbomStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisCompleted") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisCompleted") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiscoveryOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod DiscoveryOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Envelope: MUST match
// https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An
// authenticated message of arbitrary type.
type Envelope struct {
	Payload     string               `json:"payload,omitempty"`
	PayloadType string               `json:"payloadType,omitempty"`
	Signatures  []*EnvelopeSignature `json:"signatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Envelope) MarshalJSON() ([]byte, error) {
	type NoMethod Envelope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type EnvelopeSignature struct {
	Keyid string `json:"keyid,omitempty"`
	Sig   string `json:"sig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Keyid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keyid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvelopeSignature) MarshalJSON() ([]byte, error) {
	type NoMethod EnvelopeSignature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileHashes: Container message for hashes of byte content of files, used in
// source messages to verify integrity of source input to the build.
type FileHashes struct {
	// FileHash: Required. Collection of file hashes.
	FileHash []*Hash `json:"fileHash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileHash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileHash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileHashes) MarshalJSON() ([]byte, error) {
	type NoMethod FileHashes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileLocation: Indicates the location at which a package was found.
type FileLocation struct {
	// FilePath: For jars that are contained inside .war files, this filepath can
	// indicate the path to war file combined with the path to jar file.
	FilePath     string        `json:"filePath,omitempty"`
	LayerDetails *LayerDetails `json:"layerDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileLocation) MarshalJSON() ([]byte, error) {
	type NoMethod FileLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Fingerprint: A set of properties that uniquely identify a given Docker
// image.
type Fingerprint struct {
	// V1Name: Required. The layer ID of the final layer in the Docker image's v1
	// representation.
	V1Name string `json:"v1Name,omitempty"`
	// V2Blob: Required. The ordered list of v2 blobs that represent a given image.
	V2Blob []string `json:"v2Blob,omitempty"`
	// V2Name: Output only. The name of the image's v2 blobs computed via: [bottom]
	// := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of
	// the final blob is kept.
	V2Name string `json:"v2Name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "V1Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "V1Name") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Fingerprint) MarshalJSON() ([]byte, error) {
	type NoMethod Fingerprint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GerritSourceContext: A SourceContext referring to a Gerrit project.
type GerritSourceContext struct {
	// AliasContext: An alias, which may be a branch or tag.
	AliasContext *AliasContext `json:"aliasContext,omitempty"`
	// GerritProject: The full project name within the host. Projects may be
	// nested, so "project/subproject" is a valid project name. The "repo name" is
	// the hostURI/project.
	GerritProject string `json:"gerritProject,omitempty"`
	// HostUri: The URI of a running Gerrit instance.
	HostUri string `json:"hostUri,omitempty"`
	// RevisionId: A revision (commit) ID.
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AliasContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AliasContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GerritSourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GerritSourceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GitSourceContext: A GitSourceContext denotes a particular revision in a
// third party Git repository (e.g., GitHub).
type GitSourceContext struct {
	// RevisionId: Git commit hash.
	RevisionId string `json:"revisionId,omitempty"`
	// Url: Git repository URL.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RevisionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RevisionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GitSourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GitSourceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1BaseImage: BaseImage describes a base image of a container image.
type GrafeasV1BaseImage struct {
	// LayerCount: The number of layers that the base image is composed of.
	LayerCount int64 `json:"layerCount,omitempty"`
	// Name: The name of the base image.
	Name string `json:"name,omitempty"`
	// Repository: The repository name in which the base image is from.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LayerCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LayerCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1BaseImage) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1BaseImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1FileLocation: Indicates the location at which a package was found.
type GrafeasV1FileLocation struct {
	// FilePath: For jars that are contained inside .war files, this filepath can
	// indicate the path to war file combined with the path to jar file.
	FilePath string `json:"filePath,omitempty"`
	// LayerDetails: Each package found in a file should have its own layer
	// metadata (that is, information from the origin layer of the package).
	LayerDetails *GrafeasV1LayerDetails `json:"layerDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FilePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FilePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1FileLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1FileLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1LayerDetails: Details about the layer a package was found in.
type GrafeasV1LayerDetails struct {
	// BaseImages: The base images the layer is found within.
	BaseImages []*GrafeasV1BaseImage `json:"baseImages,omitempty"`
	// Command: The layer build command that was used to build the layer. This may
	// not be found in all layers depending on how the container image is built.
	Command string `json:"command,omitempty"`
	// DiffId: The diff ID (typically a sha256 hash) of the layer in the container
	// image.
	DiffId string `json:"diffId,omitempty"`
	// Index: The index of the layer in the container image.
	Index int64 `json:"index,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseImages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseImages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1LayerDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1LayerDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaBuilder: Identifies the entity that
// executed the recipe, which is trusted to have correctly performed the
// operation and populated this provenance.
type GrafeasV1SlsaProvenanceZeroTwoSlsaBuilder struct {
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaBuilder) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaBuilder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaCompleteness: Indicates that the builder
// claims certain fields in this message to be complete.
type GrafeasV1SlsaProvenanceZeroTwoSlsaCompleteness struct {
	Environment bool `json:"environment,omitempty"`
	Materials   bool `json:"materials,omitempty"`
	Parameters  bool `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaCompleteness) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaCompleteness
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource: Describes where the config
// file that kicked off the build came from. This is effectively a pointer to
// the source where buildConfig came from.
type GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource struct {
	Digest     map[string]string `json:"digest,omitempty"`
	EntryPoint string            `json:"entryPoint,omitempty"`
	Uri        string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaInvocation: Identifies the event that
// kicked off the build.
type GrafeasV1SlsaProvenanceZeroTwoSlsaInvocation struct {
	ConfigSource *GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource `json:"configSource,omitempty"`
	Environment  googleapi.RawMessage                            `json:"environment,omitempty"`
	Parameters   googleapi.RawMessage                            `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaInvocation) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaInvocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaMaterial: The collection of artifacts that
// influenced the build including sources, dependencies, build tools, base
// images, and so on.
type GrafeasV1SlsaProvenanceZeroTwoSlsaMaterial struct {
	Digest map[string]string `json:"digest,omitempty"`
	Uri    string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaMaterial) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaMaterial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GrafeasV1SlsaProvenanceZeroTwoSlsaMetadata: Other properties of the build.
type GrafeasV1SlsaProvenanceZeroTwoSlsaMetadata struct {
	BuildFinishedOn   string                                          `json:"buildFinishedOn,omitempty"`
	BuildInvocationId string                                          `json:"buildInvocationId,omitempty"`
	BuildStartedOn    string                                          `json:"buildStartedOn,omitempty"`
	Completeness      *GrafeasV1SlsaProvenanceZeroTwoSlsaCompleteness `json:"completeness,omitempty"`
	Reproducible      bool                                            `json:"reproducible,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildFinishedOn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildFinishedOn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GrafeasV1SlsaProvenanceZeroTwoSlsaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GrafeasV1SlsaProvenanceZeroTwoSlsaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Hash: Container message for hash values.
type Hash struct {
	// Type: Required. The type of hash that was performed, e.g. "SHA-256".
	Type string `json:"type,omitempty"`
	// Value: Required. The hash value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Hash) MarshalJSON() ([]byte, error) {
	type NoMethod Hash
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Identity: The unique identifier of the update.
type Identity struct {
	// Revision: The revision number of the update.
	Revision int64 `json:"revision,omitempty"`
	// UpdateId: The revision independent identifier of the update.
	UpdateId string `json:"updateId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Revision") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Revision") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Identity) MarshalJSON() ([]byte, error) {
	type NoMethod Identity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageOccurrence: Details of the derived image portion of the DockerImage
// relationship. This image would be produced from a Dockerfile with FROM .
type ImageOccurrence struct {
	// BaseResourceUrl: Output only. This contains the base image URL for the
	// derived image occurrence.
	BaseResourceUrl string `json:"baseResourceUrl,omitempty"`
	// Distance: Output only. The number of layers by which this image differs from
	// the associated image basis.
	Distance int64 `json:"distance,omitempty"`
	// Fingerprint: Required. The fingerprint of the derived image.
	Fingerprint *Fingerprint `json:"fingerprint,omitempty"`
	// LayerInfo: This contains layer-specific metadata, if populated it has length
	// "distance" and is ordered with [distance] being the layer immediately
	// following the base image and [1] being the final layer.
	LayerInfo []*Layer `json:"layerInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseResourceUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseResourceUrl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod ImageOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InTotoProvenance struct {
	// BuilderConfig: required
	BuilderConfig *BuilderConfig `json:"builderConfig,omitempty"`
	// Materials: The collection of artifacts that influenced the build including
	// sources, dependencies, build tools, base images, and so on. This is
	// considered to be incomplete unless metadata.completeness.materials is true.
	// Unset or null is equivalent to empty.
	Materials []string  `json:"materials,omitempty"`
	Metadata  *Metadata `json:"metadata,omitempty"`
	// Recipe: Identifies the configuration used for the build. When combined with
	// materials, this SHOULD fully describe the build, such that re-running this
	// recipe results in bit-for-bit identical output (if the build is
	// reproducible). required
	Recipe *Recipe `json:"recipe,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuilderConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuilderConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InTotoProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod InTotoProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InTotoSlsaProvenanceV1 struct {
	// Type: InToto spec defined at
	// https://github.com/in-toto/attestation/tree/main/spec#statement
	Type          string            `json:"_type,omitempty"`
	Predicate     *SlsaProvenanceV1 `json:"predicate,omitempty"`
	PredicateType string            `json:"predicateType,omitempty"`
	Subject       []*Subject        `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InTotoSlsaProvenanceV1) MarshalJSON() ([]byte, error) {
	type NoMethod InTotoSlsaProvenanceV1
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InTotoStatement: Spec defined at
// https://github.com/in-toto/attestation/tree/main/spec#statement The
// serialized InTotoStatement will be stored as Envelope.payload.
// Envelope.payloadType is always "application/vnd.in-toto+json".
type InTotoStatement struct {
	// Type: Always `https://in-toto.io/Statement/v0.1`.
	Type string `json:"_type,omitempty"`
	// PredicateType: `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
	PredicateType         string                 `json:"predicateType,omitempty"`
	Provenance            *InTotoProvenance      `json:"provenance,omitempty"`
	SlsaProvenance        *SlsaProvenance        `json:"slsaProvenance,omitempty"`
	SlsaProvenanceZeroTwo *SlsaProvenanceZeroTwo `json:"slsaProvenanceZeroTwo,omitempty"`
	Subject               []*Subject             `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InTotoStatement) MarshalJSON() ([]byte, error) {
	type NoMethod InTotoStatement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Justification: Justification provides the justification when the state of
// the assessment if NOT_AFFECTED.
type Justification struct {
	// Details: Additional details on why this justification was chosen.
	Details string `json:"details,omitempty"`
	// JustificationType: The justification type for this vulnerability.
	//
	// Possible values:
	//   "JUSTIFICATION_TYPE_UNSPECIFIED" - JUSTIFICATION_TYPE_UNSPECIFIED.
	//   "COMPONENT_NOT_PRESENT" - The vulnerable component is not present in the
	// product.
	//   "VULNERABLE_CODE_NOT_PRESENT" - The vulnerable code is not present.
	// Typically this case occurs when source code is configured or built in a way
	// that excludes the vulnerable code.
	//   "VULNERABLE_CODE_NOT_IN_EXECUTE_PATH" - The vulnerable code can not be
	// executed. Typically this case occurs when the product includes the
	// vulnerable code but does not call or use the vulnerable code.
	//   "VULNERABLE_CODE_CANNOT_BE_CONTROLLED_BY_ADVERSARY" - The vulnerable code
	// cannot be controlled by an attacker to exploit the vulnerability.
	//   "INLINE_MITIGATIONS_ALREADY_EXIST" - The product includes built-in
	// protections or features that prevent exploitation of the vulnerability.
	// These built-in protections cannot be subverted by the attacker and cannot be
	// configured or disabled by the user. These mitigations completely prevent
	// exploitation based on known attack vectors.
	JustificationType string `json:"justificationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Justification) MarshalJSON() ([]byte, error) {
	type NoMethod Justification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Jwt struct {
	// CompactJwt: The compact encoding of a JWS, which is always three base64
	// encoded strings joined by periods. For details, see:
	// https://tools.ietf.org/html/rfc7515.html#section-3.1
	CompactJwt string `json:"compactJwt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompactJwt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompactJwt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Jwt) MarshalJSON() ([]byte, error) {
	type NoMethod Jwt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LanguagePackageDependency: Indicates a language package available between
// this package and the customer's resource artifact.
type LanguagePackageDependency struct {
	Package string `json:"package,omitempty"`
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Package") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Package") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LanguagePackageDependency) MarshalJSON() ([]byte, error) {
	type NoMethod LanguagePackageDependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Layer: Layer holds metadata specific to a layer of a Docker image.
type Layer struct {
	// Arguments: The recovered arguments to the Dockerfile directive.
	Arguments string `json:"arguments,omitempty"`
	// Directive: Required. The recovered Dockerfile directive used to construct
	// this layer. See https://docs.docker.com/engine/reference/builder/ for more
	// information.
	Directive string `json:"directive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Layer) MarshalJSON() ([]byte, error) {
	type NoMethod Layer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LayerDetails: Details about the layer a package was found in. This should be
// the same as the LayerDetails message in
// google3/third_party/scalibr/binary/proto/scan_result.proto.
type LayerDetails struct {
	// BaseImages: The base images the layer is found within.
	BaseImages []*BaseImage `json:"baseImages,omitempty"`
	// Command: The layer build command that was used to build the layer. This may
	// not be found in all layers depending on how the container image is built.
	Command string `json:"command,omitempty"`
	// DiffId: The diff ID (sha256 hash) of the layer in the container image.
	DiffId string `json:"diffId,omitempty"`
	// Index: The index of the layer in the container image.
	Index int64 `json:"index,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseImages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseImages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LayerDetails) MarshalJSON() ([]byte, error) {
	type NoMethod LayerDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// License: License information.
type License struct {
	// Comments: Comments
	Comments string `json:"comments,omitempty"`
	// Expression: Often a single license can be used to represent the licensing
	// terms. Sometimes it is necessary to include a choice of one or more licenses
	// or some combination of license identifiers. Examples: "LGPL-2.1-only OR
	// MIT", "LGPL-2.1-only AND MIT", "GPL-2.0-or-later WITH Bison-exception-2.2".
	Expression string `json:"expression,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Comments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Comments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s License) MarshalJSON() ([]byte, error) {
	type NoMethod License
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListVulnerabilitiesResponse: ListVulnerabilitiesResponse contains a single
// page of vulnerabilities resulting from a scan.
type ListVulnerabilitiesResponse struct {
	// NextPageToken: A page token that can be used in a subsequent call to
	// ListVulnerabilities to continue retrieving results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Occurrences: The list of Vulnerability Occurrences resulting from a scan.
	Occurrences []*Occurrence `json:"occurrences,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListVulnerabilitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListVulnerabilitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: An occurrence of a particular package installation found within a
// system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
type Location struct {
	// CpeUri: Deprecated. The CPE URI in CPE format
	// (https://cpe.mitre.org/specification/)
	CpeUri string `json:"cpeUri,omitempty"`
	// Path: The path from which we gathered that this package/version is
	// installed.
	Path string `json:"path,omitempty"`
	// Version: Deprecated. The version installed at this location.
	Version *Version `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpeUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpeUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Maintainer struct {
	Email string `json:"email,omitempty"`
	Kind  string `json:"kind,omitempty"`
	Name  string `json:"name,omitempty"`
	Url   string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Maintainer) MarshalJSON() ([]byte, error) {
	type NoMethod Maintainer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Material struct {
	Digest map[string]string `json:"digest,omitempty"`
	Uri    string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Material) MarshalJSON() ([]byte, error) {
	type NoMethod Material
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Metadata: Other properties of the build.
type Metadata struct {
	// BuildFinishedOn: The timestamp of when the build completed.
	BuildFinishedOn string `json:"buildFinishedOn,omitempty"`
	// BuildInvocationId: Identifies the particular build invocation, which can be
	// useful for finding associated logs or other ad-hoc analysis. The value
	// SHOULD be globally unique, per in-toto Provenance spec.
	BuildInvocationId string `json:"buildInvocationId,omitempty"`
	// BuildStartedOn: The timestamp of when the build started.
	BuildStartedOn string `json:"buildStartedOn,omitempty"`
	// Completeness: Indicates that the builder claims certain fields in this
	// message to be complete.
	Completeness *Completeness `json:"completeness,omitempty"`
	// Reproducible: If true, the builder claims that running the recipe on
	// materials will produce bit-for-bit identical output.
	Reproducible bool `json:"reproducible,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildFinishedOn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildFinishedOn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Metadata) MarshalJSON() ([]byte, error) {
	type NoMethod Metadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NonCompliantFile: Details about files that caused a compliance check to
// fail. display_command is a single command that can be used to display a list
// of non compliant files. When there is no such command, we can also iterate a
// list of non compliant file using 'path'.
type NonCompliantFile struct {
	// DisplayCommand: Command to display the non-compliant files.
	DisplayCommand string `json:"displayCommand,omitempty"`
	// Path: Empty if `display_command` is set.
	Path string `json:"path,omitempty"`
	// Reason: Explains why a file is non compliant for a CIS check.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayCommand") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayCommand") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NonCompliantFile) MarshalJSON() ([]byte, error) {
	type NoMethod NonCompliantFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Occurrence: An instance of an analysis type that has been found on a
// resource.
type Occurrence struct {
	// Attestation: Describes an attestation of an artifact.
	Attestation *AttestationOccurrence `json:"attestation,omitempty"`
	// Build: Describes a verifiable build.
	Build *BuildOccurrence `json:"build,omitempty"`
	// Compliance: Describes a compliance violation on a linked resource.
	Compliance *ComplianceOccurrence `json:"compliance,omitempty"`
	// CreateTime: Output only. The time this occurrence was created.
	CreateTime string `json:"createTime,omitempty"`
	// Deployment: Describes the deployment of an artifact on a runtime.
	Deployment *DeploymentOccurrence `json:"deployment,omitempty"`
	// Discovery: Describes when a resource was discovered.
	Discovery *DiscoveryOccurrence `json:"discovery,omitempty"`
	// DsseAttestation: Describes an attestation of an artifact using dsse.
	DsseAttestation *DSSEAttestationOccurrence `json:"dsseAttestation,omitempty"`
	// Envelope: https://github.com/secure-systems-lab/dsse
	Envelope *Envelope `json:"envelope,omitempty"`
	// Image: Describes how this resource derives from the basis in the associated
	// note.
	Image *ImageOccurrence `json:"image,omitempty"`
	// Kind: Output only. This explicitly denotes which of the occurrence details
	// are specified. This field can be used as a filter in list requests.
	//
	// Possible values:
	//   "NOTE_KIND_UNSPECIFIED" - Default value. This value is unused.
	//   "VULNERABILITY" - The note and occurrence represent a package
	// vulnerability.
	//   "BUILD" - The note and occurrence assert build provenance.
	//   "IMAGE" - This represents an image basis relationship.
	//   "PACKAGE" - This represents a package installed via a package manager.
	//   "DEPLOYMENT" - The note and occurrence track deployment events.
	//   "DISCOVERY" - The note and occurrence track the initial discovery status
	// of a resource.
	//   "ATTESTATION" - This represents a logical "role" that can attest to
	// artifacts.
	//   "UPGRADE" - This represents an available package upgrade.
	//   "COMPLIANCE" - This represents a Compliance Note
	//   "DSSE_ATTESTATION" - This represents a DSSE attestation Note
	//   "VULNERABILITY_ASSESSMENT" - This represents a Vulnerability Assessment.
	//   "SBOM_REFERENCE" - This represents an SBOM Reference.
	Kind string `json:"kind,omitempty"`
	// Name: Output only. The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `json:"name,omitempty"`
	// NoteName: Required. Immutable. The analysis note associated with this
	// occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This
	// field can be used as a filter in list requests.
	NoteName string `json:"noteName,omitempty"`
	// Package: Describes the installation of a package on the linked resource.
	Package *PackageOccurrence `json:"package,omitempty"`
	// Remediation: A description of actions that can be taken to remedy the note.
	Remediation string `json:"remediation,omitempty"`
	// ResourceUri: Required. Immutable. A URI that represents the resource for
	// which the occurrence applies. For example,
	// `https://gcr.io/project/image@sha256:123abc` for a Docker image.
	ResourceUri string `json:"resourceUri,omitempty"`
	// SbomReference: Describes a specific SBOM reference occurrences.
	SbomReference *SBOMReferenceOccurrence `json:"sbomReference,omitempty"`
	// UpdateTime: Output only. The time this occurrence was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Upgrade: Describes an available package upgrade on the linked resource.
	Upgrade *UpgradeOccurrence `json:"upgrade,omitempty"`
	// Vulnerability: Describes a security vulnerability.
	Vulnerability *VulnerabilityOccurrence `json:"vulnerability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attestation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attestation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Occurrence) MarshalJSON() ([]byte, error) {
	type NoMethod Occurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PackageData struct {
	// Architecture: The architecture of the package.
	Architecture string `json:"architecture,omitempty"`
	// BinarySourceInfo: A bundle containing the binary and source information.
	BinarySourceInfo []*BinarySourceInfo `json:"binarySourceInfo,omitempty"`
	// BinaryVersion: DEPRECATED
	BinaryVersion *PackageVersion `json:"binaryVersion,omitempty"`
	// CpeUri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
	// in which the vulnerability may manifest. Examples include distro or storage
	// location for vulnerable jar.
	CpeUri string `json:"cpeUri,omitempty"`
	// DependencyChain: The dependency chain between this package and the user's
	// artifact. List in order from the customer's package under review first, to
	// the current package last. Inclusive of the original package and the current
	// package.
	DependencyChain []*LanguagePackageDependency `json:"dependencyChain,omitempty"`
	// FileLocation: The path to the jar file / go binary file.
	FileLocation []*FileLocation `json:"fileLocation,omitempty"`
	// HashDigest: HashDigest stores the SHA512 hash digest of the jar file if the
	// package is of type Maven. This field will be unset for non Maven packages.
	HashDigest   string        `json:"hashDigest,omitempty"`
	LayerDetails *LayerDetails `json:"layerDetails,omitempty"`
	// Licenses: The list of licenses found that are related to a given package.
	// Note that licenses may also be stored on the BinarySourceInfo. If there is
	// no BinarySourceInfo (because there's no concept of source vs binary), then
	// it will be stored here, while if there are BinarySourceInfos, it will be
	// stored there, as one source can have multiple binaries with different
	// licenses.
	Licenses []string `json:"licenses,omitempty"`
	// Maintainer: The maintainer of the package.
	Maintainer *Maintainer `json:"maintainer,omitempty"`
	// Os: The OS affected by a vulnerability Used to generate the cpe_uri for OS
	// packages
	Os string `json:"os,omitempty"`
	// OsVersion: The version of the OS Used to generate the cpe_uri for OS
	// packages
	OsVersion string `json:"osVersion,omitempty"`
	// Package: The package being analysed for vulnerabilities
	Package string `json:"package,omitempty"`
	// PackageType: The type of package: os, maven, go, etc.
	//
	// Possible values:
	//   "PACKAGE_TYPE_UNSPECIFIED"
	//   "OS" - Operating System
	//   "MAVEN" - Java packages from Maven.
	//   "GO" - Go third-party packages.
	//   "GO_STDLIB" - Go toolchain + standard library packages.
	//   "PYPI" - Python packages.
	//   "NPM" - NPM packages.
	//   "NUGET" - Nuget (C#/.NET) packages.
	//   "RUBYGEMS" - Ruby packges (from RubyGems package manager).
	//   "RUST" - Rust packages from Cargo (Github ecosystem is `RUST`).
	//   "COMPOSER" - PHP packages from Composer package manager.
	//   "SWIFT" - Swift packages from Swift Package Manager (SwiftPM).
	PackageType string `json:"packageType,omitempty"`
	// PatchedCve: CVEs that this package is no longer vulnerable to
	// go/drydock-dd-custom-binary-scanning
	PatchedCve []string `json:"patchedCve,omitempty"`
	// SourceVersion: DEPRECATED
	SourceVersion *PackageVersion `json:"sourceVersion,omitempty"`
	Unused        string          `json:"unused,omitempty"`
	// Version: The version of the package being analysed
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PackageData) MarshalJSON() ([]byte, error) {
	type NoMethod PackageData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PackageIssue: A detail for a distro and package this vulnerability
// occurrence was found in and its associated fix (if one is available).
type PackageIssue struct {
	// AffectedCpeUri: Required. The CPE URI (https://cpe.mitre.org/specification/)
	// this vulnerability was found in.
	AffectedCpeUri string `json:"affectedCpeUri,omitempty"`
	// AffectedPackage: Required. The package this vulnerability was found in.
	AffectedPackage string `json:"affectedPackage,omitempty"`
	// AffectedVersion: Required. The version of the package that is installed on
	// the resource affected by this vulnerability.
	AffectedVersion *Version `json:"affectedVersion,omitempty"`
	// EffectiveSeverity: Output only. The distro or language system assigned
	// severity for this vulnerability when that is available and note provider
	// assigned severity when it is not available.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unknown.
	//   "MINIMAL" - Minimal severity.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	EffectiveSeverity string `json:"effectiveSeverity,omitempty"`
	// FileLocation: The location at which this package was found.
	FileLocation []*GrafeasV1FileLocation `json:"fileLocation,omitempty"`
	// FixAvailable: Output only. Whether a fix is available for this package.
	FixAvailable bool `json:"fixAvailable,omitempty"`
	// FixedCpeUri: The CPE URI (https://cpe.mitre.org/specification/) this
	// vulnerability was fixed in. It is possible for this to be different from the
	// affected_cpe_uri.
	FixedCpeUri string `json:"fixedCpeUri,omitempty"`
	// FixedPackage: The package this vulnerability was fixed in. It is possible
	// for this to be different from the affected_package.
	FixedPackage string `json:"fixedPackage,omitempty"`
	// FixedVersion: Required. The version of the package this vulnerability was
	// fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet available.
	FixedVersion *Version `json:"fixedVersion,omitempty"`
	// PackageType: The type of package (e.g. OS, MAVEN, GO).
	PackageType string `json:"packageType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AffectedCpeUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffectedCpeUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PackageIssue) MarshalJSON() ([]byte, error) {
	type NoMethod PackageIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PackageOccurrence: Details on how a particular software package was
// installed on a system.
type PackageOccurrence struct {
	// Architecture: Output only. The CPU architecture for which packages in this
	// distribution channel were built. Architecture will be blank for language
	// packages.
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Unknown architecture.
	//   "X86" - X86 architecture.
	//   "X64" - X64 architecture.
	Architecture string `json:"architecture,omitempty"`
	// CpeUri: Output only. The cpe_uri in CPE format
	// (https://cpe.mitre.org/specification/) denoting the package manager version
	// distributing a package. The cpe_uri will be blank for language packages.
	CpeUri string `json:"cpeUri,omitempty"`
	// License: Licenses that have been declared by the authors of the package.
	License *License `json:"license,omitempty"`
	// Location: All of the places within the filesystem versions of this package
	// have been found.
	Location []*Location `json:"location,omitempty"`
	// Name: Required. Output only. The name of the installed package.
	Name string `json:"name,omitempty"`
	// PackageType: Output only. The type of package; whether native or non native
	// (e.g., ruby gems, node.js packages, etc.).
	PackageType string `json:"packageType,omitempty"`
	// Version: Output only. The version of the package.
	Version *Version `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PackageOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod PackageOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PackageVersion struct {
	// Licenses: The licenses associated with this package. Note that this has to
	// go on the PackageVersion level, because we can have cases with images with
	// the same source having different licences. E.g. in Alpine, musl and
	// musl-utils both have the same origin musl, but have different sets of
	// licenses.
	Licenses []string `json:"licenses,omitempty"`
	Name     string   `json:"name,omitempty"`
	Version  string   `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Licenses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Licenses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PackageVersion) MarshalJSON() ([]byte, error) {
	type NoMethod PackageVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProjectRepoId: Selects a repo using a Google Cloud Platform project ID
// (e.g., winged-cargo-31) and a repo name within that project.
type ProjectRepoId struct {
	// ProjectId: The ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// RepoName: The name of the repo. Leave empty for the default repo.
	RepoName string `json:"repoName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectRepoId) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectRepoId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProvenanceBuilder struct {
	BuilderDependencies []*ResourceDescriptor `json:"builderDependencies,omitempty"`
	Id                  string                `json:"id,omitempty"`
	Version             map[string]string     `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuilderDependencies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuilderDependencies") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProvenanceBuilder) MarshalJSON() ([]byte, error) {
	type NoMethod ProvenanceBuilder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Recipe: Steps taken to build the artifact. For a TaskRun, typically each
// container corresponds to one step in the recipe.
type Recipe struct {
	// Arguments: Collection of all external inputs that influenced the build on
	// top of recipe.definedInMaterial and recipe.entryPoint. For example, if the
	// recipe type were "make", then this might be the flags passed to make aside
	// from the target, which is captured in recipe.entryPoint. Since the arguments
	// field can greatly vary in structure, depending on the builder and recipe
	// type, this is of form "Any".
	Arguments []googleapi.RawMessage `json:"arguments,omitempty"`
	// DefinedInMaterial: Index in materials containing the recipe steps that are
	// not implied by recipe.type. For example, if the recipe type were "make",
	// then this would point to the source containing the Makefile, not the make
	// program itself. Set to -1 if the recipe doesn't come from a material, as
	// zero is default unset value for int64.
	DefinedInMaterial int64 `json:"definedInMaterial,omitempty,string"`
	// EntryPoint: String identifying the entry point into the build. This is often
	// a path to a configuration file and/or a target label within that file. The
	// syntax and meaning are defined by recipe.type. For example, if the recipe
	// type were "make", then this would reference the directory in which to run
	// make as well as which target to use.
	EntryPoint string `json:"entryPoint,omitempty"`
	// Environment: Any other builder-controlled inputs necessary for correctly
	// evaluating the recipe. Usually only needed for reproducing the build but not
	// evaluated as part of policy. Since the environment field can greatly vary in
	// structure, depending on the builder and recipe type, this is of form "Any".
	Environment []googleapi.RawMessage `json:"environment,omitempty"`
	// Type: URI indicating what type of recipe was performed. It determines the
	// meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and
	// materials.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Recipe) MarshalJSON() ([]byte, error) {
	type NoMethod Recipe
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RelatedUrl: Metadata for any related URL information.
type RelatedUrl struct {
	// Label: Label to describe usage of the URL.
	Label string `json:"label,omitempty"`
	// Url: Specific URL associated with the resource.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RelatedUrl) MarshalJSON() ([]byte, error) {
	type NoMethod RelatedUrl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Remediation: Specifies details on how to handle (and presumably, fix) a
// vulnerability.
type Remediation struct {
	// Details: Contains a comprehensive human-readable discussion of the
	// remediation.
	Details string `json:"details,omitempty"`
	// RemediationType: The type of remediation that can be applied.
	//
	// Possible values:
	//   "REMEDIATION_TYPE_UNSPECIFIED" - No remediation type specified.
	//   "MITIGATION" - A MITIGATION is available.
	//   "NO_FIX_PLANNED" - No fix is planned.
	//   "NONE_AVAILABLE" - Not available.
	//   "VENDOR_FIX" - A vendor fix is available.
	//   "WORKAROUND" - A workaround is available.
	RemediationType string `json:"remediationType,omitempty"`
	// RemediationUri: Contains the URL where to obtain the remediation.
	RemediationUri *RelatedUrl `json:"remediationUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Remediation) MarshalJSON() ([]byte, error) {
	type NoMethod Remediation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RepoId: A unique identifier for a Cloud Repo.
type RepoId struct {
	// ProjectRepoId: A combination of a project ID and a repo name.
	ProjectRepoId *ProjectRepoId `json:"projectRepoId,omitempty"`
	// Uid: A server-assigned, globally unique identifier.
	Uid string `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectRepoId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectRepoId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RepoId) MarshalJSON() ([]byte, error) {
	type NoMethod RepoId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceDescriptor struct {
	Annotations      googleapi.RawMessage `json:"annotations,omitempty"`
	Content          string               `json:"content,omitempty"`
	Digest           map[string]string    `json:"digest,omitempty"`
	DownloadLocation string               `json:"downloadLocation,omitempty"`
	MediaType        string               `json:"mediaType,omitempty"`
	Name             string               `json:"name,omitempty"`
	Uri              string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RunDetails struct {
	Builder    *ProvenanceBuilder    `json:"builder,omitempty"`
	Byproducts []*ResourceDescriptor `json:"byproducts,omitempty"`
	Metadata   *BuildMetadata        `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Builder") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Builder") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunDetails) MarshalJSON() ([]byte, error) {
	type NoMethod RunDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SBOMReferenceOccurrence: The occurrence representing an SBOM reference as
// applied to a specific resource. The occurrence follows the DSSE
// specification. See
// https://github.com/secure-systems-lab/dsse/blob/master/envelope.md for more
// details.
type SBOMReferenceOccurrence struct {
	// Payload: The actual payload that contains the SBOM reference data.
	Payload *SbomReferenceIntotoPayload `json:"payload,omitempty"`
	// PayloadType: The kind of payload that SbomReferenceIntotoPayload takes.
	// Since it's in the intoto format, this value is expected to be
	// 'application/vnd.in-toto+json'.
	PayloadType string `json:"payloadType,omitempty"`
	// Signatures: The signatures over the payload.
	Signatures []*EnvelopeSignature `json:"signatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SBOMReferenceOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod SBOMReferenceOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SBOMStatus: The status of an SBOM generation.
type SBOMStatus struct {
	// Error: If there was an error generating an SBOM, this will indicate what
	// that error was.
	Error string `json:"error,omitempty"`
	// SbomState: The progress of the SBOM generation.
	//
	// Possible values:
	//   "SBOM_STATE_UNSPECIFIED" - Default unknown state.
	//   "PENDING" - SBOM scanning is pending.
	//   "COMPLETE" - SBOM scanning has completed.
	SbomState string `json:"sbomState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SBOMStatus) MarshalJSON() ([]byte, error) {
	type NoMethod SBOMStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SbomReferenceIntotoPayload: The actual payload that contains the SBOM
// Reference data. The payload follows the intoto statement specification. See
// https://github.com/in-toto/attestation/blob/main/spec/v1.0/statement.md for
// more details.
type SbomReferenceIntotoPayload struct {
	// Type: Identifier for the schema of the Statement.
	Type string `json:"_type,omitempty"`
	// Predicate: Additional parameters of the Predicate. Includes the actual data
	// about the SBOM.
	Predicate *SbomReferenceIntotoPredicate `json:"predicate,omitempty"`
	// PredicateType: URI identifying the type of the Predicate.
	PredicateType string `json:"predicateType,omitempty"`
	// Subject: Set of software artifacts that the attestation applies to. Each
	// element represents a single software artifact.
	Subject []*Subject `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SbomReferenceIntotoPayload) MarshalJSON() ([]byte, error) {
	type NoMethod SbomReferenceIntotoPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SbomReferenceIntotoPredicate: A predicate which describes the SBOM being
// referenced.
type SbomReferenceIntotoPredicate struct {
	// Digest: A map of algorithm to digest of the contents of the SBOM.
	Digest map[string]string `json:"digest,omitempty"`
	// Location: The location of the SBOM.
	Location string `json:"location,omitempty"`
	// MimeType: The mime type of the SBOM.
	MimeType string `json:"mimeType,omitempty"`
	// ReferrerId: The person or system referring this predicate to the consumer.
	ReferrerId string `json:"referrerId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SbomReferenceIntotoPredicate) MarshalJSON() ([]byte, error) {
	type NoMethod SbomReferenceIntotoPredicate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Signature: Verifiers (e.g. Kritis implementations) MUST verify signatures
// with respect to the trust anchors defined in policy (e.g. a Kritis policy).
// Typically this means that the verifier has been configured with a map from
// `public_key_id` to public key material (and any required parameters, e.g.
// signing algorithm). In particular, verification implementations MUST NOT
// treat the signature `public_key_id` as anything more than a key lookup hint.
// The `public_key_id` DOES NOT validate or authenticate a public key; it only
// provides a mechanism for quickly selecting a public key ALREADY CONFIGURED
// on the verifier through a trusted channel. Verification implementations MUST
// reject signatures in any of the following circumstances: * The
// `public_key_id` is not recognized by the verifier. * The public key that
// `public_key_id` refers to does not verify the signature with respect to the
// payload. The `signature` contents SHOULD NOT be "attached" (where the
// payload is included with the serialized `signature` bytes). Verifiers MUST
// ignore any "attached" payload and only verify signatures with respect to
// explicitly provided payload (e.g. a `payload` field on the proto message
// that holds this Signature, or the canonical serialization of the proto
// message that holds this signature).
type Signature struct {
	// PublicKeyId: The identifier for the public key that verifies this signature.
	// * The `public_key_id` is required. * The `public_key_id` SHOULD be an
	// RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an
	// immutable reference, such as a cryptographic digest. Examples of valid
	// `public_key_id`s: OpenPGP V4 public key fingerprint: *
	// "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See
	// https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
	// details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of
	// the DER serialization): *
	// "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" *
	// "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a127158
	// 9a5"
	PublicKeyId string `json:"publicKeyId,omitempty"`
	// Signature: The content of the signature, an opaque bytestring. The payload
	// that this signature verifies MUST be unambiguously provided with the
	// Signature during verification. A wrapper message might provide the payload
	// explicitly. Alternatively, a message might have a canonical serialization
	// that can always be unambiguously computed to derive the payload.
	Signature string `json:"signature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublicKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublicKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Signature) MarshalJSON() ([]byte, error) {
	type NoMethod Signature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SlsaBuilder struct {
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaBuilder) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaBuilder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaCompleteness: Indicates that the builder claims certain fields in this
// message to be complete.
type SlsaCompleteness struct {
	// Arguments: If true, the builder claims that recipe.arguments is complete,
	// meaning that all external inputs are properly captured in the recipe.
	Arguments bool `json:"arguments,omitempty"`
	// Environment: If true, the builder claims that recipe.environment is claimed
	// to be complete.
	Environment bool `json:"environment,omitempty"`
	// Materials: If true, the builder claims that materials are complete, usually
	// through some controls to prevent network access. Sometimes called
	// "hermetic".
	Materials bool `json:"materials,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaCompleteness) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaCompleteness
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaMetadata: Other properties of the build.
type SlsaMetadata struct {
	// BuildFinishedOn: The timestamp of when the build completed.
	BuildFinishedOn string `json:"buildFinishedOn,omitempty"`
	// BuildInvocationId: Identifies the particular build invocation, which can be
	// useful for finding associated logs or other ad-hoc analysis. The value
	// SHOULD be globally unique, per in-toto Provenance spec.
	BuildInvocationId string `json:"buildInvocationId,omitempty"`
	// BuildStartedOn: The timestamp of when the build started.
	BuildStartedOn string `json:"buildStartedOn,omitempty"`
	// Completeness: Indicates that the builder claims certain fields in this
	// message to be complete.
	Completeness *SlsaCompleteness `json:"completeness,omitempty"`
	// Reproducible: If true, the builder claims that running the recipe on
	// materials will produce bit-for-bit identical output.
	Reproducible bool `json:"reproducible,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildFinishedOn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildFinishedOn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SlsaProvenance struct {
	// Builder: required
	Builder *SlsaBuilder `json:"builder,omitempty"`
	// Materials: The collection of artifacts that influenced the build including
	// sources, dependencies, build tools, base images, and so on. This is
	// considered to be incomplete unless metadata.completeness.materials is true.
	// Unset or null is equivalent to empty.
	Materials []*Material   `json:"materials,omitempty"`
	Metadata  *SlsaMetadata `json:"metadata,omitempty"`
	// Recipe: Identifies the configuration used for the build. When combined with
	// materials, this SHOULD fully describe the build, such that re-running this
	// recipe results in bit-for-bit identical output (if the build is
	// reproducible). required
	Recipe *SlsaRecipe `json:"recipe,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Builder") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Builder") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaProvenanceV1: Keep in sync with schema at
// https://github.com/slsa-framework/slsa/blob/main/docs/provenance/schema/v1/provenance.proto
// Builder renamed to ProvenanceBuilder because of Java conflicts.
type SlsaProvenanceV1 struct {
	BuildDefinition *BuildDefinition `json:"buildDefinition,omitempty"`
	RunDetails      *RunDetails      `json:"runDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildDefinition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildDefinition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaProvenanceV1) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaProvenanceV1
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaProvenanceZeroTwo: See full explanation of fields at
// slsa.dev/provenance/v0.2.
type SlsaProvenanceZeroTwo struct {
	BuildConfig googleapi.RawMessage                          `json:"buildConfig,omitempty"`
	BuildType   string                                        `json:"buildType,omitempty"`
	Builder     *GrafeasV1SlsaProvenanceZeroTwoSlsaBuilder    `json:"builder,omitempty"`
	Invocation  *GrafeasV1SlsaProvenanceZeroTwoSlsaInvocation `json:"invocation,omitempty"`
	Materials   []*GrafeasV1SlsaProvenanceZeroTwoSlsaMaterial `json:"materials,omitempty"`
	Metadata    *GrafeasV1SlsaProvenanceZeroTwoSlsaMetadata   `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaProvenanceZeroTwo) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaProvenanceZeroTwo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaRecipe: Steps taken to build the artifact. For a TaskRun, typically each
// container corresponds to one step in the recipe.
type SlsaRecipe struct {
	// Arguments: Collection of all external inputs that influenced the build on
	// top of recipe.definedInMaterial and recipe.entryPoint. For example, if the
	// recipe type were "make", then this might be the flags passed to make aside
	// from the target, which is captured in recipe.entryPoint. Depending on the
	// recipe Type, the structure may be different.
	Arguments googleapi.RawMessage `json:"arguments,omitempty"`
	// DefinedInMaterial: Index in materials containing the recipe steps that are
	// not implied by recipe.type. For example, if the recipe type were "make",
	// then this would point to the source containing the Makefile, not the make
	// program itself. Set to -1 if the recipe doesn't come from a material, as
	// zero is default unset value for int64.
	DefinedInMaterial int64 `json:"definedInMaterial,omitempty,string"`
	// EntryPoint: String identifying the entry point into the build. This is often
	// a path to a configuration file and/or a target label within that file. The
	// syntax and meaning are defined by recipe.type. For example, if the recipe
	// type were "make", then this would reference the directory in which to run
	// make as well as which target to use.
	EntryPoint string `json:"entryPoint,omitempty"`
	// Environment: Any other builder-controlled inputs necessary for correctly
	// evaluating the recipe. Usually only needed for reproducing the build but not
	// evaluated as part of policy. Depending on the recipe Type, the structure may
	// be different.
	Environment googleapi.RawMessage `json:"environment,omitempty"`
	// Type: URI indicating what type of recipe was performed. It determines the
	// meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and
	// materials.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaRecipe) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaRecipe
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Source: Source describes the location of the source used for the build.
type Source struct {
	// AdditionalContexts: If provided, some of the source code used for the build
	// may be found in these locations, in the case where the source repository had
	// multiple remotes or submodules. This list will not include the context
	// specified in the context field.
	AdditionalContexts []*SourceContext `json:"additionalContexts,omitempty"`
	// ArtifactStorageSourceUri: If provided, the input binary artifacts for the
	// build came from this location.
	ArtifactStorageSourceUri string `json:"artifactStorageSourceUri,omitempty"`
	// Context: If provided, the source code used for the build came from this
	// location.
	Context *SourceContext `json:"context,omitempty"`
	// FileHashes: Hash(es) of the build source, which can be used to verify that
	// the original source integrity was maintained in the build. The keys to this
	// map are file paths used as build source and the values contain the hash
	// values for those files. If the build source came in a single package such as
	// a gzipped tarfile (.tar.gz), the FileHash will be for the single path to
	// that file.
	FileHashes map[string]FileHashes `json:"fileHashes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalContexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalContexts") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Source) MarshalJSON() ([]byte, error) {
	type NoMethod Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SourceContext: A SourceContext is a reference to a tree of files. A
// SourceContext together with a path point to a unique revision of a single
// file or directory.
type SourceContext struct {
	// CloudRepo: A SourceContext referring to a revision in a Google Cloud Source
	// Repo.
	CloudRepo *CloudRepoSourceContext `json:"cloudRepo,omitempty"`
	// Gerrit: A SourceContext referring to a Gerrit project.
	Gerrit *GerritSourceContext `json:"gerrit,omitempty"`
	// Git: A SourceContext referring to any third party Git repo (e.g., GitHub).
	Git *GitSourceContext `json:"git,omitempty"`
	// Labels: Labels with user defined metadata.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudRepo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudRepo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod SourceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Subject struct {
	// Digest: "": "" Algorithms can be e.g. sha256, sha512 See
	// https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
	Digest map[string]string `json:"digest,omitempty"`
	Name   string            `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digest") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digest") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Subject) MarshalJSON() ([]byte, error) {
	type NoMethod Subject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeDistribution: The Upgrade Distribution represents metadata about the
// Upgrade for each operating system (CPE). Some distributions have additional
// metadata around updates, classifying them into various categories and
// severities.
type UpgradeDistribution struct {
	// Classification: The operating system classification of this Upgrade, as
	// specified by the upstream operating system upgrade feed. For Windows the
	// classification is one of the category_ids listed at
	// https://docs.microsoft.com/en-us/previous-versions/windows/desktop/ff357803(v=vs.85)
	Classification string `json:"classification,omitempty"`
	// CpeUri: Required - The specific operating system this metadata applies to.
	// See https://cpe.mitre.org/specification/.
	CpeUri string `json:"cpeUri,omitempty"`
	// Cve: The cve tied to this Upgrade.
	Cve []string `json:"cve,omitempty"`
	// Severity: The severity as specified by the upstream operating system.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Classification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Classification") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpgradeOccurrence: An Upgrade Occurrence represents that a specific
// resource_url could install a specific upgrade. This presence is supplied via
// local sources (i.e. it is present in the mirror and the running system has
// noticed its availability). For Windows, both distribution and windows_update
// contain information for the Windows update.
type UpgradeOccurrence struct {
	// Distribution: Metadata about the upgrade for available for the specific
	// operating system for the resource_url. This allows efficient filtering, as
	// well as making it easier to use the occurrence.
	Distribution *UpgradeDistribution `json:"distribution,omitempty"`
	// Package: Required for non-Windows OS. The package this Upgrade is for.
	Package string `json:"package,omitempty"`
	// ParsedVersion: Required for non-Windows OS. The version of the package in a
	// machine + human readable form.
	ParsedVersion *Version `json:"parsedVersion,omitempty"`
	// WindowsUpdate: Required for Windows OS. Represents the metadata about the
	// Windows update.
	WindowsUpdate *WindowsUpdate `json:"windowsUpdate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Distribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Distribution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpgradeOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod UpgradeOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Version: Version contains structured information about the version of a
// package.
type Version struct {
	// Epoch: Used to correct mistakes in the version numbering scheme.
	Epoch int64 `json:"epoch,omitempty"`
	// FullName: Human readable version string. This string is of the form :- and
	// is only set when kind is NORMAL.
	FullName string `json:"fullName,omitempty"`
	// Inclusive: Whether this version is specifying part of an inclusive range.
	// Grafeas does not have the capability to specify version ranges; instead we
	// have fields that specify start version and end versions. At times this is
	// insufficient - we also need to specify whether the version is included in
	// the range or is excluded from the range. This boolean is expected to be set
	// to true when the version is included in a range.
	Inclusive bool `json:"inclusive,omitempty"`
	// Kind: Required. Distinguishes between sentinel MIN/MAX versions and normal
	// versions.
	//
	// Possible values:
	//   "VERSION_KIND_UNSPECIFIED" - Unknown.
	//   "NORMAL" - A standard package version.
	//   "MINIMUM" - A special version representing negative infinity.
	//   "MAXIMUM" - A special version representing positive infinity.
	Kind string `json:"kind,omitempty"`
	// Name: Required only when version kind is NORMAL. The main part of the
	// version name.
	Name string `json:"name,omitempty"`
	// Revision: The iteration of the package build from the above version.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Epoch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Epoch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Version) MarshalJSON() ([]byte, error) {
	type NoMethod Version
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VexAssessment: VexAssessment provides all publisher provided Vex information
// that is related to this vulnerability.
type VexAssessment struct {
	// Cve: Holds the MITRE standard Common Vulnerabilities and Exposures (CVE)
	// tracking number for the vulnerability. Deprecated: Use vulnerability_id
	// instead to denote CVEs.
	Cve string `json:"cve,omitempty"`
	// Impacts: Contains information about the impact of this vulnerability, this
	// will change with time.
	Impacts []string `json:"impacts,omitempty"`
	// Justification: Justification provides the justification when the state of
	// the assessment if NOT_AFFECTED.
	Justification *Justification `json:"justification,omitempty"`
	// NoteName: The VulnerabilityAssessment note from which this VexAssessment was
	// generated. This will be of the form:
	// `projects/[PROJECT_ID]/notes/[NOTE_ID]`.
	NoteName string `json:"noteName,omitempty"`
	// RelatedUris: Holds a list of references associated with this vulnerability
	// item and assessment.
	RelatedUris []*RelatedUrl `json:"relatedUris,omitempty"`
	// Remediations: Specifies details on how to handle (and presumably, fix) a
	// vulnerability.
	Remediations []*Remediation `json:"remediations,omitempty"`
	// State: Provides the state of this Vulnerability assessment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - No state is specified.
	//   "AFFECTED" - This product is known to be affected by this vulnerability.
	//   "NOT_AFFECTED" - This product is known to be not affected by this
	// vulnerability.
	//   "FIXED" - This product contains a fix for this vulnerability.
	//   "UNDER_INVESTIGATION" - It is not known yet whether these versions are or
	// are not affected by the vulnerability. However, it is still under
	// investigation.
	State string `json:"state,omitempty"`
	// VulnerabilityId: The vulnerability identifier for this Assessment. Will hold
	// one of common identifiers e.g. CVE, GHSA etc.
	VulnerabilityId string `json:"vulnerabilityId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cve") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cve") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VexAssessment) MarshalJSON() ([]byte, error) {
	type NoMethod VexAssessment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityOccurrence: An occurrence of a severity vulnerability on a
// resource.
type VulnerabilityOccurrence struct {
	// CvssScore: Output only. The CVSS score of this vulnerability. CVSS score is
	// on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float64 `json:"cvssScore,omitempty"`
	// CvssV2: The cvss v2 score for the vulnerability.
	CvssV2 *CVSS `json:"cvssV2,omitempty"`
	// CvssVersion: Output only. CVSS version used to populate cvss_score and
	// severity.
	//
	// Possible values:
	//   "CVSS_VERSION_UNSPECIFIED"
	//   "CVSS_VERSION_2"
	//   "CVSS_VERSION_3"
	CvssVersion string `json:"cvssVersion,omitempty"`
	// Cvssv3: The cvss v3 score for the vulnerability.
	Cvssv3 *CVSS `json:"cvssv3,omitempty"`
	// EffectiveSeverity: The distro assigned severity for this vulnerability when
	// it is available, otherwise this is the note provider assigned severity. When
	// there are multiple PackageIssues for this vulnerability, they can have
	// different effective severities because some might be provided by the distro
	// while others are provided by the language ecosystem for a language pack. For
	// this reason, it is advised to use the effective severity on the PackageIssue
	// level. In the case where multiple PackageIssues have differing effective
	// severities, this field should be the highest severity for any of the
	// PackageIssues.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unknown.
	//   "MINIMAL" - Minimal severity.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	EffectiveSeverity string `json:"effectiveSeverity,omitempty"`
	// ExtraDetails: Occurrence-specific extra details about the vulnerability.
	ExtraDetails string `json:"extraDetails,omitempty"`
	// FixAvailable: Output only. Whether at least one of the affected packages has
	// a fix available.
	FixAvailable bool `json:"fixAvailable,omitempty"`
	// LongDescription: Output only. A detailed description of this vulnerability.
	LongDescription string `json:"longDescription,omitempty"`
	// PackageIssue: Required. The set of affected locations and their fixes (if
	// available) within the associated resource.
	PackageIssue []*PackageIssue `json:"packageIssue,omitempty"`
	// RelatedUrls: Output only. URLs related to this vulnerability.
	RelatedUrls []*RelatedUrl `json:"relatedUrls,omitempty"`
	// Severity: Output only. The note provider assigned severity of this
	// vulnerability.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unknown.
	//   "MINIMAL" - Minimal severity.
	//   "LOW" - Low severity.
	//   "MEDIUM" - Medium severity.
	//   "HIGH" - High severity.
	//   "CRITICAL" - Critical severity.
	Severity string `json:"severity,omitempty"`
	// ShortDescription: Output only. A one sentence description of this
	// vulnerability.
	ShortDescription string `json:"shortDescription,omitempty"`
	// Type: The type of package; whether native or non native (e.g., ruby gems,
	// node.js packages, etc.).
	Type          string         `json:"type,omitempty"`
	VexAssessment *VexAssessment `json:"vexAssessment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CvssScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CvssScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *VulnerabilityOccurrence) UnmarshalJSON(data []byte) error {
	type NoMethod VulnerabilityOccurrence
	var s1 struct {
		CvssScore gensupport.JSONFloat64 `json:"cvssScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CvssScore = float64(s1.CvssScore)
	return nil
}

// WindowsUpdate: Windows Update represents the metadata about the update for
// the Windows operating system. The fields in this message come from the
// Windows Update API documented at
// https://docs.microsoft.com/en-us/windows/win32/api/wuapi/nn-wuapi-iupdate.
type WindowsUpdate struct {
	// Categories: The list of categories to which the update belongs.
	Categories []*Category `json:"categories,omitempty"`
	// Description: The localized description of the update.
	Description string `json:"description,omitempty"`
	// Identity: Required - The unique identifier for the update.
	Identity *Identity `json:"identity,omitempty"`
	// KbArticleIds: The Microsoft Knowledge Base article IDs that are associated
	// with the update.
	KbArticleIds []string `json:"kbArticleIds,omitempty"`
	// LastPublishedTimestamp: The last published timestamp of the update.
	LastPublishedTimestamp string `json:"lastPublishedTimestamp,omitempty"`
	// SupportUrl: The hyperlink to the support information for the update.
	SupportUrl string `json:"supportUrl,omitempty"`
	// Title: The localized title of the update.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WindowsUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsWaitCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Wait: Waits until the specified long-running operation is done or reaches at
// most a specified timeout, returning the latest state. If the operation is
// already done, the latest state is immediately returned. If the timeout
// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC timeout
// is used. If the server does not support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort
// basis. It may return the latest state before the specified timeout
// (including immediately), meaning even an immediate response is no guarantee
// that the operation is done.
//
// - name: The name of the operation resource to wait on.
func (r *ProjectsLocationsOperationsService) Wait(name string) *ProjectsLocationsOperationsWaitCall {
	c := &ProjectsLocationsOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Timeout sets the optional parameter "timeout": The maximum duration to wait
// before timing out. If left blank, the wait will be at most the time
// permitted by the underlying HTTP/RPC protocol. If RPC context deadline is
// also specified, the shorter one will be used.
func (c *ProjectsLocationsOperationsWaitCall) Timeout(timeout string) *ProjectsLocationsOperationsWaitCall {
	c.urlParams_.Set("timeout", timeout)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsWaitCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsWaitCall) Context(ctx context.Context) *ProjectsLocationsOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.wait", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.operations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsWaitCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.operations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScansAnalyzePackagesCall struct {
	s                      *Service
	parent                 string
	analyzepackagesrequest *AnalyzePackagesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// AnalyzePackages: Initiates an analysis of the provided packages.
//
//   - parent: The parent of the resource for which analysis is requested.
//     Format: projects/[project_name]/locations/[location].
func (r *ProjectsLocationsScansService) AnalyzePackages(parent string, analyzepackagesrequest *AnalyzePackagesRequest) *ProjectsLocationsScansAnalyzePackagesCall {
	c := &ProjectsLocationsScansAnalyzePackagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.analyzepackagesrequest = analyzepackagesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScansAnalyzePackagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsScansAnalyzePackagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScansAnalyzePackagesCall) Context(ctx context.Context) *ProjectsLocationsScansAnalyzePackagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScansAnalyzePackagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScansAnalyzePackagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.analyzepackagesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/scans:analyzePackages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.scans.analyzePackages", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.scans.analyzePackages" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsScansAnalyzePackagesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.scans.analyzePackages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsScansVulnerabilitiesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists vulnerabilities resulting from a successfully completed scan.
//
//   - parent: The parent of the collection of Vulnerabilities being requested.
//     Format: projects/[project_name]/locations/[location]/scans/[scan_id].
func (r *ProjectsLocationsScansVulnerabilitiesService) List(parent string) *ProjectsLocationsScansVulnerabilitiesListCall {
	c := &ProjectsLocationsScansVulnerabilitiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The number of
// vulnerabilities to retrieve.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) PageSize(pageSize int64) *ProjectsLocationsScansVulnerabilitiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token, resulting
// from a previous call to ListVulnerabilities.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) PageToken(pageToken string) *ProjectsLocationsScansVulnerabilitiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsScansVulnerabilitiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsScansVulnerabilitiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) Context(ctx context.Context) *ProjectsLocationsScansVulnerabilitiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsScansVulnerabilitiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/vulnerabilities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.scans.vulnerabilities.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "ondemandscanning.projects.locations.scans.vulnerabilities.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListVulnerabilitiesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) Do(opts ...googleapi.CallOption) (*ListVulnerabilitiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListVulnerabilitiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "ondemandscanning.projects.locations.scans.vulnerabilities.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsScansVulnerabilitiesListCall) Pages(ctx context.Context, f func(*ListVulnerabilitiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
