// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptResourceShareInvitation = "AcceptResourceShareInvitation"

// AcceptResourceShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptResourceShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptResourceShareInvitation for more information on using the AcceptResourceShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptResourceShareInvitationRequest method.
//	req, resp := client.AcceptResourceShareInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation
func (c *RAM) AcceptResourceShareInvitationRequest(input *AcceptResourceShareInvitationInput) (req *request.Request, output *AcceptResourceShareInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptResourceShareInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/acceptresourceshareinvitation",
	}

	if input == nil {
		input = &AcceptResourceShareInvitationInput{}
	}

	output = &AcceptResourceShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptResourceShareInvitation API operation for AWS Resource Access Manager.
//
// Accepts an invitation to a resource share from another Amazon Web Services
// account. After you accept the invitation, the resources included in the resource
// share are available to interact with in the relevant Amazon Web Services
// Management Consoles and tools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AcceptResourceShareInvitation for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ResourceShareInvitationArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     for an invitation was not found.
//
//   - ResourceShareInvitationAlreadyAcceptedException
//     The operation failed because the specified invitation was already accepted.
//
//   - ResourceShareInvitationAlreadyRejectedException
//     The operation failed because the specified invitation was already rejected.
//
//   - ResourceShareInvitationExpiredException
//     The operation failed because the specified invitation is past its expiration
//     date and time.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation
func (c *RAM) AcceptResourceShareInvitation(input *AcceptResourceShareInvitationInput) (*AcceptResourceShareInvitationOutput, error) {
	req, out := c.AcceptResourceShareInvitationRequest(input)
	return out, req.Send()
}

// AcceptResourceShareInvitationWithContext is the same as AcceptResourceShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptResourceShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AcceptResourceShareInvitationWithContext(ctx aws.Context, input *AcceptResourceShareInvitationInput, opts ...request.Option) (*AcceptResourceShareInvitationOutput, error) {
	req, out := c.AcceptResourceShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResourceShare = "AssociateResourceShare"

// AssociateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResourceShare for more information on using the AssociateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResourceShareRequest method.
//	req, resp := client.AssociateResourceShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare
func (c *RAM) AssociateResourceShareRequest(input *AssociateResourceShareInput) (req *request.Request, output *AssociateResourceShareOutput) {
	op := &request.Operation{
		Name:       opAssociateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/associateresourceshare",
	}

	if input == nil {
		input = &AssociateResourceShareInput{}
	}

	output = &AssociateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResourceShare API operation for AWS Resource Access Manager.
//
// Adds the specified list of principals and list of resources to a resource
// share. Principals that already have access to this resource share immediately
// receive access to the added resources. Newly added principals immediately
// receive access to the resources shared in this resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AssociateResourceShare for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - ResourceShareLimitExceededException
//     The operation failed because it would exceed the limit for resource shares
//     for your account. To view the limits for your Amazon Web Services account,
//     see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - ThrottlingException
//     The operation failed because it exceeded the rate at which you are allowed
//     to perform this operation. Please try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare
func (c *RAM) AssociateResourceShare(input *AssociateResourceShareInput) (*AssociateResourceShareOutput, error) {
	req, out := c.AssociateResourceShareRequest(input)
	return out, req.Send()
}

// AssociateResourceShareWithContext is the same as AssociateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AssociateResourceShareWithContext(ctx aws.Context, input *AssociateResourceShareInput, opts ...request.Option) (*AssociateResourceShareOutput, error) {
	req, out := c.AssociateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResourceSharePermission = "AssociateResourceSharePermission"

// AssociateResourceSharePermissionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResourceSharePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResourceSharePermission for more information on using the AssociateResourceSharePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResourceSharePermissionRequest method.
//	req, resp := client.AssociateResourceSharePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission
func (c *RAM) AssociateResourceSharePermissionRequest(input *AssociateResourceSharePermissionInput) (req *request.Request, output *AssociateResourceSharePermissionOutput) {
	op := &request.Operation{
		Name:       opAssociateResourceSharePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/associateresourcesharepermission",
	}

	if input == nil {
		input = &AssociateResourceSharePermissionInput{}
	}

	output = &AssociateResourceSharePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResourceSharePermission API operation for AWS Resource Access Manager.
//
// Adds or replaces the RAM permission for a resource type included in a resource
// share. You can have exactly one permission associated with each resource
// type in the resource share. You can add a new RAM permission only if there
// are currently no resources of that resource type currently in the resource
// share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation AssociateResourceSharePermission for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceSharePermission
func (c *RAM) AssociateResourceSharePermission(input *AssociateResourceSharePermissionInput) (*AssociateResourceSharePermissionOutput, error) {
	req, out := c.AssociateResourceSharePermissionRequest(input)
	return out, req.Send()
}

// AssociateResourceSharePermissionWithContext is the same as AssociateResourceSharePermission with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResourceSharePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) AssociateResourceSharePermissionWithContext(ctx aws.Context, input *AssociateResourceSharePermissionInput, opts ...request.Option) (*AssociateResourceSharePermissionOutput, error) {
	req, out := c.AssociateResourceSharePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermission = "CreatePermission"

// CreatePermissionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermission for more information on using the CreatePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePermissionRequest method.
//	req, resp := client.CreatePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermission
func (c *RAM) CreatePermissionRequest(input *CreatePermissionInput) (req *request.Request, output *CreatePermissionOutput) {
	op := &request.Operation{
		Name:       opCreatePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/createpermission",
	}

	if input == nil {
		input = &CreatePermissionInput{}
	}

	output = &CreatePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePermission API operation for AWS Resource Access Manager.
//
// Creates a customer managed permission for a specified resource type that
// you can attach to resource shares. It is created in the Amazon Web Services
// Region in which you call the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation CreatePermission for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - InvalidPolicyException
//     The operation failed because a policy you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - PermissionAlreadyExistsException
//     The operation failed because a permission with the specified name already
//     exists in the requested Amazon Web Services Region. Choose a different name.
//
//   - MalformedPolicyTemplateException
//     The operation failed because the policy template that you provided isn't
//     valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - PermissionLimitExceededException
//     The operation failed because it would exceed the maximum number of permissions
//     you can create in each Amazon Web Services Region. To view the limits for
//     your Amazon Web Services account, see the RAM page in the Service Quotas
//     console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermission
func (c *RAM) CreatePermission(input *CreatePermissionInput) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	return out, req.Send()
}

// CreatePermissionWithContext is the same as CreatePermission with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) CreatePermissionWithContext(ctx aws.Context, input *CreatePermissionInput, opts ...request.Option) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermissionVersion = "CreatePermissionVersion"

// CreatePermissionVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermissionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermissionVersion for more information on using the CreatePermissionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePermissionVersionRequest method.
//	req, resp := client.CreatePermissionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermissionVersion
func (c *RAM) CreatePermissionVersionRequest(input *CreatePermissionVersionInput) (req *request.Request, output *CreatePermissionVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePermissionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/createpermissionversion",
	}

	if input == nil {
		input = &CreatePermissionVersionInput{}
	}

	output = &CreatePermissionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePermissionVersion API operation for AWS Resource Access Manager.
//
// Creates a new version of the specified customer managed permission. The new
// version is automatically set as the default version of the customer managed
// permission. New resource shares automatically use the default permission.
// Existing resource shares continue to use their original permission versions,
// but you can use ReplacePermissionAssociations to update them.
//
// If the specified customer managed permission already has the maximum of 5
// versions, then you must delete one of the existing versions before you can
// create a new one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation CreatePermissionVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - InvalidPolicyException
//     The operation failed because a policy you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedPolicyTemplateException
//     The operation failed because the policy template that you provided isn't
//     valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - PermissionVersionsLimitExceededException
//     The operation failed because it would exceed the limit for the number of
//     versions you can have for a permission. To view the limits for your Amazon
//     Web Services account, see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreatePermissionVersion
func (c *RAM) CreatePermissionVersion(input *CreatePermissionVersionInput) (*CreatePermissionVersionOutput, error) {
	req, out := c.CreatePermissionVersionRequest(input)
	return out, req.Send()
}

// CreatePermissionVersionWithContext is the same as CreatePermissionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermissionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) CreatePermissionVersionWithContext(ctx aws.Context, input *CreatePermissionVersionInput, opts ...request.Option) (*CreatePermissionVersionOutput, error) {
	req, out := c.CreatePermissionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceShare = "CreateResourceShare"

// CreateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceShare for more information on using the CreateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourceShareRequest method.
//	req, resp := client.CreateResourceShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare
func (c *RAM) CreateResourceShareRequest(input *CreateResourceShareInput) (req *request.Request, output *CreateResourceShareOutput) {
	op := &request.Operation{
		Name:       opCreateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/createresourceshare",
	}

	if input == nil {
		input = &CreateResourceShareInput{}
	}

	output = &CreateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourceShare API operation for AWS Resource Access Manager.
//
// Creates a resource share. You can provide a list of the Amazon Resource Names
// (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// for the resources that you want to share, a list of principals you want to
// share the resources with, and the permissions to grant those principals.
//
// Sharing a resource makes it available for use by principals outside of the
// Amazon Web Services account that created the resource. Sharing doesn't change
// any permissions or quotas that apply to the resource in the account that
// created it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation CreateResourceShare for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ResourceShareLimitExceededException
//     The operation failed because it would exceed the limit for resource shares
//     for your account. To view the limits for your Amazon Web Services account,
//     see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
//   - TagPolicyViolationException
//     The operation failed because the specified tag key is a reserved word and
//     can't be used.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare
func (c *RAM) CreateResourceShare(input *CreateResourceShareInput) (*CreateResourceShareOutput, error) {
	req, out := c.CreateResourceShareRequest(input)
	return out, req.Send()
}

// CreateResourceShareWithContext is the same as CreateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) CreateResourceShareWithContext(ctx aws.Context, input *CreateResourceShareInput, opts ...request.Option) (*CreateResourceShareOutput, error) {
	req, out := c.CreateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermission = "DeletePermission"

// DeletePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermission for more information on using the DeletePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePermissionRequest method.
//	req, resp := client.DeletePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermission
func (c *RAM) DeletePermissionRequest(input *DeletePermissionInput) (req *request.Request, output *DeletePermissionOutput) {
	op := &request.Operation{
		Name:       opDeletePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deletepermission",
	}

	if input == nil {
		input = &DeletePermissionInput{}
	}

	output = &DeletePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePermission API operation for AWS Resource Access Manager.
//
// Deletes the specified customer managed permission in the Amazon Web Services
// Region in which you call this operation. You can delete a customer managed
// permission only if it isn't attached to any resource share. The operation
// deletes all versions associated with the customer managed permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DeletePermission for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermission
func (c *RAM) DeletePermission(input *DeletePermissionInput) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	return out, req.Send()
}

// DeletePermissionWithContext is the same as DeletePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DeletePermissionWithContext(ctx aws.Context, input *DeletePermissionInput, opts ...request.Option) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionVersion = "DeletePermissionVersion"

// DeletePermissionVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionVersion for more information on using the DeletePermissionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePermissionVersionRequest method.
//	req, resp := client.DeletePermissionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermissionVersion
func (c *RAM) DeletePermissionVersionRequest(input *DeletePermissionVersionInput) (req *request.Request, output *DeletePermissionVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deletepermissionversion",
	}

	if input == nil {
		input = &DeletePermissionVersionInput{}
	}

	output = &DeletePermissionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePermissionVersion API operation for AWS Resource Access Manager.
//
// Deletes one version of a customer managed permission. The version you specify
// must not be attached to any resource share and must not be the default version
// for the permission.
//
// If a customer managed permission has the maximum of 5 versions, then you
// must delete at least one version before you can create another.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DeletePermissionVersion for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeletePermissionVersion
func (c *RAM) DeletePermissionVersion(input *DeletePermissionVersionInput) (*DeletePermissionVersionOutput, error) {
	req, out := c.DeletePermissionVersionRequest(input)
	return out, req.Send()
}

// DeletePermissionVersionWithContext is the same as DeletePermissionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DeletePermissionVersionWithContext(ctx aws.Context, input *DeletePermissionVersionInput, opts ...request.Option) (*DeletePermissionVersionOutput, error) {
	req, out := c.DeletePermissionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceShare = "DeleteResourceShare"

// DeleteResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceShare for more information on using the DeleteResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourceShareRequest method.
//	req, resp := client.DeleteResourceShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare
func (c *RAM) DeleteResourceShareRequest(input *DeleteResourceShareInput) (req *request.Request, output *DeleteResourceShareOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deleteresourceshare",
	}

	if input == nil {
		input = &DeleteResourceShareInput{}
	}

	output = &DeleteResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourceShare API operation for AWS Resource Access Manager.
//
// Deletes the specified resource share.
//
// This doesn't delete any of the resources that were associated with the resource
// share; it only stops the sharing of those resources through this resource
// share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DeleteResourceShare for usage and error information.
//
// Returned Error Types:
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare
func (c *RAM) DeleteResourceShare(input *DeleteResourceShareInput) (*DeleteResourceShareOutput, error) {
	req, out := c.DeleteResourceShareRequest(input)
	return out, req.Send()
}

// DeleteResourceShareWithContext is the same as DeleteResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DeleteResourceShareWithContext(ctx aws.Context, input *DeleteResourceShareInput, opts ...request.Option) (*DeleteResourceShareOutput, error) {
	req, out := c.DeleteResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResourceShare = "DisassociateResourceShare"

// DisassociateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResourceShare for more information on using the DisassociateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResourceShareRequest method.
//	req, resp := client.DisassociateResourceShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare
func (c *RAM) DisassociateResourceShareRequest(input *DisassociateResourceShareInput) (req *request.Request, output *DisassociateResourceShareOutput) {
	op := &request.Operation{
		Name:       opDisassociateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateresourceshare",
	}

	if input == nil {
		input = &DisassociateResourceShareInput{}
	}

	output = &DisassociateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResourceShare API operation for AWS Resource Access Manager.
//
// Removes the specified principals or resources from participating in the specified
// resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DisassociateResourceShare for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - ResourceShareLimitExceededException
//     The operation failed because it would exceed the limit for resource shares
//     for your account. To view the limits for your Amazon Web Services account,
//     see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare
func (c *RAM) DisassociateResourceShare(input *DisassociateResourceShareInput) (*DisassociateResourceShareOutput, error) {
	req, out := c.DisassociateResourceShareRequest(input)
	return out, req.Send()
}

// DisassociateResourceShareWithContext is the same as DisassociateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DisassociateResourceShareWithContext(ctx aws.Context, input *DisassociateResourceShareInput, opts ...request.Option) (*DisassociateResourceShareOutput, error) {
	req, out := c.DisassociateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResourceSharePermission = "DisassociateResourceSharePermission"

// DisassociateResourceSharePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResourceSharePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResourceSharePermission for more information on using the DisassociateResourceSharePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResourceSharePermissionRequest method.
//	req, resp := client.DisassociateResourceSharePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission
func (c *RAM) DisassociateResourceSharePermissionRequest(input *DisassociateResourceSharePermissionInput) (req *request.Request, output *DisassociateResourceSharePermissionOutput) {
	op := &request.Operation{
		Name:       opDisassociateResourceSharePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateresourcesharepermission",
	}

	if input == nil {
		input = &DisassociateResourceSharePermissionInput{}
	}

	output = &DisassociateResourceSharePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResourceSharePermission API operation for AWS Resource Access Manager.
//
// Removes a managed permission from a resource share. Permission changes take
// effect immediately. You can remove a managed permission from a resource share
// only if there are currently no resources of the relevant resource type currently
// attached to the resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation DisassociateResourceSharePermission for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceSharePermission
func (c *RAM) DisassociateResourceSharePermission(input *DisassociateResourceSharePermissionInput) (*DisassociateResourceSharePermissionOutput, error) {
	req, out := c.DisassociateResourceSharePermissionRequest(input)
	return out, req.Send()
}

// DisassociateResourceSharePermissionWithContext is the same as DisassociateResourceSharePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResourceSharePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) DisassociateResourceSharePermissionWithContext(ctx aws.Context, input *DisassociateResourceSharePermissionInput, opts ...request.Option) (*DisassociateResourceSharePermissionOutput, error) {
	req, out := c.DisassociateResourceSharePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSharingWithAwsOrganization = "EnableSharingWithAwsOrganization"

// EnableSharingWithAwsOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the EnableSharingWithAwsOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSharingWithAwsOrganization for more information on using the EnableSharingWithAwsOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableSharingWithAwsOrganizationRequest method.
//	req, resp := client.EnableSharingWithAwsOrganizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization
func (c *RAM) EnableSharingWithAwsOrganizationRequest(input *EnableSharingWithAwsOrganizationInput) (req *request.Request, output *EnableSharingWithAwsOrganizationOutput) {
	op := &request.Operation{
		Name:       opEnableSharingWithAwsOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/enablesharingwithawsorganization",
	}

	if input == nil {
		input = &EnableSharingWithAwsOrganizationInput{}
	}

	output = &EnableSharingWithAwsOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableSharingWithAwsOrganization API operation for AWS Resource Access Manager.
//
// Enables resource sharing within your organization in Organizations. This
// operation creates a service-linked role called AWSServiceRoleForResourceAccessManager
// that has the IAM managed policy named AWSResourceAccessManagerServiceRolePolicy
// attached. This role permits RAM to retrieve information about the organization
// and its structure. This lets you share resources with all of the accounts
// in the calling account's organization by specifying the organization ID,
// or all of the accounts in an organizational unit (OU) by specifying the OU
// ID. Until you enable sharing within the organization, you can specify only
// individual Amazon Web Services accounts, or for supported resource types,
// IAM roles and users.
//
// You must call this operation from an IAM role or user in the organization's
// management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation EnableSharingWithAwsOrganization for usage and error information.
//
// Returned Error Types:
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization
func (c *RAM) EnableSharingWithAwsOrganization(input *EnableSharingWithAwsOrganizationInput) (*EnableSharingWithAwsOrganizationOutput, error) {
	req, out := c.EnableSharingWithAwsOrganizationRequest(input)
	return out, req.Send()
}

// EnableSharingWithAwsOrganizationWithContext is the same as EnableSharingWithAwsOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSharingWithAwsOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) EnableSharingWithAwsOrganizationWithContext(ctx aws.Context, input *EnableSharingWithAwsOrganizationInput, opts ...request.Option) (*EnableSharingWithAwsOrganizationOutput, error) {
	req, out := c.EnableSharingWithAwsOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermission = "GetPermission"

// GetPermissionRequest generates a "aws/request.Request" representing the
// client's request for the GetPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermission for more information on using the GetPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPermissionRequest method.
//	req, resp := client.GetPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission
func (c *RAM) GetPermissionRequest(input *GetPermissionInput) (req *request.Request, output *GetPermissionOutput) {
	op := &request.Operation{
		Name:       opGetPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/getpermission",
	}

	if input == nil {
		input = &GetPermissionInput{}
	}

	output = &GetPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermission API operation for AWS Resource Access Manager.
//
// Retrieves the contents of a managed permission in JSON format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetPermission for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetPermission
func (c *RAM) GetPermission(input *GetPermissionInput) (*GetPermissionOutput, error) {
	req, out := c.GetPermissionRequest(input)
	return out, req.Send()
}

// GetPermissionWithContext is the same as GetPermission with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetPermissionWithContext(ctx aws.Context, input *GetPermissionInput, opts ...request.Option) (*GetPermissionOutput, error) {
	req, out := c.GetPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicies = "GetResourcePolicies"

// GetResourcePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicies for more information on using the GetResourcePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePoliciesRequest method.
//	req, resp := client.GetResourcePoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies
func (c *RAM) GetResourcePoliciesRequest(input *GetResourcePoliciesInput) (req *request.Request, output *GetResourcePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourcepolicies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcePoliciesInput{}
	}

	output = &GetResourcePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicies API operation for AWS Resource Access Manager.
//
// Retrieves the resource policies for the specified resources that you own
// and have shared.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourcePolicies for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ResourceArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     was not found.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies
func (c *RAM) GetResourcePolicies(input *GetResourcePoliciesInput) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	return out, req.Send()
}

// GetResourcePoliciesWithContext is the same as GetResourcePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourcePoliciesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, opts ...request.Option) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcePoliciesPages iterates over the pages of a GetResourcePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourcePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourcePolicies operation.
//	pageNum := 0
//	err := client.GetResourcePoliciesPages(params,
//	    func(page *ram.GetResourcePoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) GetResourcePoliciesPages(input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool) error {
	return c.GetResourcePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcePoliciesPagesWithContext same as GetResourcePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourcePoliciesPagesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShareAssociations = "GetResourceShareAssociations"

// GetResourceShareAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShareAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShareAssociations for more information on using the GetResourceShareAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceShareAssociationsRequest method.
//	req, resp := client.GetResourceShareAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations
func (c *RAM) GetResourceShareAssociationsRequest(input *GetResourceShareAssociationsInput) (req *request.Request, output *GetResourceShareAssociationsOutput) {
	op := &request.Operation{
		Name:       opGetResourceShareAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshareassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceShareAssociationsInput{}
	}

	output = &GetResourceShareAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShareAssociations API operation for AWS Resource Access Manager.
//
// Retrieves the lists of resources and principals that associated for resource
// shares that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShareAssociations for usage and error information.
//
// Returned Error Types:
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations
func (c *RAM) GetResourceShareAssociations(input *GetResourceShareAssociationsInput) (*GetResourceShareAssociationsOutput, error) {
	req, out := c.GetResourceShareAssociationsRequest(input)
	return out, req.Send()
}

// GetResourceShareAssociationsWithContext is the same as GetResourceShareAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShareAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareAssociationsWithContext(ctx aws.Context, input *GetResourceShareAssociationsInput, opts ...request.Option) (*GetResourceShareAssociationsOutput, error) {
	req, out := c.GetResourceShareAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceShareAssociationsPages iterates over the pages of a GetResourceShareAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShareAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourceShareAssociations operation.
//	pageNum := 0
//	err := client.GetResourceShareAssociationsPages(params,
//	    func(page *ram.GetResourceShareAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) GetResourceShareAssociationsPages(input *GetResourceShareAssociationsInput, fn func(*GetResourceShareAssociationsOutput, bool) bool) error {
	return c.GetResourceShareAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceShareAssociationsPagesWithContext same as GetResourceShareAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareAssociationsPagesWithContext(ctx aws.Context, input *GetResourceShareAssociationsInput, fn func(*GetResourceShareAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceShareAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceShareAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceShareAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShareInvitations = "GetResourceShareInvitations"

// GetResourceShareInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShareInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShareInvitations for more information on using the GetResourceShareInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceShareInvitationsRequest method.
//	req, resp := client.GetResourceShareInvitationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations
func (c *RAM) GetResourceShareInvitationsRequest(input *GetResourceShareInvitationsInput) (req *request.Request, output *GetResourceShareInvitationsOutput) {
	op := &request.Operation{
		Name:       opGetResourceShareInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshareinvitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceShareInvitationsInput{}
	}

	output = &GetResourceShareInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShareInvitations API operation for AWS Resource Access Manager.
//
// Retrieves details about invitations that you have received for resource shares.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShareInvitations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceShareInvitationArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     for an invitation was not found.
//
//   - InvalidMaxResultsException
//     The operation failed because the specified value for MaxResults isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations
func (c *RAM) GetResourceShareInvitations(input *GetResourceShareInvitationsInput) (*GetResourceShareInvitationsOutput, error) {
	req, out := c.GetResourceShareInvitationsRequest(input)
	return out, req.Send()
}

// GetResourceShareInvitationsWithContext is the same as GetResourceShareInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShareInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareInvitationsWithContext(ctx aws.Context, input *GetResourceShareInvitationsInput, opts ...request.Option) (*GetResourceShareInvitationsOutput, error) {
	req, out := c.GetResourceShareInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceShareInvitationsPages iterates over the pages of a GetResourceShareInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShareInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourceShareInvitations operation.
//	pageNum := 0
//	err := client.GetResourceShareInvitationsPages(params,
//	    func(page *ram.GetResourceShareInvitationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) GetResourceShareInvitationsPages(input *GetResourceShareInvitationsInput, fn func(*GetResourceShareInvitationsOutput, bool) bool) error {
	return c.GetResourceShareInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceShareInvitationsPagesWithContext same as GetResourceShareInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceShareInvitationsPagesWithContext(ctx aws.Context, input *GetResourceShareInvitationsInput, fn func(*GetResourceShareInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceShareInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceShareInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceShareInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourceShares = "GetResourceShares"

// GetResourceSharesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceShares operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceShares for more information on using the GetResourceShares
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourceSharesRequest method.
//	req, resp := client.GetResourceSharesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares
func (c *RAM) GetResourceSharesRequest(input *GetResourceSharesInput) (req *request.Request, output *GetResourceSharesOutput) {
	op := &request.Operation{
		Name:       opGetResourceShares,
		HTTPMethod: "POST",
		HTTPPath:   "/getresourceshares",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceSharesInput{}
	}

	output = &GetResourceSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceShares API operation for AWS Resource Access Manager.
//
// Retrieves details about the resource shares that you own or that are shared
// with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation GetResourceShares for usage and error information.
//
// Returned Error Types:
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares
func (c *RAM) GetResourceShares(input *GetResourceSharesInput) (*GetResourceSharesOutput, error) {
	req, out := c.GetResourceSharesRequest(input)
	return out, req.Send()
}

// GetResourceSharesWithContext is the same as GetResourceShares with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceSharesWithContext(ctx aws.Context, input *GetResourceSharesInput, opts ...request.Option) (*GetResourceSharesOutput, error) {
	req, out := c.GetResourceSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceSharesPages iterates over the pages of a GetResourceShares operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceShares method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourceShares operation.
//	pageNum := 0
//	err := client.GetResourceSharesPages(params,
//	    func(page *ram.GetResourceSharesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) GetResourceSharesPages(input *GetResourceSharesInput, fn func(*GetResourceSharesOutput, bool) bool) error {
	return c.GetResourceSharesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceSharesPagesWithContext same as GetResourceSharesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) GetResourceSharesPagesWithContext(ctx aws.Context, input *GetResourceSharesInput, fn func(*GetResourceSharesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceSharesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceSharesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceSharesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPendingInvitationResources = "ListPendingInvitationResources"

// ListPendingInvitationResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListPendingInvitationResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPendingInvitationResources for more information on using the ListPendingInvitationResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPendingInvitationResourcesRequest method.
//	req, resp := client.ListPendingInvitationResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources
func (c *RAM) ListPendingInvitationResourcesRequest(input *ListPendingInvitationResourcesInput) (req *request.Request, output *ListPendingInvitationResourcesOutput) {
	op := &request.Operation{
		Name:       opListPendingInvitationResources,
		HTTPMethod: "POST",
		HTTPPath:   "/listpendinginvitationresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPendingInvitationResourcesInput{}
	}

	output = &ListPendingInvitationResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPendingInvitationResources API operation for AWS Resource Access Manager.
//
// Lists the resources in a resource share that is shared with you but for which
// the invitation is still PENDING. That means that you haven't accepted or
// rejected the invitation and the invitation hasn't expired.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPendingInvitationResources for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - ResourceShareInvitationArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     for an invitation was not found.
//
//   - MissingRequiredParameterException
//     The operation failed because a required input parameter is missing.
//
//   - ResourceShareInvitationAlreadyRejectedException
//     The operation failed because the specified invitation was already rejected.
//
//   - ResourceShareInvitationExpiredException
//     The operation failed because the specified invitation is past its expiration
//     date and time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources
func (c *RAM) ListPendingInvitationResources(input *ListPendingInvitationResourcesInput) (*ListPendingInvitationResourcesOutput, error) {
	req, out := c.ListPendingInvitationResourcesRequest(input)
	return out, req.Send()
}

// ListPendingInvitationResourcesWithContext is the same as ListPendingInvitationResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListPendingInvitationResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPendingInvitationResourcesWithContext(ctx aws.Context, input *ListPendingInvitationResourcesInput, opts ...request.Option) (*ListPendingInvitationResourcesOutput, error) {
	req, out := c.ListPendingInvitationResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPendingInvitationResourcesPages iterates over the pages of a ListPendingInvitationResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPendingInvitationResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPendingInvitationResources operation.
//	pageNum := 0
//	err := client.ListPendingInvitationResourcesPages(params,
//	    func(page *ram.ListPendingInvitationResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListPendingInvitationResourcesPages(input *ListPendingInvitationResourcesInput, fn func(*ListPendingInvitationResourcesOutput, bool) bool) error {
	return c.ListPendingInvitationResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPendingInvitationResourcesPagesWithContext same as ListPendingInvitationResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPendingInvitationResourcesPagesWithContext(ctx aws.Context, input *ListPendingInvitationResourcesInput, fn func(*ListPendingInvitationResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPendingInvitationResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPendingInvitationResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPendingInvitationResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionAssociations = "ListPermissionAssociations"

// ListPermissionAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionAssociations for more information on using the ListPermissionAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionAssociationsRequest method.
//	req, resp := client.ListPermissionAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations
func (c *RAM) ListPermissionAssociationsRequest(input *ListPermissionAssociationsInput) (req *request.Request, output *ListPermissionAssociationsOutput) {
	op := &request.Operation{
		Name:       opListPermissionAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/listpermissionassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionAssociationsInput{}
	}

	output = &ListPermissionAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionAssociations API operation for AWS Resource Access Manager.
//
// Lists information about the managed permission and its associations to any
// resource shares that use this managed permission. This lets you see which
// resource shares use which versions of the specified managed permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPermissionAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionAssociations
func (c *RAM) ListPermissionAssociations(input *ListPermissionAssociationsInput) (*ListPermissionAssociationsOutput, error) {
	req, out := c.ListPermissionAssociationsRequest(input)
	return out, req.Send()
}

// ListPermissionAssociationsWithContext is the same as ListPermissionAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionAssociationsWithContext(ctx aws.Context, input *ListPermissionAssociationsInput, opts ...request.Option) (*ListPermissionAssociationsOutput, error) {
	req, out := c.ListPermissionAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionAssociationsPages iterates over the pages of a ListPermissionAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissionAssociations operation.
//	pageNum := 0
//	err := client.ListPermissionAssociationsPages(params,
//	    func(page *ram.ListPermissionAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListPermissionAssociationsPages(input *ListPermissionAssociationsInput, fn func(*ListPermissionAssociationsOutput, bool) bool) error {
	return c.ListPermissionAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionAssociationsPagesWithContext same as ListPermissionAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionAssociationsPagesWithContext(ctx aws.Context, input *ListPermissionAssociationsInput, fn func(*ListPermissionAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionVersions = "ListPermissionVersions"

// ListPermissionVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionVersions for more information on using the ListPermissionVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionVersionsRequest method.
//	req, resp := client.ListPermissionVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions
func (c *RAM) ListPermissionVersionsRequest(input *ListPermissionVersionsInput) (req *request.Request, output *ListPermissionVersionsOutput) {
	op := &request.Operation{
		Name:       opListPermissionVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/listpermissionversions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionVersionsInput{}
	}

	output = &ListPermissionVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionVersions API operation for AWS Resource Access Manager.
//
// Lists the available versions of the specified RAM permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPermissionVersions for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissionVersions
func (c *RAM) ListPermissionVersions(input *ListPermissionVersionsInput) (*ListPermissionVersionsOutput, error) {
	req, out := c.ListPermissionVersionsRequest(input)
	return out, req.Send()
}

// ListPermissionVersionsWithContext is the same as ListPermissionVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionVersionsWithContext(ctx aws.Context, input *ListPermissionVersionsInput, opts ...request.Option) (*ListPermissionVersionsOutput, error) {
	req, out := c.ListPermissionVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionVersionsPages iterates over the pages of a ListPermissionVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissionVersions operation.
//	pageNum := 0
//	err := client.ListPermissionVersionsPages(params,
//	    func(page *ram.ListPermissionVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListPermissionVersionsPages(input *ListPermissionVersionsInput, fn func(*ListPermissionVersionsOutput, bool) bool) error {
	return c.ListPermissionVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionVersionsPagesWithContext same as ListPermissionVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionVersionsPagesWithContext(ctx aws.Context, input *ListPermissionVersionsInput, fn func(*ListPermissionVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionsRequest method.
//	req, resp := client.ListPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions
func (c *RAM) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/listpermissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Resource Access Manager.
//
// Retrieves a list of available RAM permissions that you can use for the supported
// resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPermissions
func (c *RAM) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissions operation.
//	pageNum := 0
//	err := client.ListPermissionsPages(params,
//	    func(page *ram.ListPermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrincipals = "ListPrincipals"

// ListPrincipalsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrincipals operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrincipals for more information on using the ListPrincipals
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPrincipalsRequest method.
//	req, resp := client.ListPrincipalsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals
func (c *RAM) ListPrincipalsRequest(input *ListPrincipalsInput) (req *request.Request, output *ListPrincipalsOutput) {
	op := &request.Operation{
		Name:       opListPrincipals,
		HTTPMethod: "POST",
		HTTPPath:   "/listprincipals",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPrincipalsInput{}
	}

	output = &ListPrincipalsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrincipals API operation for AWS Resource Access Manager.
//
// Lists the principals that you are sharing resources with or that are sharing
// resources with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListPrincipals for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals
func (c *RAM) ListPrincipals(input *ListPrincipalsInput) (*ListPrincipalsOutput, error) {
	req, out := c.ListPrincipalsRequest(input)
	return out, req.Send()
}

// ListPrincipalsWithContext is the same as ListPrincipals with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrincipals for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPrincipalsWithContext(ctx aws.Context, input *ListPrincipalsInput, opts ...request.Option) (*ListPrincipalsOutput, error) {
	req, out := c.ListPrincipalsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPrincipalsPages iterates over the pages of a ListPrincipals operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrincipals method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrincipals operation.
//	pageNum := 0
//	err := client.ListPrincipalsPages(params,
//	    func(page *ram.ListPrincipalsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListPrincipalsPages(input *ListPrincipalsInput, fn func(*ListPrincipalsOutput, bool) bool) error {
	return c.ListPrincipalsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPrincipalsPagesWithContext same as ListPrincipalsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListPrincipalsPagesWithContext(ctx aws.Context, input *ListPrincipalsInput, fn func(*ListPrincipalsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPrincipalsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPrincipalsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPrincipalsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReplacePermissionAssociationsWork = "ListReplacePermissionAssociationsWork"

// ListReplacePermissionAssociationsWorkRequest generates a "aws/request.Request" representing the
// client's request for the ListReplacePermissionAssociationsWork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReplacePermissionAssociationsWork for more information on using the ListReplacePermissionAssociationsWork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReplacePermissionAssociationsWorkRequest method.
//	req, resp := client.ListReplacePermissionAssociationsWorkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork
func (c *RAM) ListReplacePermissionAssociationsWorkRequest(input *ListReplacePermissionAssociationsWorkInput) (req *request.Request, output *ListReplacePermissionAssociationsWorkOutput) {
	op := &request.Operation{
		Name:       opListReplacePermissionAssociationsWork,
		HTTPMethod: "POST",
		HTTPPath:   "/listreplacepermissionassociationswork",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReplacePermissionAssociationsWorkInput{}
	}

	output = &ListReplacePermissionAssociationsWorkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReplacePermissionAssociationsWork API operation for AWS Resource Access Manager.
//
// Retrieves the current status of the asynchronous tasks performed by RAM when
// you perform the ReplacePermissionAssociationsWork operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListReplacePermissionAssociationsWork for usage and error information.
//
// Returned Error Types:
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListReplacePermissionAssociationsWork
func (c *RAM) ListReplacePermissionAssociationsWork(input *ListReplacePermissionAssociationsWorkInput) (*ListReplacePermissionAssociationsWorkOutput, error) {
	req, out := c.ListReplacePermissionAssociationsWorkRequest(input)
	return out, req.Send()
}

// ListReplacePermissionAssociationsWorkWithContext is the same as ListReplacePermissionAssociationsWork with the addition of
// the ability to pass a context and additional request options.
//
// See ListReplacePermissionAssociationsWork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListReplacePermissionAssociationsWorkWithContext(ctx aws.Context, input *ListReplacePermissionAssociationsWorkInput, opts ...request.Option) (*ListReplacePermissionAssociationsWorkOutput, error) {
	req, out := c.ListReplacePermissionAssociationsWorkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReplacePermissionAssociationsWorkPages iterates over the pages of a ListReplacePermissionAssociationsWork operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReplacePermissionAssociationsWork method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReplacePermissionAssociationsWork operation.
//	pageNum := 0
//	err := client.ListReplacePermissionAssociationsWorkPages(params,
//	    func(page *ram.ListReplacePermissionAssociationsWorkOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListReplacePermissionAssociationsWorkPages(input *ListReplacePermissionAssociationsWorkInput, fn func(*ListReplacePermissionAssociationsWorkOutput, bool) bool) error {
	return c.ListReplacePermissionAssociationsWorkPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReplacePermissionAssociationsWorkPagesWithContext same as ListReplacePermissionAssociationsWorkPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListReplacePermissionAssociationsWorkPagesWithContext(ctx aws.Context, input *ListReplacePermissionAssociationsWorkInput, fn func(*ListReplacePermissionAssociationsWorkOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReplacePermissionAssociationsWorkInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReplacePermissionAssociationsWorkRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReplacePermissionAssociationsWorkOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceSharePermissions = "ListResourceSharePermissions"

// ListResourceSharePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceSharePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceSharePermissions for more information on using the ListResourceSharePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceSharePermissionsRequest method.
//	req, resp := client.ListResourceSharePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions
func (c *RAM) ListResourceSharePermissionsRequest(input *ListResourceSharePermissionsInput) (req *request.Request, output *ListResourceSharePermissionsOutput) {
	op := &request.Operation{
		Name:       opListResourceSharePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/listresourcesharepermissions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceSharePermissionsInput{}
	}

	output = &ListResourceSharePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceSharePermissions API operation for AWS Resource Access Manager.
//
// Lists the RAM permissions that are associated with a resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListResourceSharePermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceSharePermissions
func (c *RAM) ListResourceSharePermissions(input *ListResourceSharePermissionsInput) (*ListResourceSharePermissionsOutput, error) {
	req, out := c.ListResourceSharePermissionsRequest(input)
	return out, req.Send()
}

// ListResourceSharePermissionsWithContext is the same as ListResourceSharePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceSharePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourceSharePermissionsWithContext(ctx aws.Context, input *ListResourceSharePermissionsInput, opts ...request.Option) (*ListResourceSharePermissionsOutput, error) {
	req, out := c.ListResourceSharePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceSharePermissionsPages iterates over the pages of a ListResourceSharePermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceSharePermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceSharePermissions operation.
//	pageNum := 0
//	err := client.ListResourceSharePermissionsPages(params,
//	    func(page *ram.ListResourceSharePermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListResourceSharePermissionsPages(input *ListResourceSharePermissionsInput, fn func(*ListResourceSharePermissionsOutput, bool) bool) error {
	return c.ListResourceSharePermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceSharePermissionsPagesWithContext same as ListResourceSharePermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourceSharePermissionsPagesWithContext(ctx aws.Context, input *ListResourceSharePermissionsInput, fn func(*ListResourceSharePermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceSharePermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceSharePermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceSharePermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceTypes = "ListResourceTypes"

// ListResourceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceTypes for more information on using the ListResourceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceTypesRequest method.
//	req, resp := client.ListResourceTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes
func (c *RAM) ListResourceTypesRequest(input *ListResourceTypesInput) (req *request.Request, output *ListResourceTypesOutput) {
	op := &request.Operation{
		Name:       opListResourceTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/listresourcetypes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceTypesInput{}
	}

	output = &ListResourceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceTypes API operation for AWS Resource Access Manager.
//
// Lists the resource types that can be shared by RAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListResourceTypes for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResourceTypes
func (c *RAM) ListResourceTypes(input *ListResourceTypesInput) (*ListResourceTypesOutput, error) {
	req, out := c.ListResourceTypesRequest(input)
	return out, req.Send()
}

// ListResourceTypesWithContext is the same as ListResourceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourceTypesWithContext(ctx aws.Context, input *ListResourceTypesInput, opts ...request.Option) (*ListResourceTypesOutput, error) {
	req, out := c.ListResourceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceTypesPages iterates over the pages of a ListResourceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceTypes operation.
//	pageNum := 0
//	err := client.ListResourceTypesPages(params,
//	    func(page *ram.ListResourceTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListResourceTypesPages(input *ListResourceTypesInput, fn func(*ListResourceTypesOutput, bool) bool) error {
	return c.ListResourceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceTypesPagesWithContext same as ListResourceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourceTypesPagesWithContext(ctx aws.Context, input *ListResourceTypesInput, fn func(*ListResourceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourcesRequest method.
//	req, resp := client.ListResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources
func (c *RAM) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/listresources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS Resource Access Manager.
//
// Lists the resources that you added to a resource share or the resources that
// are shared with you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ListResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceTypeException
//     The operation failed because the specified resource type isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidNextTokenException
//     The operation failed because the specified value for NextToken isn't valid.
//     You must specify a value you received in the NextToken response of a previous
//     call to this operation.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources
func (c *RAM) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResources operation.
//	pageNum := 0
//	err := client.ListResourcesPages(params,
//	    func(page *ram.ListResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RAM) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPromotePermissionCreatedFromPolicy = "PromotePermissionCreatedFromPolicy"

// PromotePermissionCreatedFromPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PromotePermissionCreatedFromPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromotePermissionCreatedFromPolicy for more information on using the PromotePermissionCreatedFromPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PromotePermissionCreatedFromPolicyRequest method.
//	req, resp := client.PromotePermissionCreatedFromPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromotePermissionCreatedFromPolicy
func (c *RAM) PromotePermissionCreatedFromPolicyRequest(input *PromotePermissionCreatedFromPolicyInput) (req *request.Request, output *PromotePermissionCreatedFromPolicyOutput) {
	op := &request.Operation{
		Name:       opPromotePermissionCreatedFromPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/promotepermissioncreatedfrompolicy",
	}

	if input == nil {
		input = &PromotePermissionCreatedFromPolicyInput{}
	}

	output = &PromotePermissionCreatedFromPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromotePermissionCreatedFromPolicy API operation for AWS Resource Access Manager.
//
// When you attach a resource-based policy to a resource, RAM automatically
// creates a resource share of featureSet=CREATED_FROM_POLICY with a managed
// permission that has the same IAM permissions as the original resource-based
// policy. However, this type of managed permission is visible to only the resource
// share owner, and the associated resource share can't be modified by using
// RAM.
//
// This operation creates a separate, fully manageable customer managed permission
// that has the same IAM permissions as the original resource-based policy.
// You can associate this customer managed permission to any resource shares.
//
// Before you use PromoteResourceShareCreatedFromPolicy, you should first run
// this operation to ensure that you have an appropriate customer managed permission
// that can be associated with the promoted resource share.
//
//   - The original CREATED_FROM_POLICY policy isn't deleted, and resource
//     shares using that original policy aren't automatically updated.
//
//   - You can't modify a CREATED_FROM_POLICY resource share so you can't associate
//     the new customer managed permission by using ReplacePermsissionAssociations.
//     However, if you use PromoteResourceShareCreatedFromPolicy, that operation
//     automatically associates the fully manageable customer managed permission
//     to the newly promoted STANDARD resource share.
//
//   - After you promote a resource share, if the original CREATED_FROM_POLICY
//     managed permission has no other associations to A resource share, then
//     RAM automatically deletes it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation PromotePermissionCreatedFromPolicy for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MissingRequiredParameterException
//     The operation failed because a required input parameter is missing.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromotePermissionCreatedFromPolicy
func (c *RAM) PromotePermissionCreatedFromPolicy(input *PromotePermissionCreatedFromPolicyInput) (*PromotePermissionCreatedFromPolicyOutput, error) {
	req, out := c.PromotePermissionCreatedFromPolicyRequest(input)
	return out, req.Send()
}

// PromotePermissionCreatedFromPolicyWithContext is the same as PromotePermissionCreatedFromPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PromotePermissionCreatedFromPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) PromotePermissionCreatedFromPolicyWithContext(ctx aws.Context, input *PromotePermissionCreatedFromPolicyInput, opts ...request.Option) (*PromotePermissionCreatedFromPolicyOutput, error) {
	req, out := c.PromotePermissionCreatedFromPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteResourceShareCreatedFromPolicy = "PromoteResourceShareCreatedFromPolicy"

// PromoteResourceShareCreatedFromPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PromoteResourceShareCreatedFromPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteResourceShareCreatedFromPolicy for more information on using the PromoteResourceShareCreatedFromPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PromoteResourceShareCreatedFromPolicyRequest method.
//	req, resp := client.PromoteResourceShareCreatedFromPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy
func (c *RAM) PromoteResourceShareCreatedFromPolicyRequest(input *PromoteResourceShareCreatedFromPolicyInput) (req *request.Request, output *PromoteResourceShareCreatedFromPolicyOutput) {
	op := &request.Operation{
		Name:       opPromoteResourceShareCreatedFromPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/promoteresourcesharecreatedfrompolicy",
	}

	if input == nil {
		input = &PromoteResourceShareCreatedFromPolicyInput{}
	}

	output = &PromoteResourceShareCreatedFromPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteResourceShareCreatedFromPolicy API operation for AWS Resource Access Manager.
//
// When you attach a resource-based policy to a resource, RAM automatically
// creates a resource share of featureSet=CREATED_FROM_POLICY with a managed
// permission that has the same IAM permissions as the original resource-based
// policy. However, this type of managed permission is visible to only the resource
// share owner, and the associated resource share can't be modified by using
// RAM.
//
// This operation promotes the resource share to a STANDARD resource share that
// is fully manageable in RAM. When you promote a resource share, you can then
// manage the resource share in RAM and it becomes visible to all of the principals
// you shared it with.
//
// Before you perform this operation, you should first run PromotePermissionCreatedFromPolicyto
// ensure that you have an appropriate customer managed permission that can
// be associated with this resource share after its is promoted. If this operation
// can't find a managed permission that exactly matches the existing CREATED_FROM_POLICY
// permission, then this operation fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation PromoteResourceShareCreatedFromPolicy for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - ResourceShareLimitExceededException
//     The operation failed because it would exceed the limit for resource shares
//     for your account. To view the limits for your Amazon Web Services account,
//     see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MissingRequiredParameterException
//     The operation failed because a required input parameter is missing.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidStateTransitionException
//     The operation failed because the requested operation isn't valid for the
//     resource share in its current state.
//
//   - UnmatchedPolicyPermissionException
//     There isn't an existing managed permission defined in RAM that has the same
//     IAM permissions as the resource-based policy attached to the resource. You
//     should first run PromotePermissionCreatedFromPolicy to create that managed
//     permission.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/PromoteResourceShareCreatedFromPolicy
func (c *RAM) PromoteResourceShareCreatedFromPolicy(input *PromoteResourceShareCreatedFromPolicyInput) (*PromoteResourceShareCreatedFromPolicyOutput, error) {
	req, out := c.PromoteResourceShareCreatedFromPolicyRequest(input)
	return out, req.Send()
}

// PromoteResourceShareCreatedFromPolicyWithContext is the same as PromoteResourceShareCreatedFromPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteResourceShareCreatedFromPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) PromoteResourceShareCreatedFromPolicyWithContext(ctx aws.Context, input *PromoteResourceShareCreatedFromPolicyInput, opts ...request.Option) (*PromoteResourceShareCreatedFromPolicyOutput, error) {
	req, out := c.PromoteResourceShareCreatedFromPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectResourceShareInvitation = "RejectResourceShareInvitation"

// RejectResourceShareInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectResourceShareInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectResourceShareInvitation for more information on using the RejectResourceShareInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectResourceShareInvitationRequest method.
//	req, resp := client.RejectResourceShareInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation
func (c *RAM) RejectResourceShareInvitationRequest(input *RejectResourceShareInvitationInput) (req *request.Request, output *RejectResourceShareInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectResourceShareInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/rejectresourceshareinvitation",
	}

	if input == nil {
		input = &RejectResourceShareInvitationInput{}
	}

	output = &RejectResourceShareInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectResourceShareInvitation API operation for AWS Resource Access Manager.
//
// Rejects an invitation to a resource share from another Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation RejectResourceShareInvitation for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ResourceShareInvitationArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     for an invitation was not found.
//
//   - ResourceShareInvitationAlreadyAcceptedException
//     The operation failed because the specified invitation was already accepted.
//
//   - ResourceShareInvitationAlreadyRejectedException
//     The operation failed because the specified invitation was already rejected.
//
//   - ResourceShareInvitationExpiredException
//     The operation failed because the specified invitation is past its expiration
//     date and time.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation
func (c *RAM) RejectResourceShareInvitation(input *RejectResourceShareInvitationInput) (*RejectResourceShareInvitationOutput, error) {
	req, out := c.RejectResourceShareInvitationRequest(input)
	return out, req.Send()
}

// RejectResourceShareInvitationWithContext is the same as RejectResourceShareInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectResourceShareInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) RejectResourceShareInvitationWithContext(ctx aws.Context, input *RejectResourceShareInvitationInput, opts ...request.Option) (*RejectResourceShareInvitationOutput, error) {
	req, out := c.RejectResourceShareInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplacePermissionAssociations = "ReplacePermissionAssociations"

// ReplacePermissionAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ReplacePermissionAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplacePermissionAssociations for more information on using the ReplacePermissionAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReplacePermissionAssociationsRequest method.
//	req, resp := client.ReplacePermissionAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ReplacePermissionAssociations
func (c *RAM) ReplacePermissionAssociationsRequest(input *ReplacePermissionAssociationsInput) (req *request.Request, output *ReplacePermissionAssociationsOutput) {
	op := &request.Operation{
		Name:       opReplacePermissionAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/replacepermissionassociations",
	}

	if input == nil {
		input = &ReplacePermissionAssociationsInput{}
	}

	output = &ReplacePermissionAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplacePermissionAssociations API operation for AWS Resource Access Manager.
//
// Updates all resource shares that use a managed permission to a different
// managed permission. This operation always applies the default version of
// the target managed permission. You can optionally specify that the update
// applies to only resource shares that currently use a specified version. This
// enables you to update to the latest version, without changing the which managed
// permission is used.
//
// You can use this operation to update all of your resource shares to use the
// current default version of the permission by specifying the same value for
// the fromPermissionArn and toPermissionArn parameters.
//
// You can use the optional fromPermissionVersion parameter to update only those
// resources that use a specified version of the managed permission to the new
// managed permission.
//
// To successfully perform this operation, you must have permission to update
// the resource-based policy on all affected resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation ReplacePermissionAssociations for usage and error information.
//
// Returned Error Types:
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ReplacePermissionAssociations
func (c *RAM) ReplacePermissionAssociations(input *ReplacePermissionAssociationsInput) (*ReplacePermissionAssociationsOutput, error) {
	req, out := c.ReplacePermissionAssociationsRequest(input)
	return out, req.Send()
}

// ReplacePermissionAssociationsWithContext is the same as ReplacePermissionAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ReplacePermissionAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) ReplacePermissionAssociationsWithContext(ctx aws.Context, input *ReplacePermissionAssociationsInput, opts ...request.Option) (*ReplacePermissionAssociationsOutput, error) {
	req, out := c.ReplacePermissionAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDefaultPermissionVersion = "SetDefaultPermissionVersion"

// SetDefaultPermissionVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultPermissionVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDefaultPermissionVersion for more information on using the SetDefaultPermissionVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SetDefaultPermissionVersionRequest method.
//	req, resp := client.SetDefaultPermissionVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/SetDefaultPermissionVersion
func (c *RAM) SetDefaultPermissionVersionRequest(input *SetDefaultPermissionVersionInput) (req *request.Request, output *SetDefaultPermissionVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPermissionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/setdefaultpermissionversion",
	}

	if input == nil {
		input = &SetDefaultPermissionVersionInput{}
	}

	output = &SetDefaultPermissionVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetDefaultPermissionVersion API operation for AWS Resource Access Manager.
//
// Designates the specified version number as the default version for the specified
// customer managed permission. New resource shares automatically use this new
// default permission. Existing resource shares continue to use their original
// permission version, but you can use ReplacePermissionAssociations to update
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation SetDefaultPermissionVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/SetDefaultPermissionVersion
func (c *RAM) SetDefaultPermissionVersion(input *SetDefaultPermissionVersionInput) (*SetDefaultPermissionVersionOutput, error) {
	req, out := c.SetDefaultPermissionVersionRequest(input)
	return out, req.Send()
}

// SetDefaultPermissionVersionWithContext is the same as SetDefaultPermissionVersion with the addition of
// the ability to pass a context and additional request options.
//
// See SetDefaultPermissionVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) SetDefaultPermissionVersionWithContext(ctx aws.Context, input *SetDefaultPermissionVersionInput, opts ...request.Option) (*SetDefaultPermissionVersionOutput, error) {
	req, out := c.SetDefaultPermissionVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource
func (c *RAM) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tagresource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Resource Access Manager.
//
// Adds the specified tag keys and values to a resource share or managed permission.
// If you choose a resource share, the tags are attached to only the resource
// share, not to the resources that are in the resource share.
//
// The tags on a managed permission are the same for all versions of the managed
// permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - TagLimitExceededException
//     The operation failed because it would exceed the limit for tags for your
//     Amazon Web Services account.
//
//   - ResourceArnNotFoundException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     was not found.
//
//   - TagPolicyViolationException
//     The operation failed because the specified tag key is a reserved word and
//     can't be used.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource
func (c *RAM) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource
func (c *RAM) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untagresource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Resource Access Manager.
//
// Removes the specified tag key and value pairs from the specified resource
// share or managed permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource
func (c *RAM) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceShare = "UpdateResourceShare"

// UpdateResourceShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceShare operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceShare for more information on using the UpdateResourceShare
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourceShareRequest method.
//	req, resp := client.UpdateResourceShareRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare
func (c *RAM) UpdateResourceShareRequest(input *UpdateResourceShareInput) (req *request.Request, output *UpdateResourceShareOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceShare,
		HTTPMethod: "POST",
		HTTPPath:   "/updateresourceshare",
	}

	if input == nil {
		input = &UpdateResourceShareInput{}
	}

	output = &UpdateResourceShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceShare API operation for AWS Resource Access Manager.
//
// Modifies some of the properties of the specified resource share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Access Manager's
// API operation UpdateResourceShare for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatchException
//     The operation failed because the client token input parameter matched one
//     that was used with a previous call to the operation, but at least one of
//     the other input parameters is different from the previous call.
//
//   - MissingRequiredParameterException
//     The operation failed because a required input parameter is missing.
//
//   - UnknownResourceException
//     The operation failed because a specified resource couldn't be found.
//
//   - MalformedArnException
//     The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
//     has a format that isn't valid.
//
//   - InvalidClientTokenException
//     The operation failed because the specified client token isn't valid.
//
//   - InvalidParameterException
//     The operation failed because a parameter you specified isn't valid.
//
//   - OperationNotPermittedException
//     The operation failed because the requested operation isn't permitted.
//
//   - ServerInternalException
//     The operation failed because the service could not respond to the request
//     due to an internal problem. Try again later.
//
//   - ServiceUnavailableException
//     The operation failed because the service isn't available. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare
func (c *RAM) UpdateResourceShare(input *UpdateResourceShareInput) (*UpdateResourceShareOutput, error) {
	req, out := c.UpdateResourceShareRequest(input)
	return out, req.Send()
}

// UpdateResourceShareWithContext is the same as UpdateResourceShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RAM) UpdateResourceShareWithContext(ctx aws.Context, input *UpdateResourceShareInput, opts ...request.Option) (*UpdateResourceShareOutput, error) {
	req, out := c.UpdateResourceShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptResourceShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the invitation that you want to accept.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptResourceShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptResourceShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptResourceShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptResourceShareInvitationInput"}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptResourceShareInvitationInput) SetClientToken(v string) *AcceptResourceShareInvitationInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *AcceptResourceShareInvitationInput) SetResourceShareInvitationArn(v string) *AcceptResourceShareInvitationInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type AcceptResourceShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// An object that contains information about the specified invitation.
	ResourceShareInvitation *ResourceShareInvitation `locationName:"resourceShareInvitation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptResourceShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptResourceShareInvitationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptResourceShareInvitationOutput) SetClientToken(v string) *AcceptResourceShareInvitationOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitation sets the ResourceShareInvitation field's value.
func (s *AcceptResourceShareInvitationOutput) SetResourceShareInvitation(v *ResourceShareInvitation) *AcceptResourceShareInvitationOutput {
	s.ResourceShareInvitation = v
	return s
}

type AssociateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies a list of principals to whom you want to the resource share. This
	// can be null if you want to add only resources.
	//
	// What the principals can do with the resources in the share is determined
	// by the RAM permissions that you associate with the resource share. See AssociateResourceSharePermission.
	//
	// You can include the following values:
	//
	//    * An Amazon Web Services account ID, for example: 123456789012
	//
	//    * An Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of an organization in Organizations, for example: organizations::123456789012:organization/o-exampleorgid
	//
	//    * An ARN of an organizational unit (OU) in Organizations, for example:
	//    organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123
	//
	//    * An ARN of an IAM role, for example: iam::123456789012:role/rolename
	//
	//    * An ARN of an IAM user, for example: iam::123456789012user/username
	//
	// Not all resource types can be shared with IAM roles and users. For more information,
	// see Sharing with IAM roles and users (https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types)
	// in the Resource Access Manager User Guide.
	Principals []*string `locationName:"principals" type:"list"`

	// Specifies a list of Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resources that you want to share. This can be null if you want to
	// add only principals.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to add principals or resources to.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceShareInput) SetClientToken(v string) *AssociateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *AssociateResourceShareInput) SetPrincipals(v []*string) *AssociateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *AssociateResourceShareInput) SetResourceArns(v []*string) *AssociateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *AssociateResourceShareInput) SetResourceShareArn(v string) *AssociateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type AssociateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// An array of objects that contain information about the associations.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceShareOutput) SetClientToken(v string) *AssociateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *AssociateResourceShareOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *AssociateResourceShareOutput {
	s.ResourceShareAssociations = v
	return s
}

type AssociateResourceSharePermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the RAM permission to associate with the resource share. To find the ARN
	// for a permission, use either the ListPermissions operation or go to the Permissions
	// library (https://console.aws.amazon.com/ram/home#Permissions:) page in the
	// RAM console and then choose the name of the permission. The ARN is displayed
	// on the detail page.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// Specifies the version of the RAM permission to associate with the resource
	// share. You can specify only the version that is currently set as the default
	// version for the permission. If you also set the replace pararameter to true,
	// then this operation updates an outdated version of the permission to the
	// current default version.
	//
	// You don't need to specify this parameter because the default behavior is
	// to use the version that is currently set as the default version for the permission.
	// This parameter is supported for backwards compatibility.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`

	// Specifies whether the specified permission should replace the existing permission
	// associated with the resource share. Use true to replace the current permissions.
	// Use false to add the permission to a resource share that currently doesn't
	// have a permission. The default value is false.
	//
	// A resource share can have only one permission per resource type. If a resource
	// share already has a permission for the specified resource type and you don't
	// set replace to true then the operation returns an error. This helps prevent
	// accidental overwriting of a permission.
	Replace *bool `locationName:"replace" type:"boolean"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share to which you want to add or replace permissions.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceSharePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceSharePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceSharePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceSharePermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceSharePermissionInput) SetClientToken(v string) *AssociateResourceSharePermissionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *AssociateResourceSharePermissionInput) SetPermissionArn(v string) *AssociateResourceSharePermissionInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *AssociateResourceSharePermissionInput) SetPermissionVersion(v int64) *AssociateResourceSharePermissionInput {
	s.PermissionVersion = &v
	return s
}

// SetReplace sets the Replace field's value.
func (s *AssociateResourceSharePermissionInput) SetReplace(v bool) *AssociateResourceSharePermissionInput {
	s.Replace = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *AssociateResourceSharePermissionInput) SetResourceShareArn(v string) *AssociateResourceSharePermissionInput {
	s.ResourceShareArn = &v
	return s
}

type AssociateResourceSharePermissionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A return value of true indicates that the request succeeded. A value of false
	// indicates that the request failed.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceSharePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceSharePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *AssociateResourceSharePermissionOutput) SetClientToken(v string) *AssociateResourceSharePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *AssociateResourceSharePermissionOutput) SetReturnValue(v bool) *AssociateResourceSharePermissionOutput {
	s.ReturnValue = &v
	return s
}

// An object that describes a managed permission associated with a resource
// share.
type AssociatedPermission struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the associated managed permission.
	Arn *string `locationName:"arn" type:"string"`

	// Indicates whether the associated resource share is using the default version
	// of the permission.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// Indicates what features are available for this resource share. This parameter
	// can have one of the following values:
	//
	//    * STANDARD – A resource share that supports all functionality. These
	//    resource shares are visible to all principals you share the resource share
	//    with. You can modify these resource shares in RAM using the console or
	//    APIs. This resource share might have been created by RAM, or it might
	//    have been CREATED_FROM_POLICY and then promoted.
	//
	//    * CREATED_FROM_POLICY – The customer manually shared a resource by attaching
	//    a resource-based policy. That policy did not match any existing managed
	//    permissions, so RAM created this customer managed permission automatically
	//    on the customer's behalf based on the attached policy document. This type
	//    of resource share is visible only to the Amazon Web Services account that
	//    created it. You can't modify it in RAM unless you promote it. For more
	//    information, see PromoteResourceShareCreatedFromPolicy.
	//
	//    * PROMOTING_TO_STANDARD – This resource share was originally CREATED_FROM_POLICY,
	//    but the customer ran the PromoteResourceShareCreatedFromPolicy and that
	//    operation is still in progress. This value changes to STANDARD when complete.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"PermissionFeatureSet"`

	// The date and time when the association between the permission and the resource
	// share was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The version of the permission currently associated with the resource share.
	PermissionVersion *string `locationName:"permissionVersion" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a resource share associated with this permission.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The resource type to which this permission applies.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The current status of the association between the permission and the resource
	// share. The following are the possible values:
	//
	//    * ATTACHABLE – This permission or version can be associated with resource
	//    shares.
	//
	//    * UNATTACHABLE – This permission or version can't currently be associated
	//    with resource shares.
	//
	//    * DELETING – This permission or version is in the process of being deleted.
	//
	//    * DELETED – This permission or version is deleted.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedPermission) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatedPermission) SetArn(v string) *AssociatedPermission {
	s.Arn = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *AssociatedPermission) SetDefaultVersion(v bool) *AssociatedPermission {
	s.DefaultVersion = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *AssociatedPermission) SetFeatureSet(v string) *AssociatedPermission {
	s.FeatureSet = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AssociatedPermission) SetLastUpdatedTime(v time.Time) *AssociatedPermission {
	s.LastUpdatedTime = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *AssociatedPermission) SetPermissionVersion(v string) *AssociatedPermission {
	s.PermissionVersion = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *AssociatedPermission) SetResourceShareArn(v string) *AssociatedPermission {
	s.ResourceShareArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociatedPermission) SetResourceType(v string) *AssociatedPermission {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociatedPermission) SetStatus(v string) *AssociatedPermission {
	s.Status = &v
	return s
}

type CreatePermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the name of the customer managed permission. The name must be unique
	// within the Amazon Web Services Region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A string in JSON format string that contains the following elements of a
	// resource-based policy:
	//
	//    * Effect: must be set to ALLOW.
	//
	//    * Action: specifies the actions that are allowed by this customer managed
	//    permission. The list must contain only actions that are supported by the
	//    specified resource type. For a list of all actions supported by each resource
	//    type, see Actions, resources, and condition keys for Amazon Web Services
	//    services (https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
	//    in the Identity and Access Management User Guide.
	//
	//    * Condition: (optional) specifies conditional parameters that must evaluate
	//    to true when a user attempts an action for that action to be allowed.
	//    For more information about the Condition element, see IAM policies: Condition
	//    element (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
	//    in the Identity and Access Management User Guide.
	//
	// This template can't include either the Resource or Principal elements. Those
	// are both filled in by RAM when it instantiates the resource-based policy
	// on each resource shared using this managed permission. The Resource comes
	// from the ARN of the specific resource that you are sharing. The Principal
	// comes from the list of identities added to the resource share.
	//
	// PolicyTemplate is a required field
	PolicyTemplate *string `locationName:"policyTemplate" type:"string" required:"true"`

	// Specifies the name of the resource type that this customer managed permission
	// applies to.
	//
	// The format is <service-code>:<resource-type> and is not case sensitive. For
	// example, to specify an Amazon EC2 Subnet, you can use the string ec2:subnet.
	// To see the list of valid values for this parameter, query the ListResourceTypes
	// operation.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Specifies a list of one or more tag key and value pairs to attach to the
	// permission.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PolicyTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplate"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePermissionInput) SetClientToken(v string) *CreatePermissionInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePermissionInput) SetName(v string) *CreatePermissionInput {
	s.Name = &v
	return s
}

// SetPolicyTemplate sets the PolicyTemplate field's value.
func (s *CreatePermissionInput) SetPolicyTemplate(v string) *CreatePermissionInput {
	s.PolicyTemplate = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreatePermissionInput) SetResourceType(v string) *CreatePermissionInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePermissionInput) SetTags(v []*Tag) *CreatePermissionInput {
	s.Tags = v
	return s
}

type CreatePermissionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A structure with information about this customer managed permission.
	Permission *ResourceSharePermissionSummary `locationName:"permission" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePermissionOutput) SetClientToken(v string) *CreatePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *CreatePermissionOutput) SetPermission(v *ResourceSharePermissionSummary) *CreatePermissionOutput {
	s.Permission = v
	return s
}

type CreatePermissionVersionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the customer managed permission you're creating a new version for.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// A string in JSON format string that contains the following elements of a
	// resource-based policy:
	//
	//    * Effect: must be set to ALLOW.
	//
	//    * Action: specifies the actions that are allowed by this customer managed
	//    permission. The list must contain only actions that are supported by the
	//    specified resource type. For a list of all actions supported by each resource
	//    type, see Actions, resources, and condition keys for Amazon Web Services
	//    services (https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
	//    in the Identity and Access Management User Guide.
	//
	//    * Condition: (optional) specifies conditional parameters that must evaluate
	//    to true when a user attempts an action for that action to be allowed.
	//    For more information about the Condition element, see IAM policies: Condition
	//    element (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
	//    in the Identity and Access Management User Guide.
	//
	// This template can't include either the Resource or Principal elements. Those
	// are both filled in by RAM when it instantiates the resource-based policy
	// on each resource shared using this managed permission. The Resource comes
	// from the ARN of the specific resource that you are sharing. The Principal
	// comes from the list of identities added to the resource share.
	//
	// PolicyTemplate is a required field
	PolicyTemplate *string `locationName:"policyTemplate" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionVersionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.PolicyTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyTemplate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePermissionVersionInput) SetClientToken(v string) *CreatePermissionVersionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *CreatePermissionVersionInput) SetPermissionArn(v string) *CreatePermissionVersionInput {
	s.PermissionArn = &v
	return s
}

// SetPolicyTemplate sets the PolicyTemplate field's value.
func (s *CreatePermissionVersionInput) SetPolicyTemplate(v string) *CreatePermissionVersionInput {
	s.PolicyTemplate = &v
	return s
}

type CreatePermissionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about a RAM managed permission.
	Permission *ResourceSharePermissionDetail `locationName:"permission" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionVersionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePermissionVersionOutput) SetClientToken(v string) *CreatePermissionVersionOutput {
	s.ClientToken = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *CreatePermissionVersionOutput) SetPermission(v *ResourceSharePermissionDetail) *CreatePermissionVersionOutput {
	s.Permission = v
	return s
}

type CreateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether principals outside your organization in Organizations can
	// be associated with a resource share. A value of true lets you share with
	// individual Amazon Web Services accounts that are not in your organization.
	// A value of false only has meaning if your account is a member of an Amazon
	// Web Services Organization. The default value is true.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the name of the resource share.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies the Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the RAM permission to associate with the resource share. If you do not
	// specify an ARN for the permission, RAM automatically attaches the default
	// version of the permission for each resource type. You can associate only
	// one permission with each resource type included in the resource share.
	PermissionArns []*string `locationName:"permissionArns" type:"list"`

	// Specifies a list of one or more principals to associate with the resource
	// share.
	//
	// You can include the following values:
	//
	//    * An Amazon Web Services account ID, for example: 123456789012
	//
	//    * An Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of an organization in Organizations, for example: organizations::123456789012:organization/o-exampleorgid
	//
	//    * An ARN of an organizational unit (OU) in Organizations, for example:
	//    organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123
	//
	//    * An ARN of an IAM role, for example: iam::123456789012:role/rolename
	//
	//    * An ARN of an IAM user, for example: iam::123456789012user/username
	//
	// Not all resource types can be shared with IAM roles and users. For more information,
	// see Sharing with IAM roles and users (https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types)
	// in the Resource Access Manager User Guide.
	Principals []*string `locationName:"principals" type:"list"`

	// Specifies a list of one or more ARNs of the resources to associate with the
	// resource share.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// Specifies one or more tags to attach to the resource share itself. It doesn't
	// attach the tags to the resources associated with the resource share.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceShareInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *CreateResourceShareInput) SetAllowExternalPrincipals(v bool) *CreateResourceShareInput {
	s.AllowExternalPrincipals = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResourceShareInput) SetClientToken(v string) *CreateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceShareInput) SetName(v string) *CreateResourceShareInput {
	s.Name = &v
	return s
}

// SetPermissionArns sets the PermissionArns field's value.
func (s *CreateResourceShareInput) SetPermissionArns(v []*string) *CreateResourceShareInput {
	s.PermissionArns = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *CreateResourceShareInput) SetPrincipals(v []*string) *CreateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *CreateResourceShareInput) SetResourceArns(v []*string) *CreateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResourceShareInput) SetTags(v []*Tag) *CreateResourceShareInput {
	s.Tags = v
	return s
}

type CreateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// An object with information about the new resource share.
	ResourceShare *ResourceShare `locationName:"resourceShare" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateResourceShareOutput) SetClientToken(v string) *CreateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShare sets the ResourceShare field's value.
func (s *CreateResourceShareOutput) SetResourceShare(v *ResourceShare) *CreateResourceShareOutput {
	s.ResourceShare = v
	return s
}

type DeletePermissionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the customer managed permission that you want to delete.
	//
	// PermissionArn is a required field
	PermissionArn *string `location:"querystring" locationName:"permissionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePermissionInput) SetClientToken(v string) *DeletePermissionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *DeletePermissionInput) SetPermissionArn(v string) *DeletePermissionInput {
	s.PermissionArn = &v
	return s
}

type DeletePermissionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// This operation is performed asynchronously, and this response parameter indicates
	// the current status.
	PermissionStatus *string `locationName:"permissionStatus" type:"string" enum:"PermissionStatus"`

	// A boolean that indicates whether the delete operations succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePermissionOutput) SetClientToken(v string) *DeletePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetPermissionStatus sets the PermissionStatus field's value.
func (s *DeletePermissionOutput) SetPermissionStatus(v string) *DeletePermissionOutput {
	s.PermissionStatus = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DeletePermissionOutput) SetReturnValue(v bool) *DeletePermissionOutput {
	s.ReturnValue = &v
	return s
}

type DeletePermissionVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the permission with the version you want to delete.
	//
	// PermissionArn is a required field
	PermissionArn *string `location:"querystring" locationName:"permissionArn" type:"string" required:"true"`

	// Specifies the version number to delete.
	//
	// You can't delete the default version for a customer managed permission.
	//
	// You can't delete a version if it's the only version of the permission. You
	// must either first create another version, or delete the permission completely.
	//
	// You can't delete a version if it is attached to any resource shares. If the
	// version is the default, you must first use SetDefaultPermissionVersion to
	// set a different version as the default for the customer managed permission,
	// and then use AssociateResourceSharePermission to update your resource shares
	// to use the new default version.
	//
	// PermissionVersion is a required field
	PermissionVersion *int64 `location:"querystring" locationName:"permissionVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionVersionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.PermissionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePermissionVersionInput) SetClientToken(v string) *DeletePermissionVersionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *DeletePermissionVersionInput) SetPermissionArn(v string) *DeletePermissionVersionInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *DeletePermissionVersionInput) SetPermissionVersion(v int64) *DeletePermissionVersionInput {
	s.PermissionVersion = &v
	return s
}

type DeletePermissionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// This operation is performed asynchronously, and this response parameter indicates
	// the current status.
	PermissionStatus *string `locationName:"permissionStatus" type:"string" enum:"PermissionStatus"`

	// A boolean value that indicates whether the operation is successful.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionVersionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DeletePermissionVersionOutput) SetClientToken(v string) *DeletePermissionVersionOutput {
	s.ClientToken = &v
	return s
}

// SetPermissionStatus sets the PermissionStatus field's value.
func (s *DeletePermissionVersionOutput) SetPermissionStatus(v string) *DeletePermissionVersionOutput {
	s.PermissionStatus = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DeletePermissionVersionOutput) SetReturnValue(v bool) *DeletePermissionVersionOutput {
	s.ReturnValue = &v
	return s
}

type DeleteResourceShareInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share to delete.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `location:"querystring" locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResourceShareInput) SetClientToken(v string) *DeleteResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DeleteResourceShareInput) SetResourceShareArn(v string) *DeleteResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type DeleteResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A return value of true indicates that the request succeeded. A value of false
	// indicates that the request failed.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteResourceShareOutput) SetClientToken(v string) *DeleteResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DeleteResourceShareOutput) SetReturnValue(v bool) *DeleteResourceShareOutput {
	s.ReturnValue = &v
	return s
}

type DisassociateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies a list of one or more principals that no longer are to have access
	// to the resources in this resource share.
	//
	// You can include the following values:
	//
	//    * An Amazon Web Services account ID, for example: 123456789012
	//
	//    * An Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of an organization in Organizations, for example: organizations::123456789012:organization/o-exampleorgid
	//
	//    * An ARN of an organizational unit (OU) in Organizations, for example:
	//    organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123
	//
	//    * An ARN of an IAM role, for example: iam::123456789012:role/rolename
	//
	//    * An ARN of an IAM user, for example: iam::123456789012user/username
	//
	// Not all resource types can be shared with IAM roles and users. For more information,
	// see Sharing with IAM roles and users (https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types)
	// in the Resource Access Manager User Guide.
	Principals []*string `locationName:"principals" type:"list"`

	// Specifies a list of Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// for one or more resources that you want to remove from the resource share.
	// After the operation runs, these resources are no longer shared with principals
	// associated with the resource share.
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// Specifies Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to remove resources or principals from.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceShareInput) SetClientToken(v string) *DisassociateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *DisassociateResourceShareInput) SetPrincipals(v []*string) *DisassociateResourceShareInput {
	s.Principals = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *DisassociateResourceShareInput) SetResourceArns(v []*string) *DisassociateResourceShareInput {
	s.ResourceArns = v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DisassociateResourceShareInput) SetResourceShareArn(v string) *DisassociateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type DisassociateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// An array of objects with information about the updated associations for this
	// resource share.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceShareOutput) SetClientToken(v string) *DisassociateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *DisassociateResourceShareOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *DisassociateResourceShareOutput {
	s.ResourceShareAssociations = v
	return s
}

type DisassociateResourceSharePermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission to disassociate from the resource share. Changes
	// to permissions take effect immediately.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to remove the managed permission from.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceSharePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceSharePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceSharePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceSharePermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceSharePermissionInput) SetClientToken(v string) *DisassociateResourceSharePermissionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *DisassociateResourceSharePermissionInput) SetPermissionArn(v string) *DisassociateResourceSharePermissionInput {
	s.PermissionArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *DisassociateResourceSharePermissionInput) SetResourceShareArn(v string) *DisassociateResourceSharePermissionInput {
	s.ResourceShareArn = &v
	return s
}

type DisassociateResourceSharePermissionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A return value of true indicates that the request succeeded. A value of false
	// indicates that the request failed.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceSharePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceSharePermissionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *DisassociateResourceSharePermissionOutput) SetClientToken(v string) *DisassociateResourceSharePermissionOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *DisassociateResourceSharePermissionOutput) SetReturnValue(v bool) *DisassociateResourceSharePermissionOutput {
	s.ReturnValue = &v
	return s
}

type EnableSharingWithAwsOrganizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSharingWithAwsOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSharingWithAwsOrganizationInput) GoString() string {
	return s.String()
}

type EnableSharingWithAwsOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A return value of true indicates that the request succeeded. A value of false
	// indicates that the request failed.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSharingWithAwsOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableSharingWithAwsOrganizationOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *EnableSharingWithAwsOrganizationOutput) SetReturnValue(v bool) *EnableSharingWithAwsOrganizationOutput {
	s.ReturnValue = &v
	return s
}

type GetPermissionInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the permission whose contents you want to retrieve. To find the ARN for
	// a permission, use either the ListPermissions operation or go to the Permissions
	// library (https://console.aws.amazon.com/ram/home#Permissions:) page in the
	// RAM console and then choose the name of the permission. The ARN is displayed
	// on the detail page.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// Specifies the version number of the RAM permission to retrieve. If you don't
	// specify this parameter, the operation retrieves the default version.
	//
	// To see the list of available versions, use ListPermissionVersions.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPermissionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *GetPermissionInput) SetPermissionArn(v string) *GetPermissionInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *GetPermissionInput) SetPermissionVersion(v int64) *GetPermissionInput {
	s.PermissionVersion = &v
	return s
}

type GetPermissionOutput struct {
	_ struct{} `type:"structure"`

	// An object with details about the permission.
	Permission *ResourceSharePermissionDetail `locationName:"permission" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionOutput) GoString() string {
	return s.String()
}

// SetPermission sets the Permission field's value.
func (s *GetPermissionOutput) SetPermission(v *ResourceSharePermissionDetail) *GetPermissionOutput {
	s.Permission = v
	return s
}

type GetResourcePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the principal.
	Principal *string `locationName:"principal" type:"string"`

	// Specifies the Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resources whose policies you want to retrieve.
	//
	// ResourceArns is a required field
	ResourceArns []*string `locationName:"resourceArns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourcePoliciesInput) SetMaxResults(v int64) *GetResourcePoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesInput) SetNextToken(v string) *GetResourcePoliciesInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetResourcePoliciesInput) SetPrincipal(v string) *GetResourcePoliciesInput {
	s.Principal = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *GetResourcePoliciesInput) SetResourceArns(v []*string) *GetResourcePoliciesInput {
	s.ResourceArns = v
	return s
}

type GetResourcePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of resource policy documents in JSON format.
	Policies []*string `locationName:"policies" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourcePoliciesOutput) SetNextToken(v string) *GetResourcePoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *GetResourcePoliciesOutput) SetPolicies(v []*string) *GetResourcePoliciesOutput {
	s.Policies = v
	return s
}

type GetResourceShareAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies that you want to retrieve only associations that have this status.
	AssociationStatus *string `locationName:"associationStatus" type:"string" enum:"ResourceShareAssociationStatus"`

	// Specifies whether you want to retrieve the associations that involve a specified
	// resource or principal.
	//
	//    * PRINCIPAL – list the principals whose associations you want to see.
	//
	//    * RESOURCE – list the resources whose associations you want to see.
	//
	// AssociationType is a required field
	AssociationType *string `locationName:"associationType" type:"string" required:"true" enum:"ResourceShareAssociationType"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the ID of the principal whose resource shares you want to retrieve.
	// This can be an Amazon Web Services account ID, an organization ID, an organizational
	// unit ID, or the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an individual IAM user or role.
	//
	// You cannot specify this parameter if the association type is RESOURCE.
	Principal *string `locationName:"principal" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a resource whose resource shares you want to retrieve.
	//
	// You cannot specify this parameter if the association type is PRINCIPAL.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// Specifies a list of Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share whose associations you want to retrieve.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceShareAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceShareAssociationsInput"}
	if s.AssociationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *GetResourceShareAssociationsInput) SetAssociationStatus(v string) *GetResourceShareAssociationsInput {
	s.AssociationStatus = &v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *GetResourceShareAssociationsInput) SetAssociationType(v string) *GetResourceShareAssociationsInput {
	s.AssociationType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceShareAssociationsInput) SetMaxResults(v int64) *GetResourceShareAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareAssociationsInput) SetNextToken(v string) *GetResourceShareAssociationsInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *GetResourceShareAssociationsInput) SetPrincipal(v string) *GetResourceShareAssociationsInput {
	s.Principal = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourceShareAssociationsInput) SetResourceArn(v string) *GetResourceShareAssociationsInput {
	s.ResourceArn = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceShareAssociationsInput) SetResourceShareArns(v []*string) *GetResourceShareAssociationsInput {
	s.ResourceShareArns = v
	return s
}

type GetResourceShareAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain the details about the associations.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareAssociationsOutput) SetNextToken(v string) *GetResourceShareAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *GetResourceShareAssociationsOutput) SetResourceShareAssociations(v []*ResourceShareAssociation) *GetResourceShareAssociationsOutput {
	s.ResourceShareAssociations = v
	return s
}

type GetResourceShareInvitationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want details about invitations only for the resource shares
	// described by this list of Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// Specifies the Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share invitations you want information about.
	ResourceShareInvitationArns []*string `locationName:"resourceShareInvitationArns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceShareInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceShareInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceShareInvitationsInput) SetMaxResults(v int64) *GetResourceShareInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareInvitationsInput) SetNextToken(v string) *GetResourceShareInvitationsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceShareInvitationsInput) SetResourceShareArns(v []*string) *GetResourceShareInvitationsInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceShareInvitationArns sets the ResourceShareInvitationArns field's value.
func (s *GetResourceShareInvitationsInput) SetResourceShareInvitationArns(v []*string) *GetResourceShareInvitationsInput {
	s.ResourceShareInvitationArns = v
	return s
}

type GetResourceShareInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain the details about the invitations.
	ResourceShareInvitations []*ResourceShareInvitation `locationName:"resourceShareInvitations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceShareInvitationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceShareInvitationsOutput) SetNextToken(v string) *GetResourceShareInvitationsOutput {
	s.NextToken = &v
	return s
}

// SetResourceShareInvitations sets the ResourceShareInvitations field's value.
func (s *GetResourceShareInvitationsOutput) SetResourceShareInvitations(v []*ResourceShareInvitation) *GetResourceShareInvitationsOutput {
	s.ResourceShareInvitations = v
	return s
}

type GetResourceSharesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies the name of an individual resource share that you want to retrieve
	// details about.
	Name *string `locationName:"name" type:"string"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want to retrieve details of only those resource shares
	// that use the managed permission with this Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	PermissionArn *string `locationName:"permissionArn" type:"string"`

	// Specifies that you want to retrieve details for only those resource shares
	// that use the specified version of the managed permission.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`

	// Specifies that you want to retrieve details of only those resource shares
	// that match the following:
	//
	//    * SELF – resource shares that your account shares with other accounts
	//
	//    * OTHER-ACCOUNTS – resource shares that other accounts share with your
	//    account
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// Specifies the Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of individual resource shares that you want information about.
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// Specifies that you want to retrieve details of only those resource shares
	// that have this status.
	ResourceShareStatus *string `locationName:"resourceShareStatus" type:"string" enum:"ResourceShareStatus"`

	// Specifies that you want to retrieve details of only those resource shares
	// that match the specified tag keys and values.
	TagFilters []*TagFilter `locationName:"tagFilters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceSharesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetResourceSharesInput) SetMaxResults(v int64) *GetResourceSharesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourceSharesInput) SetName(v string) *GetResourceSharesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceSharesInput) SetNextToken(v string) *GetResourceSharesInput {
	s.NextToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *GetResourceSharesInput) SetPermissionArn(v string) *GetResourceSharesInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *GetResourceSharesInput) SetPermissionVersion(v int64) *GetResourceSharesInput {
	s.PermissionVersion = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *GetResourceSharesInput) SetResourceOwner(v string) *GetResourceSharesInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *GetResourceSharesInput) SetResourceShareArns(v []*string) *GetResourceSharesInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceShareStatus sets the ResourceShareStatus field's value.
func (s *GetResourceSharesInput) SetResourceShareStatus(v string) *GetResourceSharesInput {
	s.ResourceShareStatus = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *GetResourceSharesInput) SetTagFilters(v []*TagFilter) *GetResourceSharesInput {
	s.TagFilters = v
	return s
}

type GetResourceSharesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain the information about the resource shares.
	ResourceShares []*ResourceShare `locationName:"resourceShares" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceSharesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceSharesOutput) SetNextToken(v string) *GetResourceSharesOutput {
	s.NextToken = &v
	return s
}

// SetResourceShares sets the ResourceShares field's value.
func (s *GetResourceSharesOutput) SetResourceShares(v []*ResourceShare) *GetResourceSharesOutput {
	s.ResourceShares = v
	return s
}

// The operation failed because the client token input parameter matched one
// that was used with a previous call to the operation, but at least one of
// the other input parameters is different from the previous call.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified client token isn't valid.
type InvalidClientTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClientTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidClientTokenException(v protocol.ResponseMetadata) error {
	return &InvalidClientTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClientTokenException) Code() string {
	return "InvalidClientTokenException"
}

// Message returns the exception's message.
func (s *InvalidClientTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClientTokenException) OrigErr() error {
	return nil
}

func (s *InvalidClientTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClientTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClientTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified value for MaxResults isn't valid.
type InvalidMaxResultsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMaxResultsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidMaxResultsException) GoString() string {
	return s.String()
}

func newErrorInvalidMaxResultsException(v protocol.ResponseMetadata) error {
	return &InvalidMaxResultsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidMaxResultsException) Code() string {
	return "InvalidMaxResultsException"
}

// Message returns the exception's message.
func (s *InvalidMaxResultsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidMaxResultsException) OrigErr() error {
	return nil
}

func (s *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidMaxResultsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidMaxResultsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified value for NextToken isn't valid.
// You must specify a value you received in the NextToken response of a previous
// call to this operation.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a parameter you specified isn't valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a policy you specified isn't valid.
type InvalidPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPolicyException) Code() string {
	return "InvalidPolicyException"
}

// Message returns the exception's message.
func (s *InvalidPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPolicyException) OrigErr() error {
	return nil
}

func (s *InvalidPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified resource type isn't valid.
type InvalidResourceTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceTypeException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceTypeException(v protocol.ResponseMetadata) error {
	return &InvalidResourceTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceTypeException) Code() string {
	return "InvalidResourceTypeException"
}

// Message returns the exception's message.
func (s *InvalidResourceTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceTypeException) OrigErr() error {
	return nil
}

func (s *InvalidResourceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the requested operation isn't valid for the
// resource share in its current state.
type InvalidStateTransitionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateTransitionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateTransitionException) GoString() string {
	return s.String()
}

func newErrorInvalidStateTransitionException(v protocol.ResponseMetadata) error {
	return &InvalidStateTransitionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateTransitionException) Code() string {
	return "InvalidStateTransitionException"
}

// Message returns the exception's message.
func (s *InvalidStateTransitionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateTransitionException) OrigErr() error {
	return nil
}

func (s *InvalidStateTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateTransitionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateTransitionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPendingInvitationResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want the results to include only resources that have the
	// specified scope.
	//
	//    * ALL – the results include both global and regional resources or resource
	//    types.
	//
	//    * GLOBAL – the results include only global resources or resource types.
	//
	//    * REGIONAL – the results include only regional resources or resource
	//    types.
	//
	// The default value is ALL.
	ResourceRegionScope *string `locationName:"resourceRegionScope" type:"string" enum:"ResourceRegionScopeFilter"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the invitation. You can use GetResourceShareInvitations to find the ARN
	// of the invitation.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPendingInvitationResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPendingInvitationResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPendingInvitationResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPendingInvitationResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPendingInvitationResourcesInput) SetMaxResults(v int64) *ListPendingInvitationResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPendingInvitationResourcesInput) SetNextToken(v string) *ListPendingInvitationResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceRegionScope sets the ResourceRegionScope field's value.
func (s *ListPendingInvitationResourcesInput) SetResourceRegionScope(v string) *ListPendingInvitationResourcesInput {
	s.ResourceRegionScope = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *ListPendingInvitationResourcesInput) SetResourceShareInvitationArn(v string) *ListPendingInvitationResourcesInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type ListPendingInvitationResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain the information about the resources included
	// the specified resource share.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPendingInvitationResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPendingInvitationResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPendingInvitationResourcesOutput) SetNextToken(v string) *ListPendingInvitationResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListPendingInvitationResourcesOutput) SetResources(v []*Resource) *ListPendingInvitationResourcesOutput {
	s.Resources = v
	return s
}

type ListPermissionAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies that you want to list only those associations with resource shares
	// that match this status.
	AssociationStatus *string `locationName:"associationStatus" type:"string" enum:"ResourceShareAssociationStatus"`

	// When true, specifies that you want to list only those associations with resource
	// shares that use the default version of the specified managed permission.
	//
	// When false (the default value), lists associations with resource shares that
	// use any version of the specified managed permission.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// Specifies that you want to list only those associations with resource shares
	// that have a featureSet with this value.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"PermissionFeatureSet"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission.
	PermissionArn *string `locationName:"permissionArn" type:"string"`

	// Specifies that you want to list only those associations with resource shares
	// that use this version of the managed permission. If you don't provide a value
	// for this parameter, then the operation returns information about associations
	// with resource shares that use any version of the managed permission.
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer"`

	// Specifies that you want to list only those associations with resource shares
	// that include at least one resource of this resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *ListPermissionAssociationsInput) SetAssociationStatus(v string) *ListPermissionAssociationsInput {
	s.AssociationStatus = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *ListPermissionAssociationsInput) SetDefaultVersion(v bool) *ListPermissionAssociationsInput {
	s.DefaultVersion = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *ListPermissionAssociationsInput) SetFeatureSet(v string) *ListPermissionAssociationsInput {
	s.FeatureSet = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionAssociationsInput) SetMaxResults(v int64) *ListPermissionAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionAssociationsInput) SetNextToken(v string) *ListPermissionAssociationsInput {
	s.NextToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *ListPermissionAssociationsInput) SetPermissionArn(v string) *ListPermissionAssociationsInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *ListPermissionAssociationsInput) SetPermissionVersion(v int64) *ListPermissionAssociationsInput {
	s.PermissionVersion = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPermissionAssociationsInput) SetResourceType(v string) *ListPermissionAssociationsInput {
	s.ResourceType = &v
	return s
}

type ListPermissionAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A structure with information about this customer managed permission.
	Permissions []*AssociatedPermission `locationName:"permissions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionAssociationsOutput) SetNextToken(v string) *ListPermissionAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionAssociationsOutput) SetPermissions(v []*AssociatedPermission) *ListPermissionAssociationsOutput {
	s.Permissions = v
	return s
}

type ListPermissionVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the RAM permission whose versions you want to list. You can use the permissionVersion
	// parameter on the AssociateResourceSharePermission operation to specify a
	// non-default version to attach.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionVersionsInput) SetMaxResults(v int64) *ListPermissionVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionVersionsInput) SetNextToken(v string) *ListPermissionVersionsInput {
	s.NextToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *ListPermissionVersionsInput) SetPermissionArn(v string) *ListPermissionVersionsInput {
	s.PermissionArn = &v
	return s
}

type ListPermissionVersionsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain details for each of the available versions.
	Permissions []*ResourceSharePermissionSummary `locationName:"permissions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionVersionsOutput) SetNextToken(v string) *ListPermissionVersionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionVersionsOutput) SetPermissions(v []*ResourceSharePermissionSummary) *ListPermissionVersionsOutput {
	s.Permissions = v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want to list only permissions of this type:
	//
	//    * AWS – returns only Amazon Web Services managed permissions.
	//
	//    * LOCAL – returns only customer managed permissions
	//
	//    * ALL – returns both Amazon Web Services managed permissions and customer
	//    managed permissions.
	//
	// If you don't specify this parameter, the default is All.
	PermissionType *string `locationName:"permissionType" type:"string" enum:"PermissionTypeFilter"`

	// Specifies that you want to list only those permissions that apply to the
	// specified resource type. This parameter is not case sensitive.
	//
	// For example, to list only permissions that apply to Amazon EC2 subnets, specify
	// ec2:subnet. You can use the ListResourceTypes operation to get the specific
	// string required.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *ListPermissionsInput) SetPermissionType(v string) *ListPermissionsInput {
	s.PermissionType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPermissionsInput) SetResourceType(v string) *ListPermissionsInput {
	s.ResourceType = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects with information about the permissions.
	Permissions []*ResourceSharePermissionSummary `locationName:"permissions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionsOutput) SetPermissions(v []*ResourceSharePermissionSummary) *ListPermissionsOutput {
	s.Permissions = v
	return s
}

type ListPrincipalsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want to list information for only the listed principals.
	//
	// You can include the following values:
	//
	//    * An Amazon Web Services account ID, for example: 123456789012
	//
	//    * An Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of an organization in Organizations, for example: organizations::123456789012:organization/o-exampleorgid
	//
	//    * An ARN of an organizational unit (OU) in Organizations, for example:
	//    organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123
	//
	//    * An ARN of an IAM role, for example: iam::123456789012:role/rolename
	//
	//    * An ARN of an IAM user, for example: iam::123456789012user/username
	//
	// Not all resource types can be shared with IAM roles and users. For more information,
	// see Sharing with IAM roles and users (https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types)
	// in the Resource Access Manager User Guide.
	Principals []*string `locationName:"principals" type:"list"`

	// Specifies that you want to list principal information for the resource share
	// with the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// Specifies that you want to list information for only resource shares that
	// match the following:
	//
	//    * SELF – principals that your account is sharing resources with
	//
	//    * OTHER-ACCOUNTS – principals that are sharing resources with your account
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// Specifies that you want to list information for only principals associated
	// with the resource shares specified by a list the Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// Specifies that you want to list information for only principals associated
	// with resource shares that include the specified resource type.
	//
	// For a list of valid values, query the ListResourceTypes operation.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrincipalsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrincipalsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPrincipalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPrincipalsInput) SetMaxResults(v int64) *ListPrincipalsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalsInput) SetNextToken(v string) *ListPrincipalsInput {
	s.NextToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPrincipalsInput) SetPrincipals(v []*string) *ListPrincipalsInput {
	s.Principals = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListPrincipalsInput) SetResourceArn(v string) *ListPrincipalsInput {
	s.ResourceArn = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListPrincipalsInput) SetResourceOwner(v string) *ListPrincipalsInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *ListPrincipalsInput) SetResourceShareArns(v []*string) *ListPrincipalsInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListPrincipalsInput) SetResourceType(v string) *ListPrincipalsInput {
	s.ResourceType = &v
	return s
}

type ListPrincipalsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain the details about the principals.
	Principals []*Principal `locationName:"principals" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrincipalsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPrincipalsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPrincipalsOutput) SetNextToken(v string) *ListPrincipalsOutput {
	s.NextToken = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ListPrincipalsOutput) SetPrincipals(v []*Principal) *ListPrincipalsOutput {
	s.Principals = v
	return s
}

type ListReplacePermissionAssociationsWorkInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want to see only the details about requests with a status
	// that matches this value.
	Status *string `locationName:"status" type:"string" enum:"ReplacePermissionAssociationsWorkStatus"`

	// A list of IDs. These values come from the idfield of the replacePermissionAssociationsWorkstructure
	// returned by the ReplacePermissionAssociations operation.
	WorkIds []*string `locationName:"workIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplacePermissionAssociationsWorkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplacePermissionAssociationsWorkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReplacePermissionAssociationsWorkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReplacePermissionAssociationsWorkInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReplacePermissionAssociationsWorkInput) SetMaxResults(v int64) *ListReplacePermissionAssociationsWorkInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplacePermissionAssociationsWorkInput) SetNextToken(v string) *ListReplacePermissionAssociationsWorkInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListReplacePermissionAssociationsWorkInput) SetStatus(v string) *ListReplacePermissionAssociationsWorkInput {
	s.Status = &v
	return s
}

// SetWorkIds sets the WorkIds field's value.
func (s *ListReplacePermissionAssociationsWorkInput) SetWorkIds(v []*string) *ListReplacePermissionAssociationsWorkInput {
	s.WorkIds = v
	return s
}

type ListReplacePermissionAssociationsWorkOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of data structures that provide details of the matching work IDs.
	ReplacePermissionAssociationsWorks []*ReplacePermissionAssociationsWork `locationName:"replacePermissionAssociationsWorks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplacePermissionAssociationsWorkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReplacePermissionAssociationsWorkOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReplacePermissionAssociationsWorkOutput) SetNextToken(v string) *ListReplacePermissionAssociationsWorkOutput {
	s.NextToken = &v
	return s
}

// SetReplacePermissionAssociationsWorks sets the ReplacePermissionAssociationsWorks field's value.
func (s *ListReplacePermissionAssociationsWorkOutput) SetReplacePermissionAssociationsWorks(v []*ReplacePermissionAssociationsWork) *ListReplacePermissionAssociationsWorkOutput {
	s.ReplacePermissionAssociationsWorks = v
	return s
}

type ListResourceSharePermissionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share for which you want to retrieve the associated permissions.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSharePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSharePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceSharePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceSharePermissionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceSharePermissionsInput) SetMaxResults(v int64) *ListResourceSharePermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSharePermissionsInput) SetNextToken(v string) *ListResourceSharePermissionsInput {
	s.NextToken = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ListResourceSharePermissionsInput) SetResourceShareArn(v string) *ListResourceSharePermissionsInput {
	s.ResourceShareArn = &v
	return s
}

type ListResourceSharePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that describe the permissions associated with the resource
	// share.
	Permissions []*ResourceSharePermissionSummary `locationName:"permissions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSharePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceSharePermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceSharePermissionsOutput) SetNextToken(v string) *ListResourceSharePermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListResourceSharePermissionsOutput) SetPermissions(v []*ResourceSharePermissionSummary) *ListResourceSharePermissionsOutput {
	s.Permissions = v
	return s
}

type ListResourceTypesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want the results to include only resources that have the
	// specified scope.
	//
	//    * ALL – the results include both global and regional resources or resource
	//    types.
	//
	//    * GLOBAL – the results include only global resources or resource types.
	//
	//    * REGIONAL – the results include only regional resources or resource
	//    types.
	//
	// The default value is ALL.
	ResourceRegionScope *string `locationName:"resourceRegionScope" type:"string" enum:"ResourceRegionScopeFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceTypesInput) SetMaxResults(v int64) *ListResourceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceTypesInput) SetNextToken(v string) *ListResourceTypesInput {
	s.NextToken = &v
	return s
}

// SetResourceRegionScope sets the ResourceRegionScope field's value.
func (s *ListResourceTypesInput) SetResourceRegionScope(v string) *ListResourceTypesInput {
	s.ResourceRegionScope = &v
	return s
}

type ListResourceTypesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain information about the resource types that
	// can be shared using RAM.
	ResourceTypes []*ServiceNameAndResourceType `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourceTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceTypesOutput) SetNextToken(v string) *ListResourceTypesOutput {
	s.NextToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *ListResourceTypesOutput) SetResourceTypes(v []*ServiceNameAndResourceType) *ListResourceTypesOutput {
	s.ResourceTypes = v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included on each page
	// of the response. If you do not include this parameter, it defaults to a value
	// that is specific to the operation. If additional items exist beyond the number
	// you specify, the NextToken response element is returned with a value (not
	// null). Include the specified value as the NextToken request parameter in
	// the next call to the operation to get the next part of the results. Note
	// that the service might return fewer results than the maximum even when there
	// are more results available. You should check NextToken after every operation
	// to ensure that you receive all of the results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies that you want to list only the resource shares that are associated
	// with the specified principal.
	Principal *string `locationName:"principal" type:"string"`

	// Specifies that you want to list only the resource shares that include resources
	// with the specified Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	ResourceArns []*string `locationName:"resourceArns" type:"list"`

	// Specifies that you want to list only the resource shares that match the following:
	//
	//    * SELF – resources that your account shares with other accounts
	//
	//    * OTHER-ACCOUNTS – resources that other accounts share with your account
	//
	// ResourceOwner is a required field
	ResourceOwner *string `locationName:"resourceOwner" type:"string" required:"true" enum:"ResourceOwner"`

	// Specifies that you want the results to include only resources that have the
	// specified scope.
	//
	//    * ALL – the results include both global and regional resources or resource
	//    types.
	//
	//    * GLOBAL – the results include only global resources or resource types.
	//
	//    * REGIONAL – the results include only regional resources or resource
	//    types.
	//
	// The default value is ALL.
	ResourceRegionScope *string `locationName:"resourceRegionScope" type:"string" enum:"ResourceRegionScopeFilter"`

	// Specifies that you want to list only resources in the resource shares identified
	// by the specified Amazon Resource Names (ARNs) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	ResourceShareArns []*string `locationName:"resourceShareArns" type:"list"`

	// Specifies that you want to list only the resource shares that include resources
	// of the specified resource type.
	//
	// For valid values, query the ListResourceTypes operation.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *ListResourcesInput) SetPrincipal(v string) *ListResourcesInput {
	s.Principal = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListResourcesInput) SetResourceArns(v []*string) *ListResourcesInput {
	s.ResourceArns = v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListResourcesInput) SetResourceOwner(v string) *ListResourcesInput {
	s.ResourceOwner = &v
	return s
}

// SetResourceRegionScope sets the ResourceRegionScope field's value.
func (s *ListResourcesInput) SetResourceRegionScope(v string) *ListResourcesInput {
	s.ResourceRegionScope = &v
	return s
}

// SetResourceShareArns sets the ResourceShareArns field's value.
func (s *ListResourcesInput) SetResourceShareArns(v []*string) *ListResourcesInput {
	s.ResourceShareArns = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListResourcesInput) SetResourceType(v string) *ListResourcesInput {
	s.ResourceType = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain information about the resources.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

// The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// has a format that isn't valid.
type MalformedArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedArnException) GoString() string {
	return s.String()
}

func newErrorMalformedArnException(v protocol.ResponseMetadata) error {
	return &MalformedArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedArnException) Code() string {
	return "MalformedArnException"
}

// Message returns the exception's message.
func (s *MalformedArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedArnException) OrigErr() error {
	return nil
}

func (s *MalformedArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the policy template that you provided isn't
// valid.
type MalformedPolicyTemplateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyTemplateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedPolicyTemplateException) GoString() string {
	return s.String()
}

func newErrorMalformedPolicyTemplateException(v protocol.ResponseMetadata) error {
	return &MalformedPolicyTemplateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedPolicyTemplateException) Code() string {
	return "MalformedPolicyTemplateException"
}

// Message returns the exception's message.
func (s *MalformedPolicyTemplateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedPolicyTemplateException) OrigErr() error {
	return nil
}

func (s *MalformedPolicyTemplateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedPolicyTemplateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedPolicyTemplateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a required input parameter is missing.
type MissingRequiredParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingRequiredParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingRequiredParameterException) GoString() string {
	return s.String()
}

func newErrorMissingRequiredParameterException(v protocol.ResponseMetadata) error {
	return &MissingRequiredParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingRequiredParameterException) Code() string {
	return "MissingRequiredParameterException"
}

// Message returns the exception's message.
func (s *MissingRequiredParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingRequiredParameterException) OrigErr() error {
	return nil
}

func (s *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingRequiredParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingRequiredParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the requested operation isn't permitted.
type OperationNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOperationNotPermittedException(v protocol.ResponseMetadata) error {
	return &OperationNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotPermittedException) Code() string {
	return "OperationNotPermittedException"
}

// Message returns the exception's message.
func (s *OperationNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotPermittedException) OrigErr() error {
	return nil
}

func (s *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a permission with the specified name already
// exists in the requested Amazon Web Services Region. Choose a different name.
type PermissionAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorPermissionAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &PermissionAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PermissionAlreadyExistsException) Code() string {
	return "PermissionAlreadyExistsException"
}

// Message returns the exception's message.
func (s *PermissionAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PermissionAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *PermissionAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PermissionAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PermissionAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because it would exceed the maximum number of permissions
// you can create in each Amazon Web Services Region. To view the limits for
// your Amazon Web Services account, see the RAM page in the Service Quotas
// console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
type PermissionLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionLimitExceededException) GoString() string {
	return s.String()
}

func newErrorPermissionLimitExceededException(v protocol.ResponseMetadata) error {
	return &PermissionLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PermissionLimitExceededException) Code() string {
	return "PermissionLimitExceededException"
}

// Message returns the exception's message.
func (s *PermissionLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PermissionLimitExceededException) OrigErr() error {
	return nil
}

func (s *PermissionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PermissionLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PermissionLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because it would exceed the limit for the number of
// versions you can have for a permission. To view the limits for your Amazon
// Web Services account, see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
type PermissionVersionsLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionVersionsLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionVersionsLimitExceededException) GoString() string {
	return s.String()
}

func newErrorPermissionVersionsLimitExceededException(v protocol.ResponseMetadata) error {
	return &PermissionVersionsLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PermissionVersionsLimitExceededException) Code() string {
	return "PermissionVersionsLimitExceededException"
}

// Message returns the exception's message.
func (s *PermissionVersionsLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PermissionVersionsLimitExceededException) OrigErr() error {
	return nil
}

func (s *PermissionVersionsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PermissionVersionsLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PermissionVersionsLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a principal for use with Resource Access Manager.
type Principal struct {
	_ struct{} `type:"structure"`

	// The date and time when the principal was associated with the resource share.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates the relationship between the Amazon Web Services account the principal
	// belongs to and the account that owns the resource share:
	//
	//    * True – The two accounts belong to same organization.
	//
	//    * False – The two accounts do not belong to the same organization.
	External *bool `locationName:"external" type:"boolean"`

	// The ID of the principal that can be associated with a resource share.
	Id *string `locationName:"id" type:"string"`

	// The date and time when the association between the resource share and the
	// principal was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a resource share the principal is associated with.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Principal) SetCreationTime(v time.Time) *Principal {
	s.CreationTime = &v
	return s
}

// SetExternal sets the External field's value.
func (s *Principal) SetExternal(v bool) *Principal {
	s.External = &v
	return s
}

// SetId sets the Id field's value.
func (s *Principal) SetId(v string) *Principal {
	s.Id = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Principal) SetLastUpdatedTime(v time.Time) *Principal {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *Principal) SetResourceShareArn(v string) *Principal {
	s.ResourceShareArn = &v
	return s
}

type PromotePermissionCreatedFromPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies a name for the promoted customer managed permission.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the CREATED_FROM_POLICY permission that you want to promote. You can get
	// this Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// by calling the ListResourceSharePermissions operation.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromotePermissionCreatedFromPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromotePermissionCreatedFromPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromotePermissionCreatedFromPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromotePermissionCreatedFromPolicyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PromotePermissionCreatedFromPolicyInput) SetClientToken(v string) *PromotePermissionCreatedFromPolicyInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *PromotePermissionCreatedFromPolicyInput) SetName(v string) *PromotePermissionCreatedFromPolicyInput {
	s.Name = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *PromotePermissionCreatedFromPolicyInput) SetPermissionArn(v string) *PromotePermissionCreatedFromPolicyInput {
	s.PermissionArn = &v
	return s
}

type PromotePermissionCreatedFromPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about an RAM permission.
	Permission *ResourceSharePermissionSummary `locationName:"permission" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromotePermissionCreatedFromPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromotePermissionCreatedFromPolicyOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *PromotePermissionCreatedFromPolicyOutput) SetClientToken(v string) *PromotePermissionCreatedFromPolicyOutput {
	s.ClientToken = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *PromotePermissionCreatedFromPolicyOutput) SetPermission(v *ResourceSharePermissionSummary) *PromotePermissionCreatedFromPolicyOutput {
	s.Permission = v
	return s
}

type PromoteResourceShareCreatedFromPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share to promote.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `location:"querystring" locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromoteResourceShareCreatedFromPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromoteResourceShareCreatedFromPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromoteResourceShareCreatedFromPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromoteResourceShareCreatedFromPolicyInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *PromoteResourceShareCreatedFromPolicyInput) SetResourceShareArn(v string) *PromoteResourceShareCreatedFromPolicyInput {
	s.ResourceShareArn = &v
	return s
}

type PromoteResourceShareCreatedFromPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A return value of true indicates that the request succeeded. A value of false
	// indicates that the request failed.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromoteResourceShareCreatedFromPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromoteResourceShareCreatedFromPolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PromoteResourceShareCreatedFromPolicyOutput) SetReturnValue(v bool) *PromoteResourceShareCreatedFromPolicyOutput {
	s.ReturnValue = &v
	return s
}

type RejectResourceShareInvitationInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the invitation that you want to reject.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectResourceShareInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectResourceShareInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectResourceShareInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectResourceShareInvitationInput"}
	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *RejectResourceShareInvitationInput) SetClientToken(v string) *RejectResourceShareInvitationInput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *RejectResourceShareInvitationInput) SetResourceShareInvitationArn(v string) *RejectResourceShareInvitationInput {
	s.ResourceShareInvitationArn = &v
	return s
}

type RejectResourceShareInvitationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// An object that contains the details about the rejected invitation.
	ResourceShareInvitation *ResourceShareInvitation `locationName:"resourceShareInvitation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectResourceShareInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectResourceShareInvitationOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *RejectResourceShareInvitationOutput) SetClientToken(v string) *RejectResourceShareInvitationOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShareInvitation sets the ResourceShareInvitation field's value.
func (s *RejectResourceShareInvitationOutput) SetResourceShareInvitation(v *ResourceShareInvitation) *RejectResourceShareInvitationOutput {
	s.ResourceShareInvitation = v
	return s
}

type ReplacePermissionAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission that you want to replace.
	//
	// FromPermissionArn is a required field
	FromPermissionArn *string `locationName:"fromPermissionArn" type:"string" required:"true"`

	// Specifies that you want to updated the permissions for only those resource
	// shares that use the specified version of the managed permission.
	FromPermissionVersion *int64 `locationName:"fromPermissionVersion" type:"integer"`

	// Specifies the ARN of the managed permission that you want to associate with
	// resource shares in place of the one specified by fromPerssionArn and fromPermissionVersion.
	//
	// The operation always associates the version that is currently the default
	// for the specified managed permission.
	//
	// ToPermissionArn is a required field
	ToPermissionArn *string `locationName:"toPermissionArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplacePermissionAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplacePermissionAssociationsInput"}
	if s.FromPermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPermissionArn"))
	}
	if s.ToPermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPermissionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ReplacePermissionAssociationsInput) SetClientToken(v string) *ReplacePermissionAssociationsInput {
	s.ClientToken = &v
	return s
}

// SetFromPermissionArn sets the FromPermissionArn field's value.
func (s *ReplacePermissionAssociationsInput) SetFromPermissionArn(v string) *ReplacePermissionAssociationsInput {
	s.FromPermissionArn = &v
	return s
}

// SetFromPermissionVersion sets the FromPermissionVersion field's value.
func (s *ReplacePermissionAssociationsInput) SetFromPermissionVersion(v int64) *ReplacePermissionAssociationsInput {
	s.FromPermissionVersion = &v
	return s
}

// SetToPermissionArn sets the ToPermissionArn field's value.
func (s *ReplacePermissionAssociationsInput) SetToPermissionArn(v string) *ReplacePermissionAssociationsInput {
	s.ToPermissionArn = &v
	return s
}

type ReplacePermissionAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies a data structure that you can use to track the asynchronous tasks
	// that RAM performs to complete this operation. You can use the ListReplacePermissionAssociationsWork
	// operation and pass the id value returned in this structure.
	ReplacePermissionAssociationsWork *ReplacePermissionAssociationsWork `locationName:"replacePermissionAssociationsWork" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *ReplacePermissionAssociationsOutput) SetClientToken(v string) *ReplacePermissionAssociationsOutput {
	s.ClientToken = &v
	return s
}

// SetReplacePermissionAssociationsWork sets the ReplacePermissionAssociationsWork field's value.
func (s *ReplacePermissionAssociationsOutput) SetReplacePermissionAssociationsWork(v *ReplacePermissionAssociationsWork) *ReplacePermissionAssociationsOutput {
	s.ReplacePermissionAssociationsWork = v
	return s
}

// A structure that represents the background work that RAM performs when you
// invoke the ReplacePermissionAssociations operation.
type ReplacePermissionAssociationsWork struct {
	_ struct{} `type:"structure"`

	// The date and time when this asynchronous background task was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission that this background task is replacing.
	FromPermissionArn *string `locationName:"fromPermissionArn" type:"string"`

	// The version of the managed permission that this background task is replacing.
	FromPermissionVersion *string `locationName:"fromPermissionVersion" type:"string"`

	// The unique identifier for the background task associated with one ReplacePermissionAssociations
	// request.
	Id *string `locationName:"id" type:"string"`

	// The date and time when the status of this background task was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// Specifies the current status of the background tasks for the specified ID.
	// The output is one of the following strings:
	//
	//    * IN_PROGRESS
	//
	//    * COMPLETED
	//
	//    * FAILED
	Status *string `locationName:"status" type:"string" enum:"ReplacePermissionAssociationsWorkStatus"`

	// Specifies the reason for a FAILED status. This field is present only when
	// there status is FAILED.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The ARN of the managed permission that this background task is associating
	// with the resource shares in place of the managed permission and version specified
	// in fromPermissionArn and fromPermissionVersion.
	ToPermissionArn *string `locationName:"toPermissionArn" type:"string"`

	// The version of the managed permission that this background task is associating
	// with the resource shares. This is always the version that is currently the
	// default for this managed permission.
	ToPermissionVersion *string `locationName:"toPermissionVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsWork) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplacePermissionAssociationsWork) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReplacePermissionAssociationsWork) SetCreationTime(v time.Time) *ReplacePermissionAssociationsWork {
	s.CreationTime = &v
	return s
}

// SetFromPermissionArn sets the FromPermissionArn field's value.
func (s *ReplacePermissionAssociationsWork) SetFromPermissionArn(v string) *ReplacePermissionAssociationsWork {
	s.FromPermissionArn = &v
	return s
}

// SetFromPermissionVersion sets the FromPermissionVersion field's value.
func (s *ReplacePermissionAssociationsWork) SetFromPermissionVersion(v string) *ReplacePermissionAssociationsWork {
	s.FromPermissionVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReplacePermissionAssociationsWork) SetId(v string) *ReplacePermissionAssociationsWork {
	s.Id = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ReplacePermissionAssociationsWork) SetLastUpdatedTime(v time.Time) *ReplacePermissionAssociationsWork {
	s.LastUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplacePermissionAssociationsWork) SetStatus(v string) *ReplacePermissionAssociationsWork {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplacePermissionAssociationsWork) SetStatusMessage(v string) *ReplacePermissionAssociationsWork {
	s.StatusMessage = &v
	return s
}

// SetToPermissionArn sets the ToPermissionArn field's value.
func (s *ReplacePermissionAssociationsWork) SetToPermissionArn(v string) *ReplacePermissionAssociationsWork {
	s.ToPermissionArn = &v
	return s
}

// SetToPermissionVersion sets the ToPermissionVersion field's value.
func (s *ReplacePermissionAssociationsWork) SetToPermissionVersion(v string) *ReplacePermissionAssociationsWork {
	s.ToPermissionVersion = &v
	return s
}

// Describes a resource associated with a resource share in RAM.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the resource was associated with the resource share.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The date an time when the association between the resource and the resource
	// share was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource group. This value is available only if the resource is part
	// of a resource group.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	// Specifies the scope of visibility of this resource:
	//
	//    * REGIONAL – The resource can be accessed only by using requests that
	//    target the Amazon Web Services Region in which the resource exists.
	//
	//    * GLOBAL – The resource can be accessed from any Amazon Web Services
	//    Region.
	ResourceRegionScope *string `locationName:"resourceRegionScope" type:"string" enum:"ResourceRegionScope"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share this resource is associated with.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The current status of the resource.
	Status *string `locationName:"status" type:"string" enum:"ResourceStatus"`

	// A message about the status of the resource.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The resource type. This takes the form of: service-code:resource-code, and
	// is case-insensitive. For example, an Amazon EC2 Subnet would be represented
	// by the string ec2:subnet.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Resource) SetCreationTime(v time.Time) *Resource {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Resource) SetLastUpdatedTime(v time.Time) *Resource {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceGroupArn sets the ResourceGroupArn field's value.
func (s *Resource) SetResourceGroupArn(v string) *Resource {
	s.ResourceGroupArn = &v
	return s
}

// SetResourceRegionScope sets the ResourceRegionScope field's value.
func (s *Resource) SetResourceRegionScope(v string) *Resource {
	s.ResourceRegionScope = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *Resource) SetResourceShareArn(v string) *Resource {
	s.ResourceShareArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Resource) SetStatus(v string) *Resource {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Resource) SetStatusMessage(v string) *Resource {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// was not found.
type ResourceArnNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceArnNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceArnNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceArnNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceArnNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceArnNotFoundException) Code() string {
	return "ResourceArnNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceArnNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceArnNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceArnNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceArnNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a resource share in RAM.
type ResourceShare struct {
	_ struct{} `type:"structure"`

	// Indicates whether principals outside your organization in Organizations can
	// be associated with a resource share.
	//
	//    * True – the resource share can be shared with any Amazon Web Services
	//    account.
	//
	//    * False – the resource share can be shared with only accounts in the
	//    same organization as the account that owns the resource share.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// The date and time when the resource share was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates what features are available for this resource share. This parameter
	// can have one of the following values:
	//
	//    * STANDARD – A resource share that supports all functionality. These
	//    resource shares are visible to all principals you share the resource share
	//    with. You can modify these resource shares in RAM using the console or
	//    APIs. This resource share might have been created by RAM, or it might
	//    have been CREATED_FROM_POLICY and then promoted.
	//
	//    * CREATED_FROM_POLICY – The customer manually shared a resource by attaching
	//    a resource-based policy. That policy did not match any existing managed
	//    permissions, so RAM created this customer managed permission automatically
	//    on the customer's behalf based on the attached policy document. This type
	//    of resource share is visible only to the Amazon Web Services account that
	//    created it. You can't modify it in RAM unless you promote it. For more
	//    information, see PromoteResourceShareCreatedFromPolicy.
	//
	//    * PROMOTING_TO_STANDARD – This resource share was originally CREATED_FROM_POLICY,
	//    but the customer ran the PromoteResourceShareCreatedFromPolicy and that
	//    operation is still in progress. This value changes to STANDARD when complete.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"ResourceShareFeatureSet"`

	// The date and time when the resource share was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of the resource share.
	Name *string `locationName:"name" type:"string"`

	// The ID of the Amazon Web Services account that owns the resource share.
	OwningAccountId *string `locationName:"owningAccountId" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The current status of the resource share.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareStatus"`

	// A message about the status of the resource share.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The tag key and value pairs attached to the resource share.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShare) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShare) GoString() string {
	return s.String()
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *ResourceShare) SetAllowExternalPrincipals(v bool) *ResourceShare {
	s.AllowExternalPrincipals = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceShare) SetCreationTime(v time.Time) *ResourceShare {
	s.CreationTime = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *ResourceShare) SetFeatureSet(v string) *ResourceShare {
	s.FeatureSet = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceShare) SetLastUpdatedTime(v time.Time) *ResourceShare {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceShare) SetName(v string) *ResourceShare {
	s.Name = &v
	return s
}

// SetOwningAccountId sets the OwningAccountId field's value.
func (s *ResourceShare) SetOwningAccountId(v string) *ResourceShare {
	s.OwningAccountId = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShare) SetResourceShareArn(v string) *ResourceShare {
	s.ResourceShareArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShare) SetStatus(v string) *ResourceShare {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResourceShare) SetStatusMessage(v string) *ResourceShare {
	s.StatusMessage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceShare) SetTags(v []*Tag) *ResourceShare {
	s.Tags = v
	return s
}

// Describes an association between a resource share and either a principal
// or a resource.
type ResourceShareAssociation struct {
	_ struct{} `type:"structure"`

	// The associated entity. This can be either of the following:
	//
	//    * For a resource association, this is the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of the resource.
	//
	//    * For principal associations, this is one of the following: The ID of
	//    an Amazon Web Services account The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	//    of an organization in Organizations The ARN of an organizational unit
	//    (OU) in Organizations The ARN of an IAM role The ARN of an IAM user
	AssociatedEntity *string `locationName:"associatedEntity" type:"string"`

	// The type of entity included in this association.
	AssociationType *string `locationName:"associationType" type:"string" enum:"ResourceShareAssociationType"`

	// The date and time when the association was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Indicates whether the principal belongs to the same organization in Organizations
	// as the Amazon Web Services account that owns the resource share.
	External *bool `locationName:"external" type:"boolean"`

	// The date and time when the association was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// The name of the resource share.
	ResourceShareName *string `locationName:"resourceShareName" type:"string"`

	// The current status of the association.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareAssociationStatus"`

	// A message about the status of the association.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareAssociation) GoString() string {
	return s.String()
}

// SetAssociatedEntity sets the AssociatedEntity field's value.
func (s *ResourceShareAssociation) SetAssociatedEntity(v string) *ResourceShareAssociation {
	s.AssociatedEntity = &v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *ResourceShareAssociation) SetAssociationType(v string) *ResourceShareAssociation {
	s.AssociationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceShareAssociation) SetCreationTime(v time.Time) *ResourceShareAssociation {
	s.CreationTime = &v
	return s
}

// SetExternal sets the External field's value.
func (s *ResourceShareAssociation) SetExternal(v bool) *ResourceShareAssociation {
	s.External = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceShareAssociation) SetLastUpdatedTime(v time.Time) *ResourceShareAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShareAssociation) SetResourceShareArn(v string) *ResourceShareAssociation {
	s.ResourceShareArn = &v
	return s
}

// SetResourceShareName sets the ResourceShareName field's value.
func (s *ResourceShareAssociation) SetResourceShareName(v string) *ResourceShareAssociation {
	s.ResourceShareName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShareAssociation) SetStatus(v string) *ResourceShareAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResourceShareAssociation) SetStatusMessage(v string) *ResourceShareAssociation {
	s.StatusMessage = &v
	return s
}

// Describes an invitation for an Amazon Web Services account to join a resource
// share.
type ResourceShareInvitation struct {
	_ struct{} `type:"structure"`

	// The date and time when the invitation was sent.
	InvitationTimestamp *time.Time `locationName:"invitationTimestamp" type:"timestamp"`

	// The ID of the Amazon Web Services account that received the invitation.
	ReceiverAccountId *string `locationName:"receiverAccountId" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the IAM user or role that received the invitation.
	ReceiverArn *string `locationName:"receiverArn" type:"string"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// To view the resources associated with a pending resource share invitation,
	// use ListPendingInvitationResources.
	//
	// Deprecated: This member has been deprecated. Use ListPendingInvitationResources.
	ResourceShareAssociations []*ResourceShareAssociation `locationName:"resourceShareAssociations" deprecated:"true" type:"list"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the invitation.
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string"`

	// The name of the resource share.
	ResourceShareName *string `locationName:"resourceShareName" type:"string"`

	// The ID of the Amazon Web Services account that sent the invitation.
	SenderAccountId *string `locationName:"senderAccountId" type:"string"`

	// The current status of the invitation.
	Status *string `locationName:"status" type:"string" enum:"ResourceShareInvitationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitation) GoString() string {
	return s.String()
}

// SetInvitationTimestamp sets the InvitationTimestamp field's value.
func (s *ResourceShareInvitation) SetInvitationTimestamp(v time.Time) *ResourceShareInvitation {
	s.InvitationTimestamp = &v
	return s
}

// SetReceiverAccountId sets the ReceiverAccountId field's value.
func (s *ResourceShareInvitation) SetReceiverAccountId(v string) *ResourceShareInvitation {
	s.ReceiverAccountId = &v
	return s
}

// SetReceiverArn sets the ReceiverArn field's value.
func (s *ResourceShareInvitation) SetReceiverArn(v string) *ResourceShareInvitation {
	s.ReceiverArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *ResourceShareInvitation) SetResourceShareArn(v string) *ResourceShareInvitation {
	s.ResourceShareArn = &v
	return s
}

// SetResourceShareAssociations sets the ResourceShareAssociations field's value.
func (s *ResourceShareInvitation) SetResourceShareAssociations(v []*ResourceShareAssociation) *ResourceShareInvitation {
	s.ResourceShareAssociations = v
	return s
}

// SetResourceShareInvitationArn sets the ResourceShareInvitationArn field's value.
func (s *ResourceShareInvitation) SetResourceShareInvitationArn(v string) *ResourceShareInvitation {
	s.ResourceShareInvitationArn = &v
	return s
}

// SetResourceShareName sets the ResourceShareName field's value.
func (s *ResourceShareInvitation) SetResourceShareName(v string) *ResourceShareInvitation {
	s.ResourceShareName = &v
	return s
}

// SetSenderAccountId sets the SenderAccountId field's value.
func (s *ResourceShareInvitation) SetSenderAccountId(v string) *ResourceShareInvitation {
	s.SenderAccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceShareInvitation) SetStatus(v string) *ResourceShareInvitation {
	s.Status = &v
	return s
}

// The operation failed because the specified invitation was already accepted.
type ResourceShareInvitationAlreadyAcceptedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationAlreadyAcceptedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationAlreadyAcceptedException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationAlreadyAcceptedException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationAlreadyAcceptedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationAlreadyAcceptedException) Code() string {
	return "ResourceShareInvitationAlreadyAcceptedException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationAlreadyAcceptedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationAlreadyAcceptedException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationAlreadyAcceptedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationAlreadyAcceptedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationAlreadyAcceptedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified invitation was already rejected.
type ResourceShareInvitationAlreadyRejectedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationAlreadyRejectedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationAlreadyRejectedException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationAlreadyRejectedException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationAlreadyRejectedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationAlreadyRejectedException) Code() string {
	return "ResourceShareInvitationAlreadyRejectedException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationAlreadyRejectedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationAlreadyRejectedException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationAlreadyRejectedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationAlreadyRejectedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationAlreadyRejectedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// for an invitation was not found.
type ResourceShareInvitationArnNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationArnNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationArnNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationArnNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationArnNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationArnNotFoundException) Code() string {
	return "ResourceShareInvitationArnNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationArnNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationArnNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationArnNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationArnNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified invitation is past its expiration
// date and time.
type ResourceShareInvitationExpiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationExpiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareInvitationExpiredException) GoString() string {
	return s.String()
}

func newErrorResourceShareInvitationExpiredException(v protocol.ResponseMetadata) error {
	return &ResourceShareInvitationExpiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareInvitationExpiredException) Code() string {
	return "ResourceShareInvitationExpiredException"
}

// Message returns the exception's message.
func (s *ResourceShareInvitationExpiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareInvitationExpiredException) OrigErr() error {
	return nil
}

func (s *ResourceShareInvitationExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareInvitationExpiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareInvitationExpiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because it would exceed the limit for resource shares
// for your account. To view the limits for your Amazon Web Services account,
// see the RAM page in the Service Quotas console (https://console.aws.amazon.com/servicequotas/home/services/ram/quotas).
type ResourceShareLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceShareLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceShareLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceShareLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceShareLimitExceededException) Code() string {
	return "ResourceShareLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceShareLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceShareLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceShareLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceShareLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceShareLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a RAM managed permission.
type ResourceSharePermissionDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of this RAM managed permission.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the permission was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Specifies whether the version of the permission represented in this response
	// is the default version for this permission.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// Indicates what features are available for this resource share. This parameter
	// can have one of the following values:
	//
	//    * STANDARD – A resource share that supports all functionality. These
	//    resource shares are visible to all principals you share the resource share
	//    with. You can modify these resource shares in RAM using the console or
	//    APIs. This resource share might have been created by RAM, or it might
	//    have been CREATED_FROM_POLICY and then promoted.
	//
	//    * CREATED_FROM_POLICY – The customer manually shared a resource by attaching
	//    a resource-based policy. That policy did not match any existing managed
	//    permissions, so RAM created this customer managed permission automatically
	//    on the customer's behalf based on the attached policy document. This type
	//    of resource share is visible only to the Amazon Web Services account that
	//    created it. You can't modify it in RAM unless you promote it. For more
	//    information, see PromoteResourceShareCreatedFromPolicy.
	//
	//    * PROMOTING_TO_STANDARD – This resource share was originally CREATED_FROM_POLICY,
	//    but the customer ran the PromoteResourceShareCreatedFromPolicy and that
	//    operation is still in progress. This value changes to STANDARD when complete.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"PermissionFeatureSet"`

	// Specifies whether the version of the permission represented in this response
	// is the default version for all resources of this resource type.
	IsResourceTypeDefault *bool `locationName:"isResourceTypeDefault" type:"boolean"`

	// The date and time when the permission was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of this permission.
	Name *string `locationName:"name" type:"string"`

	// The permission's effect and actions in JSON format. The effect indicates
	// whether the specified actions are allowed or denied. The actions list the
	// operations to which the principal is granted or denied access.
	Permission *string `locationName:"permission" type:"string"`

	// The type of managed permission. This can be one of the following values:
	//
	//    * AWS_MANAGED – Amazon Web Services created and manages this managed
	//    permission. You can associate it with your resource shares, but you can't
	//    modify it.
	//
	//    * CUSTOMER_MANAGED – You, or another principal in your account created
	//    this managed permission. You can associate it with your resource shares
	//    and create new versions that have different permissions.
	PermissionType *string `locationName:"permissionType" type:"string" enum:"PermissionType"`

	// The resource type to which this permission applies.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The current status of the association between the permission and the resource
	// share. The following are the possible values:
	//
	//    * ATTACHABLE – This permission or version can be associated with resource
	//    shares.
	//
	//    * UNATTACHABLE – This permission or version can't currently be associated
	//    with resource shares.
	//
	//    * DELETING – This permission or version is in the process of being deleted.
	//
	//    * DELETED – This permission or version is deleted.
	Status *string `locationName:"status" type:"string" enum:"PermissionStatus"`

	// The tag key and value pairs attached to the resource share.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The version of the permission described in this response.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSharePermissionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSharePermissionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceSharePermissionDetail) SetArn(v string) *ResourceSharePermissionDetail {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceSharePermissionDetail) SetCreationTime(v time.Time) *ResourceSharePermissionDetail {
	s.CreationTime = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *ResourceSharePermissionDetail) SetDefaultVersion(v bool) *ResourceSharePermissionDetail {
	s.DefaultVersion = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *ResourceSharePermissionDetail) SetFeatureSet(v string) *ResourceSharePermissionDetail {
	s.FeatureSet = &v
	return s
}

// SetIsResourceTypeDefault sets the IsResourceTypeDefault field's value.
func (s *ResourceSharePermissionDetail) SetIsResourceTypeDefault(v bool) *ResourceSharePermissionDetail {
	s.IsResourceTypeDefault = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceSharePermissionDetail) SetLastUpdatedTime(v time.Time) *ResourceSharePermissionDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSharePermissionDetail) SetName(v string) *ResourceSharePermissionDetail {
	s.Name = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *ResourceSharePermissionDetail) SetPermission(v string) *ResourceSharePermissionDetail {
	s.Permission = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *ResourceSharePermissionDetail) SetPermissionType(v string) *ResourceSharePermissionDetail {
	s.PermissionType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSharePermissionDetail) SetResourceType(v string) *ResourceSharePermissionDetail {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceSharePermissionDetail) SetStatus(v string) *ResourceSharePermissionDetail {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceSharePermissionDetail) SetTags(v []*Tag) *ResourceSharePermissionDetail {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceSharePermissionDetail) SetVersion(v string) *ResourceSharePermissionDetail {
	s.Version = &v
	return s
}

// Information about an RAM permission.
type ResourceSharePermissionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the permission you want information about.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the permission was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// Specifies whether the version of the managed permission used by this resource
	// share is the default version for this managed permission.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// Indicates what features are available for this resource share. This parameter
	// can have one of the following values:
	//
	//    * STANDARD – A resource share that supports all functionality. These
	//    resource shares are visible to all principals you share the resource share
	//    with. You can modify these resource shares in RAM using the console or
	//    APIs. This resource share might have been created by RAM, or it might
	//    have been CREATED_FROM_POLICY and then promoted.
	//
	//    * CREATED_FROM_POLICY – The customer manually shared a resource by attaching
	//    a resource-based policy. That policy did not match any existing managed
	//    permissions, so RAM created this customer managed permission automatically
	//    on the customer's behalf based on the attached policy document. This type
	//    of resource share is visible only to the Amazon Web Services account that
	//    created it. You can't modify it in RAM unless you promote it. For more
	//    information, see PromoteResourceShareCreatedFromPolicy.
	//
	//    * PROMOTING_TO_STANDARD – This resource share was originally CREATED_FROM_POLICY,
	//    but the customer ran the PromoteResourceShareCreatedFromPolicy and that
	//    operation is still in progress. This value changes to STANDARD when complete.
	FeatureSet *string `locationName:"featureSet" type:"string" enum:"PermissionFeatureSet"`

	// Specifies whether the managed permission associated with this resource share
	// is the default managed permission for all resources of this resource type.
	IsResourceTypeDefault *bool `locationName:"isResourceTypeDefault" type:"boolean"`

	// The date and time when the permission was last updated.
	LastUpdatedTime *time.Time `locationName:"lastUpdatedTime" type:"timestamp"`

	// The name of this managed permission.
	Name *string `locationName:"name" type:"string"`

	// The type of managed permission. This can be one of the following values:
	//
	//    * AWS_MANAGED – Amazon Web Services created and manages this managed
	//    permission. You can associate it with your resource shares, but you can't
	//    modify it.
	//
	//    * CUSTOMER_MANAGED – You, or another principal in your account created
	//    this managed permission. You can associate it with your resource shares
	//    and create new versions that have different permissions.
	PermissionType *string `locationName:"permissionType" type:"string" enum:"PermissionType"`

	// The type of resource to which this permission applies. This takes the form
	// of: service-code:resource-code, and is case-insensitive. For example, an
	// Amazon EC2 Subnet would be represented by the string ec2:subnet.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The current status of the permission.
	Status *string `locationName:"status" type:"string"`

	// A list of the tag key value pairs currently attached to the permission.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The version of the permission associated with this resource share.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSharePermissionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSharePermissionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceSharePermissionSummary) SetArn(v string) *ResourceSharePermissionSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResourceSharePermissionSummary) SetCreationTime(v time.Time) *ResourceSharePermissionSummary {
	s.CreationTime = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *ResourceSharePermissionSummary) SetDefaultVersion(v bool) *ResourceSharePermissionSummary {
	s.DefaultVersion = &v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *ResourceSharePermissionSummary) SetFeatureSet(v string) *ResourceSharePermissionSummary {
	s.FeatureSet = &v
	return s
}

// SetIsResourceTypeDefault sets the IsResourceTypeDefault field's value.
func (s *ResourceSharePermissionSummary) SetIsResourceTypeDefault(v bool) *ResourceSharePermissionSummary {
	s.IsResourceTypeDefault = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ResourceSharePermissionSummary) SetLastUpdatedTime(v time.Time) *ResourceSharePermissionSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceSharePermissionSummary) SetName(v string) *ResourceSharePermissionSummary {
	s.Name = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *ResourceSharePermissionSummary) SetPermissionType(v string) *ResourceSharePermissionSummary {
	s.PermissionType = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceSharePermissionSummary) SetResourceType(v string) *ResourceSharePermissionSummary {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceSharePermissionSummary) SetStatus(v string) *ResourceSharePermissionSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceSharePermissionSummary) SetTags(v []*Tag) *ResourceSharePermissionSummary {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ResourceSharePermissionSummary) SetVersion(v string) *ResourceSharePermissionSummary {
	s.Version = &v
	return s
}

// The operation failed because the service could not respond to the request
// due to an internal problem. Try again later.
type ServerInternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerInternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerInternalException) GoString() string {
	return s.String()
}

func newErrorServerInternalException(v protocol.ResponseMetadata) error {
	return &ServerInternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerInternalException) Code() string {
	return "ServerInternalException"
}

// Message returns the exception's message.
func (s *ServerInternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerInternalException) OrigErr() error {
	return nil
}

func (s *ServerInternalException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerInternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerInternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a shareable resource type and the Amazon Web Services service
// to which resources of that type belong.
type ServiceNameAndResourceType struct {
	_ struct{} `type:"structure"`

	// Specifies the scope of visibility of resources of this type:
	//
	//    * REGIONAL – The resource can be accessed only by using requests that
	//    target the Amazon Web Services Region in which the resource exists.
	//
	//    * GLOBAL – The resource can be accessed from any Amazon Web Services
	//    Region.
	ResourceRegionScope *string `locationName:"resourceRegionScope" type:"string" enum:"ResourceRegionScope"`

	// The type of the resource. This takes the form of: service-code:resource-code,
	// and is case-insensitive. For example, an Amazon EC2 Subnet would be represented
	// by the string ec2:subnet.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// The name of the Amazon Web Services service to which resources of this type
	// belong.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNameAndResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceNameAndResourceType) GoString() string {
	return s.String()
}

// SetResourceRegionScope sets the ResourceRegionScope field's value.
func (s *ServiceNameAndResourceType) SetResourceRegionScope(v string) *ServiceNameAndResourceType {
	s.ResourceRegionScope = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ServiceNameAndResourceType) SetResourceType(v string) *ServiceNameAndResourceType {
	s.ResourceType = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceNameAndResourceType) SetServiceName(v string) *ServiceNameAndResourceType {
	s.ServiceName = &v
	return s
}

// The operation failed because the service isn't available. Try again later.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SetDefaultPermissionVersionInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the customer managed permission whose default version you want to change.
	//
	// PermissionArn is a required field
	PermissionArn *string `locationName:"permissionArn" type:"string" required:"true"`

	// Specifies the version number that you want to designate as the default for
	// customer managed permission. To see a list of all available version numbers,
	// use ListPermissionVersions.
	//
	// PermissionVersion is a required field
	PermissionVersion *int64 `locationName:"permissionVersion" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultPermissionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultPermissionVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultPermissionVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDefaultPermissionVersionInput"}
	if s.PermissionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionArn"))
	}
	if s.PermissionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SetDefaultPermissionVersionInput) SetClientToken(v string) *SetDefaultPermissionVersionInput {
	s.ClientToken = &v
	return s
}

// SetPermissionArn sets the PermissionArn field's value.
func (s *SetDefaultPermissionVersionInput) SetPermissionArn(v string) *SetDefaultPermissionVersionInput {
	s.PermissionArn = &v
	return s
}

// SetPermissionVersion sets the PermissionVersion field's value.
func (s *SetDefaultPermissionVersionInput) SetPermissionVersion(v int64) *SetDefaultPermissionVersionInput {
	s.PermissionVersion = &v
	return s
}

type SetDefaultPermissionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// A boolean value that indicates whether the operation was successful.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultPermissionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SetDefaultPermissionVersionOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *SetDefaultPermissionVersionOutput) SetClientToken(v string) *SetDefaultPermissionVersionOutput {
	s.ClientToken = &v
	return s
}

// SetReturnValue sets the ReturnValue field's value.
func (s *SetDefaultPermissionVersionOutput) SetReturnValue(v bool) *SetDefaultPermissionVersionOutput {
	s.ReturnValue = &v
	return s
}

// A structure containing a tag. A tag is metadata that you can attach to your
// resources to help organize and categorize them. You can also use them to
// help you secure your resources. For more information, see Controlling access
// to Amazon Web Services resources using tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
//
// For more information about tags, see Tagging Amazon Web Services resources
// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the Amazon
// Web Services General Reference Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key, or name, attached to the tag. Every tag must have a key. Key names
	// are case sensitive.
	Key *string `locationName:"key" type:"string"`

	// The string value attached to the tag. The value can be an empty string. Key
	// values are case sensitive.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A tag key and optional list of possible values that you can use to filter
// results for tagged resources.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag key. This must have a valid string value and can't be empty.
	TagKey *string `locationName:"tagKey" type:"string"`

	// A list of zero or more tag values. If no values are provided, then the filter
	// matches any tag with the specified key, regardless of its value.
	TagValues []*string `locationName:"tagValues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagFilter) GoString() string {
	return s.String()
}

// SetTagKey sets the TagKey field's value.
func (s *TagFilter) SetTagKey(v string) *TagFilter {
	s.TagKey = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *TagFilter) SetTagValues(v []*string) *TagFilter {
	s.TagValues = v
	return s
}

// The operation failed because it would exceed the limit for tags for your
// Amazon Web Services account.
type TagLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTagLimitExceededException(v protocol.ResponseMetadata) error {
	return &TagLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagLimitExceededException) Code() string {
	return "TagLimitExceededException"
}

// Message returns the exception's message.
func (s *TagLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagLimitExceededException) OrigErr() error {
	return nil
}

func (s *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because the specified tag key is a reserved word and
// can't be used.
type TagPolicyViolationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagPolicyViolationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagPolicyViolationException) GoString() string {
	return s.String()
}

func newErrorTagPolicyViolationException(v protocol.ResponseMetadata) error {
	return &TagPolicyViolationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagPolicyViolationException) Code() string {
	return "TagPolicyViolationException"
}

// Message returns the exception's message.
func (s *TagPolicyViolationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagPolicyViolationException) OrigErr() error {
	return nil
}

func (s *TagPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagPolicyViolationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagPolicyViolationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission that you want to add tags to. You must specify
	// either resourceArn, or resourceShareArn, but not both.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to add tags to. You must specify either
	// resourceShareArn, or resourceArn, but not both.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// A list of one or more tag key and value pairs. The tag key must be present
	// and not be an empty string. The tag value must be present but can be an empty
	// string.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *TagResourceInput) SetResourceShareArn(v string) *TagResourceInput {
	s.ResourceShareArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The operation failed because it exceeded the rate at which you are allowed
// to perform this operation. Please try again later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation failed because a specified resource couldn't be found.
type UnknownResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownResourceException) GoString() string {
	return s.String()
}

func newErrorUnknownResourceException(v protocol.ResponseMetadata) error {
	return &UnknownResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownResourceException) Code() string {
	return "UnknownResourceException"
}

// Message returns the exception's message.
func (s *UnknownResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownResourceException) OrigErr() error {
	return nil
}

func (s *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There isn't an existing managed permission defined in RAM that has the same
// IAM permissions as the resource-based policy attached to the resource. You
// should first run PromotePermissionCreatedFromPolicy to create that managed
// permission.
type UnmatchedPolicyPermissionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnmatchedPolicyPermissionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnmatchedPolicyPermissionException) GoString() string {
	return s.String()
}

func newErrorUnmatchedPolicyPermissionException(v protocol.ResponseMetadata) error {
	return &UnmatchedPolicyPermissionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnmatchedPolicyPermissionException) Code() string {
	return "UnmatchedPolicyPermissionException"
}

// Message returns the exception's message.
func (s *UnmatchedPolicyPermissionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnmatchedPolicyPermissionException) OrigErr() error {
	return nil
}

func (s *UnmatchedPolicyPermissionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnmatchedPolicyPermissionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnmatchedPolicyPermissionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the managed permission that you want to remove tags from. You must specify
	// either resourceArn, or resourceShareArn, but not both.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to remove tags from. The tags are removed
	// from the resource share, not the resources in the resource share. You must
	// specify either resourceShareArn, or resourceArn, but not both.
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string"`

	// Specifies a list of one or more tag keys that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *UntagResourceInput) SetResourceShareArn(v string) *UntagResourceInput {
	s.ResourceShareArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateResourceShareInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether principals outside your organization in Organizations can
	// be associated with a resource share.
	AllowExternalPrincipals *bool `locationName:"allowExternalPrincipals" type:"boolean"`

	// Specifies a unique, case-sensitive identifier that you provide to ensure
	// the idempotency of the request. This lets you safely retry the request without
	// accidentally performing the same operation a second time. Passing the same
	// value to a later call to an operation requires that you also pass the same
	// value for all other parameters. We recommend that you use a UUID type of
	// value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// If specified, the new name that you want to attach to the resource share.
	Name *string `locationName:"name" type:"string"`

	// Specifies the Amazon Resource Name (ARN) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the resource share that you want to modify.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceShareInput"}
	if s.ResourceShareArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowExternalPrincipals sets the AllowExternalPrincipals field's value.
func (s *UpdateResourceShareInput) SetAllowExternalPrincipals(v bool) *UpdateResourceShareInput {
	s.AllowExternalPrincipals = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResourceShareInput) SetClientToken(v string) *UpdateResourceShareInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceShareInput) SetName(v string) *UpdateResourceShareInput {
	s.Name = &v
	return s
}

// SetResourceShareArn sets the ResourceShareArn field's value.
func (s *UpdateResourceShareInput) SetResourceShareArn(v string) *UpdateResourceShareInput {
	s.ResourceShareArn = &v
	return s
}

type UpdateResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency identifier associated with this request. If you want to repeat
	// the same operation in an idempotent manner then you must include this value
	// in the clientToken request parameter of that later call. All other parameters
	// must also have the same values that you used in the first call.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Information about the resource share.
	ResourceShare *ResourceShare `locationName:"resourceShare" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceShareOutput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateResourceShareOutput) SetClientToken(v string) *UpdateResourceShareOutput {
	s.ClientToken = &v
	return s
}

// SetResourceShare sets the ResourceShare field's value.
func (s *UpdateResourceShareOutput) SetResourceShare(v *ResourceShare) *UpdateResourceShareOutput {
	s.ResourceShare = v
	return s
}

const (
	// PermissionFeatureSetCreatedFromPolicy is a PermissionFeatureSet enum value
	PermissionFeatureSetCreatedFromPolicy = "CREATED_FROM_POLICY"

	// PermissionFeatureSetPromotingToStandard is a PermissionFeatureSet enum value
	PermissionFeatureSetPromotingToStandard = "PROMOTING_TO_STANDARD"

	// PermissionFeatureSetStandard is a PermissionFeatureSet enum value
	PermissionFeatureSetStandard = "STANDARD"
)

// PermissionFeatureSet_Values returns all elements of the PermissionFeatureSet enum
func PermissionFeatureSet_Values() []string {
	return []string{
		PermissionFeatureSetCreatedFromPolicy,
		PermissionFeatureSetPromotingToStandard,
		PermissionFeatureSetStandard,
	}
}

const (
	// PermissionStatusAttachable is a PermissionStatus enum value
	PermissionStatusAttachable = "ATTACHABLE"

	// PermissionStatusUnattachable is a PermissionStatus enum value
	PermissionStatusUnattachable = "UNATTACHABLE"

	// PermissionStatusDeleting is a PermissionStatus enum value
	PermissionStatusDeleting = "DELETING"

	// PermissionStatusDeleted is a PermissionStatus enum value
	PermissionStatusDeleted = "DELETED"
)

// PermissionStatus_Values returns all elements of the PermissionStatus enum
func PermissionStatus_Values() []string {
	return []string{
		PermissionStatusAttachable,
		PermissionStatusUnattachable,
		PermissionStatusDeleting,
		PermissionStatusDeleted,
	}
}

const (
	// PermissionTypeCustomerManaged is a PermissionType enum value
	PermissionTypeCustomerManaged = "CUSTOMER_MANAGED"

	// PermissionTypeAwsManaged is a PermissionType enum value
	PermissionTypeAwsManaged = "AWS_MANAGED"
)

// PermissionType_Values returns all elements of the PermissionType enum
func PermissionType_Values() []string {
	return []string{
		PermissionTypeCustomerManaged,
		PermissionTypeAwsManaged,
	}
}

const (
	// PermissionTypeFilterAll is a PermissionTypeFilter enum value
	PermissionTypeFilterAll = "ALL"

	// PermissionTypeFilterAwsManaged is a PermissionTypeFilter enum value
	PermissionTypeFilterAwsManaged = "AWS_MANAGED"

	// PermissionTypeFilterCustomerManaged is a PermissionTypeFilter enum value
	PermissionTypeFilterCustomerManaged = "CUSTOMER_MANAGED"
)

// PermissionTypeFilter_Values returns all elements of the PermissionTypeFilter enum
func PermissionTypeFilter_Values() []string {
	return []string{
		PermissionTypeFilterAll,
		PermissionTypeFilterAwsManaged,
		PermissionTypeFilterCustomerManaged,
	}
}

const (
	// ReplacePermissionAssociationsWorkStatusInProgress is a ReplacePermissionAssociationsWorkStatus enum value
	ReplacePermissionAssociationsWorkStatusInProgress = "IN_PROGRESS"

	// ReplacePermissionAssociationsWorkStatusCompleted is a ReplacePermissionAssociationsWorkStatus enum value
	ReplacePermissionAssociationsWorkStatusCompleted = "COMPLETED"

	// ReplacePermissionAssociationsWorkStatusFailed is a ReplacePermissionAssociationsWorkStatus enum value
	ReplacePermissionAssociationsWorkStatusFailed = "FAILED"
)

// ReplacePermissionAssociationsWorkStatus_Values returns all elements of the ReplacePermissionAssociationsWorkStatus enum
func ReplacePermissionAssociationsWorkStatus_Values() []string {
	return []string{
		ReplacePermissionAssociationsWorkStatusInProgress,
		ReplacePermissionAssociationsWorkStatusCompleted,
		ReplacePermissionAssociationsWorkStatusFailed,
	}
}

const (
	// ResourceOwnerSelf is a ResourceOwner enum value
	ResourceOwnerSelf = "SELF"

	// ResourceOwnerOtherAccounts is a ResourceOwner enum value
	ResourceOwnerOtherAccounts = "OTHER-ACCOUNTS"
)

// ResourceOwner_Values returns all elements of the ResourceOwner enum
func ResourceOwner_Values() []string {
	return []string{
		ResourceOwnerSelf,
		ResourceOwnerOtherAccounts,
	}
}

const (
	// ResourceRegionScopeRegional is a ResourceRegionScope enum value
	ResourceRegionScopeRegional = "REGIONAL"

	// ResourceRegionScopeGlobal is a ResourceRegionScope enum value
	ResourceRegionScopeGlobal = "GLOBAL"
)

// ResourceRegionScope_Values returns all elements of the ResourceRegionScope enum
func ResourceRegionScope_Values() []string {
	return []string{
		ResourceRegionScopeRegional,
		ResourceRegionScopeGlobal,
	}
}

const (
	// ResourceRegionScopeFilterAll is a ResourceRegionScopeFilter enum value
	ResourceRegionScopeFilterAll = "ALL"

	// ResourceRegionScopeFilterRegional is a ResourceRegionScopeFilter enum value
	ResourceRegionScopeFilterRegional = "REGIONAL"

	// ResourceRegionScopeFilterGlobal is a ResourceRegionScopeFilter enum value
	ResourceRegionScopeFilterGlobal = "GLOBAL"
)

// ResourceRegionScopeFilter_Values returns all elements of the ResourceRegionScopeFilter enum
func ResourceRegionScopeFilter_Values() []string {
	return []string{
		ResourceRegionScopeFilterAll,
		ResourceRegionScopeFilterRegional,
		ResourceRegionScopeFilterGlobal,
	}
}

const (
	// ResourceShareAssociationStatusAssociating is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusAssociating = "ASSOCIATING"

	// ResourceShareAssociationStatusAssociated is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusAssociated = "ASSOCIATED"

	// ResourceShareAssociationStatusFailed is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusFailed = "FAILED"

	// ResourceShareAssociationStatusDisassociating is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusDisassociating = "DISASSOCIATING"

	// ResourceShareAssociationStatusDisassociated is a ResourceShareAssociationStatus enum value
	ResourceShareAssociationStatusDisassociated = "DISASSOCIATED"
)

// ResourceShareAssociationStatus_Values returns all elements of the ResourceShareAssociationStatus enum
func ResourceShareAssociationStatus_Values() []string {
	return []string{
		ResourceShareAssociationStatusAssociating,
		ResourceShareAssociationStatusAssociated,
		ResourceShareAssociationStatusFailed,
		ResourceShareAssociationStatusDisassociating,
		ResourceShareAssociationStatusDisassociated,
	}
}

const (
	// ResourceShareAssociationTypePrincipal is a ResourceShareAssociationType enum value
	ResourceShareAssociationTypePrincipal = "PRINCIPAL"

	// ResourceShareAssociationTypeResource is a ResourceShareAssociationType enum value
	ResourceShareAssociationTypeResource = "RESOURCE"
)

// ResourceShareAssociationType_Values returns all elements of the ResourceShareAssociationType enum
func ResourceShareAssociationType_Values() []string {
	return []string{
		ResourceShareAssociationTypePrincipal,
		ResourceShareAssociationTypeResource,
	}
}

const (
	// ResourceShareFeatureSetCreatedFromPolicy is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetCreatedFromPolicy = "CREATED_FROM_POLICY"

	// ResourceShareFeatureSetPromotingToStandard is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetPromotingToStandard = "PROMOTING_TO_STANDARD"

	// ResourceShareFeatureSetStandard is a ResourceShareFeatureSet enum value
	ResourceShareFeatureSetStandard = "STANDARD"
)

// ResourceShareFeatureSet_Values returns all elements of the ResourceShareFeatureSet enum
func ResourceShareFeatureSet_Values() []string {
	return []string{
		ResourceShareFeatureSetCreatedFromPolicy,
		ResourceShareFeatureSetPromotingToStandard,
		ResourceShareFeatureSetStandard,
	}
}

const (
	// ResourceShareInvitationStatusPending is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusPending = "PENDING"

	// ResourceShareInvitationStatusAccepted is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusAccepted = "ACCEPTED"

	// ResourceShareInvitationStatusRejected is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusRejected = "REJECTED"

	// ResourceShareInvitationStatusExpired is a ResourceShareInvitationStatus enum value
	ResourceShareInvitationStatusExpired = "EXPIRED"
)

// ResourceShareInvitationStatus_Values returns all elements of the ResourceShareInvitationStatus enum
func ResourceShareInvitationStatus_Values() []string {
	return []string{
		ResourceShareInvitationStatusPending,
		ResourceShareInvitationStatusAccepted,
		ResourceShareInvitationStatusRejected,
		ResourceShareInvitationStatusExpired,
	}
}

const (
	// ResourceShareStatusPending is a ResourceShareStatus enum value
	ResourceShareStatusPending = "PENDING"

	// ResourceShareStatusActive is a ResourceShareStatus enum value
	ResourceShareStatusActive = "ACTIVE"

	// ResourceShareStatusFailed is a ResourceShareStatus enum value
	ResourceShareStatusFailed = "FAILED"

	// ResourceShareStatusDeleting is a ResourceShareStatus enum value
	ResourceShareStatusDeleting = "DELETING"

	// ResourceShareStatusDeleted is a ResourceShareStatus enum value
	ResourceShareStatusDeleted = "DELETED"
)

// ResourceShareStatus_Values returns all elements of the ResourceShareStatus enum
func ResourceShareStatus_Values() []string {
	return []string{
		ResourceShareStatusPending,
		ResourceShareStatusActive,
		ResourceShareStatusFailed,
		ResourceShareStatusDeleting,
		ResourceShareStatusDeleted,
	}
}

const (
	// ResourceStatusAvailable is a ResourceStatus enum value
	ResourceStatusAvailable = "AVAILABLE"

	// ResourceStatusZonalResourceInaccessible is a ResourceStatus enum value
	ResourceStatusZonalResourceInaccessible = "ZONAL_RESOURCE_INACCESSIBLE"

	// ResourceStatusLimitExceeded is a ResourceStatus enum value
	ResourceStatusLimitExceeded = "LIMIT_EXCEEDED"

	// ResourceStatusUnavailable is a ResourceStatus enum value
	ResourceStatusUnavailable = "UNAVAILABLE"

	// ResourceStatusPending is a ResourceStatus enum value
	ResourceStatusPending = "PENDING"
)

// ResourceStatus_Values returns all elements of the ResourceStatus enum
func ResourceStatus_Values() []string {
	return []string{
		ResourceStatusAvailable,
		ResourceStatusZonalResourceInaccessible,
		ResourceStatusLimitExceeded,
		ResourceStatusUnavailable,
		ResourceStatusPending,
	}
}
