// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogProcessorsMetrics LogProcessorsMetrics
//
// swagger:model LogProcessorsMetrics
type LogProcessorsMetrics struct {
	BaseMetrics

	// Number of datasources per type
	// Required: true
	Datasources map[string]int64 `json:"datasources"`

	// hub items
	// Required: true
	HubItems HubItems `json:"hub_items"`

	// last push date
	LastPush int64 `json:"last_push,omitempty"`

	// last update date
	LastUpdate int64 `json:"last_update,omitempty"`

	// name of the log processor
	Name string `json:"name,omitempty"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *LogProcessorsMetrics) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 BaseMetrics
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.BaseMetrics = aO0

	// AO1
	var dataAO1 struct {
		Datasources map[string]int64 `json:"datasources"`

		HubItems HubItems `json:"hub_items"`

		LastPush int64 `json:"last_push,omitempty"`

		LastUpdate int64 `json:"last_update,omitempty"`

		Name string `json:"name,omitempty"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.Datasources = dataAO1.Datasources

	m.HubItems = dataAO1.HubItems

	m.LastPush = dataAO1.LastPush

	m.LastUpdate = dataAO1.LastUpdate

	m.Name = dataAO1.Name

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m LogProcessorsMetrics) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.BaseMetrics)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		Datasources map[string]int64 `json:"datasources"`

		HubItems HubItems `json:"hub_items"`

		LastPush int64 `json:"last_push,omitempty"`

		LastUpdate int64 `json:"last_update,omitempty"`

		Name string `json:"name,omitempty"`
	}

	dataAO1.Datasources = m.Datasources

	dataAO1.HubItems = m.HubItems

	dataAO1.LastPush = m.LastPush

	dataAO1.LastUpdate = m.LastUpdate

	dataAO1.Name = m.Name

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this log processors metrics
func (m *LogProcessorsMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BaseMetrics
	if err := m.BaseMetrics.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatasources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHubItems(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogProcessorsMetrics) validateDatasources(formats strfmt.Registry) error {

	if err := validate.Required("datasources", "body", m.Datasources); err != nil {
		return err
	}

	return nil
}

func (m *LogProcessorsMetrics) validateHubItems(formats strfmt.Registry) error {

	if err := validate.Required("hub_items", "body", m.HubItems); err != nil {
		return err
	}

	if m.HubItems != nil {
		if err := m.HubItems.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hub_items")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("hub_items")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log processors metrics based on the context it is used
func (m *LogProcessorsMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BaseMetrics
	if err := m.BaseMetrics.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHubItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogProcessorsMetrics) contextValidateHubItems(ctx context.Context, formats strfmt.Registry) error {

	if err := m.HubItems.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("hub_items")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("hub_items")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogProcessorsMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogProcessorsMetrics) UnmarshalBinary(b []byte) error {
	var res LogProcessorsMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
